/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.intellij.openapi.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubBuildCachedValuesManager;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValueProvider;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.stubs.Endpoint;
import com.jetbrains.python.psi.stubs.PyVersionSpecificStub;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u001e\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001a\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010#\u001a\u00020$H\u0000\u001a\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020$H\u0002\" \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"getChildrenStubs", "", "Lcom/intellij/psi/stubs/StubElement;", "stub", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "evaluateVersionsForElement", "Lcom/google/common/collect/ImmutableRangeSet;", "Lcom/intellij/openapi/util/Version;", "element", "Lcom/intellij/psi/PsiElement;", "EVAL_VERSIONS_PROVIDER", "Lcom/intellij/psi/stubs/StubBuildCachedValuesManager$StubBuildCachedValueProvider;", "evaluateVersionRangeForIfStatementPart", "Lcom/google/common/collect/RangeSet;", "ifStatement", "Lcom/jetbrains/python/psi/PyIfStatement;", "ifStatementPart", "convertToVersionRanges", "ifPart", "Lcom/jetbrains/python/psi/PyIfPart;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "serializeVersions", "", "versions", "outputStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "serializeRange", "range", "Lcom/google/common/collect/Range;", "serializeEndpoint", "endpoint", "Lcom/jetbrains/python/psi/impl/stubs/Endpoint;", "deserializeVersions", "stream", "Lcom/intellij/psi/stubs/StubInputStream;", "deserializeRange", "deserializeEndpoint", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyVersionSpecificStubBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVersionSpecificStubBase.kt\ncom/jetbrains/python/psi/impl/stubs/PyVersionSpecificStubBaseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class PyVersionSpecificStubBaseKt {
    @NotNull
    private static final StubBuildCachedValuesManager.StubBuildCachedValueProvider<ImmutableRangeSet<Version>, PsiElement> EVAL_VERSIONS_PROVIDER = new StubBuildCachedValuesManager.StubBuildCachedValueProvider("python.versionsForElement", PyVersionSpecificStubBaseKt::EVAL_VERSIONS_PROVIDER$lambda$0);

    @NotNull
    public static final Iterable<StubElement<?>> getChildrenStubs(@NotNull StubElement<?> stub, @NotNull LanguageLevel languageLevel) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)languageLevel, (String)"languageLevel");
        Version version = new Version(languageLevel.getMajorVersion(), languageLevel.getMinorVersion(), 0);
        List list = stub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
        return SequencesKt.asIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> PyVersionSpecificStubBaseKt.getChildrenStubs$lambda$0(version, arg_0)));
    }

    @NotNull
    public static final ImmutableRangeSet<Version> evaluateVersionsForElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (ImmutableRangeSet)StubBuildCachedValuesManager.getCachedValueStubBuildOptimized((PsiElement)element, EVAL_VERSIONS_PROVIDER);
    }

    private static final RangeSet<Version> evaluateVersionRangeForIfStatementPart(PyIfStatement ifStatement, PsiElement ifStatementPart) {
        TreeRangeSet treeRangeSet;
        boolean bl;
        boolean bl2 = bl = ifStatementPart instanceof PyIfPart || ifStatementPart instanceof PyElsePart;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (ifStatementPart instanceof PyIfPart) {
            ImmutableRangeSet<Version> immutableRangeSet = PyVersionSpecificStubBaseKt.convertToVersionRanges((PyIfPart)ifStatementPart);
            if (immutableRangeSet == null) {
                return null;
            }
            ImmutableRangeSet<Version> versionRanges = immutableRangeSet;
            treeRangeSet = TreeRangeSet.create((RangeSet)((RangeSet)versionRanges));
        } else {
            treeRangeSet = TreeRangeSet.create((Iterable)CollectionsKt.listOf((Object)Range.all()));
        }
        TreeRangeSet treeRangeSet2 = treeRangeSet;
        Intrinsics.checkNotNull((Object)treeRangeSet2);
        TreeRangeSet result = treeRangeSet2;
        Sequence sequence = SequencesKt.sequenceOf((Object)ifStatement.getIfPart());
        PyIfPart[] pyIfPartArray = ifStatement.getElifParts();
        Intrinsics.checkNotNullExpressionValue((Object)pyIfPartArray, (String)"getElifParts(...)");
        Sequence ifParts = SequencesKt.plus((Sequence)sequence, (Sequence)ArraysKt.asSequence((Object[])pyIfPartArray));
        for (PyIfPart ifPart : SequencesKt.takeWhile((Sequence)ifParts, arg_0 -> PyVersionSpecificStubBaseKt.evaluateVersionRangeForIfStatementPart$lambda$0(ifStatementPart, arg_0))) {
            ImmutableRangeSet<Version> versionRanges;
            Intrinsics.checkNotNull((Object)ifPart);
            if (PyVersionSpecificStubBaseKt.convertToVersionRanges(ifPart) == null) {
                return null;
            }
            result.removeAll((RangeSet)versionRanges);
        }
        return (RangeSet)result;
    }

    private static final ImmutableRangeSet<Version> convertToVersionRanges(PyIfPart ifPart) {
        ImmutableRangeSet<Version> immutableRangeSet;
        PyExpression pyExpression = (PyExpression)ifPart.getCondition();
        if (pyExpression != null) {
            PyExpression it = pyExpression;
            boolean bl = false;
            immutableRangeSet = PyVersionSpecificStubBaseKt.convertToVersionRanges(it);
        } else {
            immutableRangeSet = null;
        }
        return immutableRangeSet;
    }

    private static final ImmutableRangeSet<Version> convertToVersionRanges(PyExpression expression) {
        PyExpression pyExpression = PyPsiUtils.flattenParens((PyExpression)expression);
        PyBinaryExpression pyBinaryExpression = pyExpression instanceof PyBinaryExpression ? (PyBinaryExpression)pyExpression : null;
        if (pyBinaryExpression == null) {
            return null;
        }
        PyBinaryExpression binaryExpr = pyBinaryExpression;
        PyElementType operator = binaryExpr.getOperator();
        if (Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.AND_KEYWORD) || Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.OR_KEYWORD)) {
            PyExpression pyExpression2 = binaryExpr.getRightExpression();
            if (pyExpression2 == null) {
                return null;
            }
            PyExpression rhs = pyExpression2;
            PyExpression pyExpression3 = binaryExpr.getLeftExpression();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression3, (String)"getLeftExpression(...)");
            ImmutableRangeSet<Version> immutableRangeSet = PyVersionSpecificStubBaseKt.convertToVersionRanges(pyExpression3);
            if (immutableRangeSet == null) {
                return null;
            }
            ImmutableRangeSet<Version> ranges1 = immutableRangeSet;
            ImmutableRangeSet<Version> immutableRangeSet2 = PyVersionSpecificStubBaseKt.convertToVersionRanges(rhs);
            if (immutableRangeSet2 == null) {
                return null;
            }
            ImmutableRangeSet<Version> ranges2 = immutableRangeSet2;
            return operator == PyTokenTypes.AND_KEYWORD ? ranges1.intersection((RangeSet)ranges2) : ranges1.union((RangeSet)ranges2);
        }
        if (Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.LT) || Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.GT) || Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.LE) || Intrinsics.areEqual((Object)operator, (Object)PyTokenTypes.GE)) {
            Range range;
            int n;
            if (!PyEvaluator.isSysVersionInfoExpression(binaryExpr.getLeftExpression())) {
                return null;
            }
            int[] nArray = PyEvaluator.evaluateAsVersion(binaryExpr.getRightExpression());
            if (nArray == null) {
                return null;
            }
            int[] versionArray = nArray;
            Integer n2 = ArraysKt.firstOrNull((int[])versionArray);
            if (n2 == null) {
                return null;
            }
            int major = n2;
            int[] nArray2 = versionArray;
            int n3 = 1;
            if (n3 < nArray2.length) {
                n = nArray2[n3];
            } else {
                int it = n3;
                boolean bl = false;
                n = 0;
            }
            int minor = n;
            Version version = new Version(major, minor, 0);
            PyElementType pyElementType = operator;
            if (Intrinsics.areEqual((Object)pyElementType, (Object)PyTokenTypes.LT)) {
                range = Range.lessThan((Comparable)((Comparable)version));
            } else if (Intrinsics.areEqual((Object)pyElementType, (Object)PyTokenTypes.GT)) {
                range = Range.greaterThan((Comparable)((Comparable)version));
            } else if (Intrinsics.areEqual((Object)pyElementType, (Object)PyTokenTypes.LE)) {
                range = Range.atMost((Comparable)((Comparable)version));
            } else if (Intrinsics.areEqual((Object)pyElementType, (Object)PyTokenTypes.GE)) {
                range = Range.atLeast((Comparable)((Comparable)version));
            } else {
                throw new IllegalStateException();
            }
            Range range2 = range;
            Intrinsics.checkNotNull((Object)range2);
            Range range3 = range2;
            return ImmutableRangeSet.of((Range)range3);
        }
        return null;
    }

    public static final void serializeVersions(@NotNull RangeSet<Version> versions, @NotNull StubOutputStream outputStream) {
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Set set = versions.asRanges();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"asRanges(...)");
        Set ranges = set;
        outputStream.writeVarInt(ranges.size());
        for (Object e : ranges) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Range range = (Range)e;
            PyVersionSpecificStubBaseKt.serializeRange((Range<Version>)range, outputStream);
        }
    }

    private static final void serializeRange(Range<Version> range, StubOutputStream outputStream) {
        Endpoint endpoint;
        Endpoint low;
        if (range.hasLowerBound()) {
            Comparable comparable = range.lowerEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"lowerEndpoint(...)");
            Version version = (Version)comparable;
            BoundType boundType = range.lowerBoundType();
            Intrinsics.checkNotNullExpressionValue((Object)boundType, (String)"lowerBoundType(...)");
            v3 = new Endpoint(version, boundType);
        } else {
            v3 = low = null;
        }
        if (range.hasUpperBound()) {
            Comparable comparable = range.upperEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"upperEndpoint(...)");
            Version version = (Version)comparable;
            BoundType boundType = range.upperBoundType();
            Intrinsics.checkNotNullExpressionValue((Object)boundType, (String)"upperBoundType(...)");
            endpoint = new Endpoint(version, boundType);
        } else {
            endpoint = null;
        }
        Endpoint high = endpoint;
        PyVersionSpecificStubBaseKt.serializeEndpoint(low, outputStream);
        PyVersionSpecificStubBaseKt.serializeEndpoint(high, outputStream);
    }

    private static final void serializeEndpoint(Endpoint endpoint, StubOutputStream outputStream) {
        if (endpoint == null) {
            outputStream.writeByte(0);
        } else {
            int endpointType = switch (WhenMappings.$EnumSwitchMapping$0[endpoint.getBoundType().ordinal()]) {
                case 1 -> 1;
                case 2 -> 2;
                default -> throw new NoWhenBranchMatchedException();
            };
            outputStream.writeByte(endpointType);
            outputStream.writeVarInt(endpoint.getVersion().major);
            outputStream.writeVarInt(endpoint.getVersion().minor);
        }
    }

    @NotNull
    public static final RangeSet<Version> deserializeVersions(@NotNull StubInputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        int size = stream.readVarInt();
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ImmutableRangeSet.Builder builder2 = builder;
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl = false;
            builder2.add(PyVersionSpecificStubBaseKt.deserializeRange(stream));
        }
        ImmutableRangeSet immutableRangeSet = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableRangeSet, (String)"build(...)");
        return (RangeSet)immutableRangeSet;
    }

    private static final Range<Version> deserializeRange(StubInputStream stream) {
        Range range;
        Endpoint low = PyVersionSpecificStubBaseKt.deserializeEndpoint(stream);
        Endpoint high = PyVersionSpecificStubBaseKt.deserializeEndpoint(stream);
        if (low != null && high != null) {
            Range range2 = Range.range((Comparable)((Comparable)low.getVersion()), (BoundType)low.getBoundType(), (Comparable)((Comparable)high.getVersion()), (BoundType)high.getBoundType());
            range = range2;
            Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"range(...)");
        } else if (high != null) {
            Range range3 = Range.upTo((Comparable)((Comparable)high.getVersion()), (BoundType)high.getBoundType());
            range = range3;
            Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"upTo(...)");
        } else if (low != null) {
            Range range4 = Range.downTo((Comparable)((Comparable)low.getVersion()), (BoundType)low.getBoundType());
            range = range4;
            Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"downTo(...)");
        } else {
            Range range5 = Range.all();
            range = range5;
            Intrinsics.checkNotNullExpressionValue((Object)range5, (String)"all(...)");
        }
        return range;
    }

    private static final Endpoint deserializeEndpoint(StubInputStream stream) {
        BoundType boundType;
        byte endpointType = stream.readByte();
        switch (endpointType) {
            case 0: {
                return null;
            }
            case 1: {
                boundType = BoundType.OPEN;
                break;
            }
            case 2: {
                boundType = BoundType.CLOSED;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        BoundType boundType2 = boundType;
        int major = stream.readVarInt();
        int minor = stream.readVarInt();
        return new Endpoint(new Version(major, minor, 0), boundType2);
    }

    private static final boolean getChildrenStubs$lambda$0(Version $version, StubElement it) {
        return !(it instanceof PyVersionSpecificStub) || ((PyVersionSpecificStub)it).getVersions().contains((Comparable)$version);
    }

    private static final CachedValueProvider.Result EVAL_VERSIONS_PROVIDER$lambda$0(PsiElement element) {
        PsiElement parent = element.getParent();
        ImmutableRangeSet result = null;
        if (parent == null) {
            ImmutableRangeSet immutableRangeSet = ImmutableRangeSet.of((Range)Range.all());
            Intrinsics.checkNotNullExpressionValue((Object)immutableRangeSet, (String)"of(...)");
            result = immutableRangeSet;
        } else {
            RangeSet<Version> versions;
            PsiElement grandParent;
            result = PyVersionSpecificStubBaseKt.evaluateVersionsForElement(parent);
            if ((parent instanceof PyIfPart || parent instanceof PyElsePart) && (grandParent = ((PyStatementPart)parent).getParent()) instanceof PyIfStatement && element == ((PyStatementPart)parent).getStatementList() && (versions = PyVersionSpecificStubBaseKt.evaluateVersionRangeForIfStatementPart((PyIfStatement)grandParent, parent)) != null) {
                ImmutableRangeSet immutableRangeSet = result.intersection(versions);
                Intrinsics.checkNotNullExpressionValue((Object)immutableRangeSet, (String)"intersection(...)");
                result = immutableRangeSet;
            }
        }
        Object[] objectArray = new Object[]{element};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }

    private static final boolean evaluateVersionRangeForIfStatementPart$lambda$0(PsiElement $ifStatementPart, PyIfPart it) {
        return it != $ifStatementPart;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BoundType.values().length];
            try {
                nArray[BoundType.OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BoundType.CLOSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

