/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterListOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassAttributesIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyResolveUtil {
    private PyResolveUtil() {
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement element, @Nullable String name, @Nullable PsiElement roof) {
        PyArgumentList superclassList;
        PyClass pyClass;
        PyAnnotation annotation;
        PyFunction function;
        PsiFile globalScope;
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(1);
        }
        ScopeOwner originalOwner = ScopeUtil.getScopeOwner(element);
        PsiElement parent = element.getParent();
        ScopeOwner owner = originalOwner;
        if (parent instanceof PyNonlocalStatement) {
            if (owner == roof) {
                return;
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)owner)) == null) {
                return;
            }
        } else if (parent instanceof PyGlobalStatement && (globalScope = element.getContainingFile()) instanceof PyFile) {
            owner = (PyFile)globalScope;
        }
        if (owner instanceof PyFunction && (function = (PyFunction)owner).getTypeParameterList() != null && PsiTreeUtil.getParentOfType((PsiElement)(annotation = (PyAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class)), PyFunction.class, (boolean)true, (Class[])new Class[]{PyStatement.class}) == function) {
            originalOwner = ScopeUtil.getScopeOwner((PsiElement)function);
        }
        if (owner instanceof PyClass && (pyClass = (PyClass)owner).getTypeParameterList() != null && (superclassList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class)) != null && superclassList.getParent() == pyClass) {
            originalOwner = ScopeUtil.getScopeOwner((PsiElement)pyClass);
        }
        PyResolveUtil.scopeCrawlUp(processor2, owner, originalOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull ScopeOwner scopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(2);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(3);
        }
        PyResolveUtil.scopeCrawlUp(processor2, scopeOwner, scopeOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @Nullable ScopeOwner scopeOwner, @Nullable ScopeOwner originalScopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(4);
        }
        while (scopeOwner != null) {
            Collection<PsiNamedElement> namedElements;
            Scope scope = ControlFlowCache.getScope(scopeOwner);
            if (name != null) {
                boolean includeNestedGlobals = scopeOwner instanceof PyFile;
                namedElements = scope.getNamedElements(name, includeNestedGlobals);
            } else {
                namedElements = scope.getNamedElements();
            }
            Iterable elements = Iterables.concat((Iterable)Iterables.filter(namedElements, t -> !(t instanceof PyTypeParameter)), scope.getImportedNameDefiners(), (Iterable)Iterables.filter(namedElements, PyTypeParameter.class));
            for (PsiElement element : elements) {
                if (PyResolveUtil.isClassLevelDefinitionInvisibleToReference(element, scopeOwner, originalScopeOwner) || processor2.execute(element, ResolveState.initial())) continue;
                return;
            }
            if (scopeOwner == roof) {
                return;
            }
            if (name != null && scopeOwner instanceof PyClass && scopeOwner == originalScopeOwner) {
                scopeOwner = PyResolveUtil.parentScopeForUnresolvedClassLevelName((PyClass)scopeOwner, name);
                continue;
            }
            scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
        }
    }

    private static boolean isClassLevelDefinitionInvisibleToReference(@NotNull PsiElement definition, @NotNull ScopeOwner definitionScope, @Nullable ScopeOwner referenceScope) {
        PyClass pyClass;
        if (definition == null) {
            PyResolveUtil.$$$reportNull$$$0(5);
        }
        if (definitionScope == null) {
            PyResolveUtil.$$$reportNull$$$0(6);
        }
        return definitionScope instanceof PyClass && (pyClass = (PyClass)definitionScope) != referenceScope && !(definition instanceof PyTypeParameter);
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        String referenceName;
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(7);
        }
        if ((referenceName = referenceExpression.getName()) == null || referenceExpression.isQualified()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referenceName, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)referenceExpression, referenceName, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull ScopeOwner scopeOwner, @NotNull String name) {
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(11);
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(name, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, scopeOwner, name, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public static List<QualifiedName> resolveImportedElementQNameLocally(@NotNull PyReferenceExpression expression) {
        PyExpression qualifier;
        if (expression == null) {
            PyResolveUtil.$$$reportNull$$$0(13);
        }
        if ((qualifier = expression.getQualifier()) instanceof PyReferenceExpression) {
            String name = expression.getName();
            List list = name == null ? Collections.emptyList() : ContainerUtil.map(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)qualifier), qn -> qn.append(name));
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        List result = PyResolveUtil.fullMultiResolveLocally(expression, new HashSet<PyReferenceExpression>()).select(PyImportElement.class).map(PyResolveUtil::getImportedElementQName).nonNull().toList();
        if (!result.isEmpty()) {
            List list = result;
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (expression.getName() == null) {
            List list = result;
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        PsiFile containingFile = expression.getContainingFile();
        if (!(containingFile instanceof PyFile)) {
            List list = result;
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        List fromImports = ((PyFile)containingFile).getFromImports();
        List list = ((StreamEx)StreamEx.of((Collection)fromImports).filter(it -> it.isStarImport())).map(it -> it.getImportSourceQName()).nonNull().map(it -> it.append(expression.getName())).toList();
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Nullable
    private static QualifiedName getImportedElementQName(@NotNull PyImportElement element) {
        PyStatement importStatement;
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(19);
        }
        if ((importStatement = element.getContainingImportStatement()) instanceof PyFromImportStatement) {
            QualifiedName importSourceQName = ((PyFromImportStatement)importStatement).getImportSourceQName();
            QualifiedName importedQName = element.getImportedQName();
            if (importSourceQName != null && importedQName != null) {
                return importSourceQName.append(importedQName);
            }
        }
        return element.getImportedQName();
    }

    @NotNull
    public static List<PsiElement> resolveQualifiedNameInScope(@NotNull QualifiedName qualifiedName, @NotNull ScopeOwner scopeOwner, @NotNull TypeEvalContext context) {
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(20);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PyResolveUtil.$$$reportNull$$$0(22);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)scopeOwner, Pair.create((Object)qualifiedName, (Object)context), param -> PyResolveUtil.doResolveQualifiedNameInScope((QualifiedName)param.getFirst(), scopeOwner, (TypeEvalContext)param.getSecond()));
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> doResolveQualifiedNameInScope(@NotNull QualifiedName qualifiedName, @NotNull ScopeOwner scopeOwner, @NotNull TypeEvalContext context) {
        String firstName;
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(24);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyResolveUtil.$$$reportNull$$$0(26);
        }
        if ((firstName = qualifiedName.getFirstComponent()) == null || !(scopeOwner instanceof PyTypedElement)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        ArrayList<Object> unqualifiedResults = new ArrayList<Object>();
        ScopeOwner curScope = scopeOwner;
        while (curScope != null) {
            unqualifiedResults.addAll(PyResolveUtil.resolveShortNameInSingleScope(curScope, firstName, resolveContext));
            curScope = ScopeUtil.getScopeOwner((PsiElement)curScope);
        }
        if (unqualifiedResults.isEmpty()) {
            PsiElement builtin = PyBuiltinCache.getInstance((PsiElement)scopeOwner).getByName(firstName);
            if (builtin == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PyResolveUtil.$$$reportNull$$$0(28);
                }
                return list;
            }
            unqualifiedResults.add(new RatedResolveResult(0, builtin));
        }
        List remainingNames = qualifiedName.removeHead(1).getComponents();
        List result = ((StreamEx)StreamEx.of((Collection)remainingNames).foldLeft((Object)StreamEx.of(unqualifiedResults), (prev, name) -> prev.map(RatedResolveResult::getElement).select(PyTypedElement.class).map(arg_0 -> ((TypeEvalContext)context).getType(arg_0)).nonNull().flatMap(type -> {
            List<? extends RatedResolveResult> list;
            PyType instanceType;
            assert (type != null);
            Object object = instanceType = type instanceof PyClassLikeType ? ((PyClassLikeType)type).toInstance() : type;
            if (instanceType instanceof PyModuleType) {
                PyModuleType moduleType = (PyModuleType)instanceType;
                list = moduleType.resolveModuleMember((String)name, (PsiElement)scopeOwner, AccessDirection.READ, resolveContext);
            } else {
                list = instanceType.resolveMember(name, null, AccessDirection.READ, resolveContext);
            }
            List<? extends RatedResolveResult> results = list;
            return results != null ? StreamEx.of(results) : StreamEx.empty();
        }))).toList();
        List<PsiElement> list = PyUtil.filterTopPriorityElements(result);
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    private static List<? extends RatedResolveResult> resolveShortNameInSingleScope(@NotNull ScopeOwner scopeOwner, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(30);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(31);
        }
        if (resolveContext == null) {
            PyResolveUtil.$$$reportNull$$$0(32);
        }
        if (scopeOwner instanceof PyiFile) {
            PyiFile fileScope = (PyiFile)scopeOwner;
            List<RatedResolveResult> list = fileScope.multiResolveName(name, false);
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        if (scopeOwner instanceof PyFunction) {
            PyFunction functionScope = (PyFunction)scopeOwner;
            StreamEx targets = ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)scopeOwner, PyTargetExpression.class)).filter(it -> !it.isQualified())).select(PsiNamedElement.class);
            StreamEx parameters = StreamEx.of((Object[])functionScope.getParameterList().getParameters()).select(PsiNamedElement.class);
            List list = ((StreamEx)((StreamEx)StreamEx.of((Stream)targets).append((Stream)parameters)).filter(it -> name.equals(it.getName()))).map(it -> new RatedResolveResult(0, (PsiElement)it)).append(PyResolveUtil.resolveTypeParameters((PyTypeParameterListOwner)functionScope, name)).toList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(34);
            }
            return list;
        }
        if (scopeOwner instanceof PyTypeAliasStatement) {
            return PyResolveUtil.resolveTypeParameters((PyTypeParameterListOwner)scopeOwner, name);
        }
        PyType scopeType = resolveContext.getTypeEvalContext().getType((PyTypedElement)scopeOwner);
        if (scopeType == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(35);
            }
            return list;
        }
        List typeMembers = scopeType.resolveMember(name, null, AccessDirection.READ, resolveContext);
        if (scopeOwner instanceof PyClass) {
            PyClass pyClass = (PyClass)scopeOwner;
            List list = ContainerUtil.concat((List)ContainerUtil.notNullize((List)typeMembers), PyResolveUtil.resolveTypeParameters((PyTypeParameterListOwner)pyClass, name));
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        List list = ContainerUtil.notNullize((List)typeMembers);
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Nullable
    public static String resolveStrArgument(@NotNull PyCallExpression callExpression, int index, @NotNull String keyword) {
        if (callExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(38);
        }
        if (keyword == null) {
            PyResolveUtil.$$$reportNull$$$0(39);
        }
        PyExpression argument = (PyExpression)callExpression.getArgument(index, keyword, PyExpression.class);
        return PyResolveUtil.resolveStrArgument(argument);
    }

    @Nullable
    public static String resolveStrArgument(@Nullable PyExpression argument) {
        PyExpression expression = PyPsiUtils.flattenParens((PyExpression)argument);
        if (expression instanceof PyReferenceExpression) {
            return PyPsiUtils.strValue((PyExpression)PyResolveUtil.fullResolveLocally((PyReferenceExpression)expression));
        }
        return PyPsiUtils.strValue((PyExpression)expression);
    }

    @Nullable
    public static PyExpression fullResolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(40);
        }
        return PyResolveUtil.fullMultiResolveLocally(referenceExpression, new HashSet<PyReferenceExpression>()).select(PyExpression.class).findFirst().orElse(null);
    }

    @NotNull
    private static StreamEx<PsiElement> fullMultiResolveLocally(@NotNull PyReferenceExpression referenceExpression, @NotNull Set<PyReferenceExpression> visited) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(41);
        }
        if (visited == null) {
            PyResolveUtil.$$$reportNull$$$0(42);
        }
        StreamEx streamEx = StreamEx.of(PyResolveUtil.resolveLocally(referenceExpression)).flatMap(element -> {
            if (element instanceof PyTargetExpression) {
                PyExpression assignedValue = ((PyTargetExpression)element).findAssignedValue();
                if (assignedValue instanceof PyReferenceExpression && visited.add((PyReferenceExpression)assignedValue)) {
                    return PyResolveUtil.fullMultiResolveLocally((PyReferenceExpression)assignedValue, visited);
                }
                return StreamEx.of((Object)assignedValue);
            }
            return StreamEx.of((Object)element);
        });
        if (streamEx == null) {
            PyResolveUtil.$$$reportNull$$$0(43);
        }
        return streamEx;
    }

    public static boolean allowForwardReferences(@NotNull PyQualifiedExpression element) {
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(44);
        }
        if (PyiUtil.isInsideStub((PsiElement)element)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile) {
            boolean isReferenceFromTypeParameterList;
            boolean insideAnnotation;
            PyFile pyFile = (PyFile)file;
            boolean nonEagerEvaluationEnabled = pyFile.hasImportFromFuture(FutureFeature.ANNOTATIONS) || pyFile.getLanguageLevel().isAtLeast(LanguageLevel.PYTHON314);
            boolean bl = insideAnnotation = PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class) != null;
            if (insideAnnotation && nonEagerEvaluationEnabled) {
                return true;
            }
            boolean bl2 = isReferenceFromTypeParameterList = PsiTreeUtil.getParentOfType((PsiElement)element, PyTypeParameter.class, (boolean)true) != null;
            if (isReferenceFromTypeParameterList) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ScopeOwner parentScopeForUnresolvedClassLevelName(@NotNull PyClass cls, @NotNull String name) {
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(45);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(46);
        }
        return PyResolveUtil.containsDeclaration(cls, name) ? (ScopeOwner)PyUtil.as(cls.getContainingFile(), PyFile.class) : ScopeUtil.getScopeOwner((PsiElement)cls);
    }

    private static boolean containsDeclaration(@NotNull PyClass cls, @NotNull String name) {
        Scope scope;
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(47);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(48);
        }
        if (!(scope = ControlFlowCache.getScope((ScopeOwner)cls)).getNamedElements(name, false).isEmpty()) {
            return true;
        }
        return StreamEx.of(scope.getImportedNameDefiners()).select(PyImportElement.class).anyMatch(e -> name.equals(e.getVisibleName()));
    }

    public static void addImplicitResolveResults(@NotNull String referencedName, @NotNull ResolveResultList ret, @NotNull PyQualifiedExpression element) {
        if (referencedName == null) {
            PyResolveUtil.$$$reportNull$$$0(49);
        }
        if (ret == null) {
            PyResolveUtil.$$$reportNull$$$0(50);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(51);
        }
        Project project = element.getProject();
        GlobalSearchScope scope = PySearchUtilBase.excludeSdkTestsScope(project);
        Collection<PyFunction> functions = PyFunctionNameIndex.find(referencedName, project, scope);
        PsiFile containingFile = element.getContainingFile();
        List<Object> imports = containingFile instanceof PyFile ? PyResolveUtil.collectImports((PyFile)containingFile) : Collections.emptyList();
        for (PyFunction function : functions) {
            if (function.getContainingClass() == null) continue;
            ret.add(new ImplicitResolveResult((PsiElement)function, PyResolveUtil.getImplicitResultRate((PyElement)function, imports, element)));
        }
        PyClassAttributesIndex.findClassAndInstanceAttributes(referencedName, project, scope).forEach(attribute -> ret.add(new ImplicitResolveResult((PsiElement)attribute, PyResolveUtil.getImplicitResultRate((PyElement)attribute, imports, element))));
    }

    private static List<QualifiedName> collectImports(PyFile containingFile) {
        ArrayList<QualifiedName> imports = new ArrayList<QualifiedName>();
        for (PyFromImportStatement anImport : containingFile.getFromImports()) {
            QualifiedName source = anImport.getImportSourceQName();
            if (source == null) continue;
            imports.add(source);
        }
        for (PyImportElement importElement : containingFile.getImportTargets()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            imports.add(qName.removeLastComponent());
        }
        return imports;
    }

    private static int getImplicitResultRate(PyElement target, List<QualifiedName> imports, PyQualifiedExpression element) {
        int rate = -1000;
        if (target.getContainingFile() == element.getContainingFile()) {
            rate += 200;
        } else {
            VirtualFile vFile = target.getContainingFile().getVirtualFile();
            if (vFile != null) {
                QualifiedName qName;
                if (ProjectScope.getProjectScope((Project)element.getProject()).contains(vFile)) {
                    rate += 80;
                }
                if ((qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)element, vFile)) != null && imports.contains(qName)) {
                    rate += 70;
                }
            }
        }
        if (element.getParent() instanceof PyCallExpression) {
            if (target instanceof PyFunction) {
                rate += 50;
            }
        } else if (!(target instanceof PyFunction)) {
            rate += 50;
        }
        return rate;
    }

    @NotNull
    public static @NotNull List<@NotNull PsiElement> multiResolveDeclaration(@NotNull PsiReference reference, @NotNull PyResolveContext resolveContext) {
        PyQualifiedNameOwner pyQualifiedNameOwner;
        PyClassType type;
        PyCallExpression call;
        if (reference == null) {
            PyResolveUtil.$$$reportNull$$$0(52);
        }
        if (resolveContext == null) {
            PyResolveUtil.$$$reportNull$$$0(53);
        }
        PsiElement element = reference.getElement();
        TypeEvalContext context = resolveContext.getTypeEvalContext();
        PyCallExpression pyCallExpression = call = context.maySwitchToAST(element) ? PyCallExpressionNavigator.getPyCallExpressionByCallee(element) : null;
        if (call != null && element instanceof PyTypedElement && (type = PyUtil.as(context.getType((PyTypedElement)element), PyClassType.class)) != null && type.isDefinition() && (pyQualifiedNameOwner = type.getDeclarationElement()) instanceof PyClass) {
            PyClass cls = (PyClass)pyQualifiedNameOwner;
            PsiElement constructor = (PsiElement)ContainerUtil.find(PyUtil.filterTopPriorityElements(PyCallExpressionHelper.resolveImplicitlyInvokedMethods(type, (PyCallSiteExpression)call, resolveContext)), it -> {
                PyPossibleClassMember possibleClassMember;
                return it instanceof PyPossibleClassMember && (possibleClassMember = (PyPossibleClassMember)it).getContainingClass() == cls;
            });
            if (constructor != null) {
                List<PsiElement> list = List.of(constructor);
                if (list == null) {
                    PyResolveUtil.$$$reportNull$$$0(54);
                }
                return list;
            }
        }
        if (reference instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference multiReference = (PsiPolyVariantReference)reference;
            List<PsiElement> list = PyUtil.multiResolveTopPriority(multiReference);
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(55);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(56);
        }
        return list;
    }

    @Nullable
    public static PsiElement resolveDeclaration(@NotNull PsiReference reference, @NotNull PyResolveContext resolveContext) {
        if (reference == null) {
            PyResolveUtil.$$$reportNull$$$0(57);
        }
        if (resolveContext == null) {
            PyResolveUtil.$$$reportNull$$$0(58);
        }
        return (PsiElement)ContainerUtil.getFirstItem(PyResolveUtil.multiResolveDeclaration(reference, resolveContext));
    }

    @NotNull
    private static List<RatedResolveResult> resolveTypeParameters(@NotNull PyTypeParameterListOwner typeParameterListOwner, @NotNull String name) {
        if (typeParameterListOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(59);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(60);
        }
        if (typeParameterListOwner.getTypeParameterList() != null) {
            List list = ((StreamEx)StreamEx.of((Collection)typeParameterListOwner.getTypeParameterList().getTypeParameters()).filter(it -> name.equals(it.getName()))).map(it -> new RatedResolveResult(0, (PsiElement)it)).toList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(61);
            }
            return list;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(62);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 14, 15, 16, 17, 18, 23, 27, 28, 29, 33, 34, 35, 36, 37, 43, 54, 55, 56, 61, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 19: 
            case 44: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 10: 
            case 21: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionScope";
                break;
            }
            case 7: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 11: 
            case 31: 
            case 46: 
            case 48: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: 
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ret";
                break;
            }
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterListOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportedElementQNameLocally";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInScope";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedNameInScope";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveShortNameInSingleScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "fullMultiResolveLocally";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveDeclaration";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeCrawlUp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClassLevelDefinitionInvisibleToReference";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 62: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportedElementQNameLocally";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportedElementQName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInScope";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedNameInScope";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveShortNameInSingleScope";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveStrArgument";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fullResolveLocally";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fullMultiResolveLocally";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "allowForwardReferences";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "parentScopeForUnresolvedClassLevelName";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaration";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitResolveResults";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveDeclaration";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "resolveDeclaration";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 14, 15, 16, 17, 18, 23, 27, 28, 29, 33, 34, 35, 36, 37, 43, 54, 55, 56, 61, 62 -> new IllegalStateException(string);
        };
    }
}

