/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableParameterListTypeImpl;
import com.jetbrains.python.psi.types.PyCallableParameterVariadicType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PyPositionalVariadicType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyVariadicType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeParameterMapping {
    private final List<Couple<PyType>> myMappedTypes;

    private PyTypeParameterMapping(@NotNull List<Couple<PyType>> mapping) {
        if (mapping == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(0);
        }
        for (Couple<PyType> couple : mapping) {
            PyType expectedType = (PyType)couple.getFirst();
            PyType actualType = (PyType)couple.getSecond();
            if (expectedType == null || actualType == null || !(expectedType instanceof PyPositionalVariadicType ^ actualType instanceof PyPositionalVariadicType) && !(expectedType instanceof PyCallableParameterVariadicType ^ actualType instanceof PyCallableParameterVariadicType)) continue;
            throw new IllegalArgumentException("Mapping of incompatible types: " + String.valueOf(expectedType) + " -> " + String.valueOf(actualType));
        }
        this.myMappedTypes = mapping;
    }

    @Nullable
    public static PyTypeParameterMapping mapByShape(@NotNull List<? extends PyType> expectedTypes, @NotNull List<? extends PyType> actualTypes, Option ... options) {
        PyType actualUnpackedTupleType;
        PyType unpackedTupleType;
        PyType rightmostActual;
        PyType rightmostExpected;
        PyType leftmostExpected;
        if (expectedTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(1);
        }
        if (actualTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(2);
        }
        if (options == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(3);
        }
        EnumSet<Option> optionSet = EnumSet.noneOf(Option.class);
        optionSet.addAll(Arrays.asList(options));
        List<PyType> normalizedExpectedTypes = PyTypeParameterMapping.flattenUnpackedTupleTypes(expectedTypes);
        List<PyType> normalizedActualTypes = PyTypeParameterMapping.replaceExpectedTypesWithParameterList(normalizedExpectedTypes, PyTypeParameterMapping.flattenUnpackedTupleTypes(actualTypes));
        NullTolerantDeque<PyType> expectedTypesDeque = new NullTolerantDeque<PyType>(normalizedExpectedTypes);
        NullTolerantDeque<PyType> actualTypesDeque = new NullTolerantDeque<PyType>(normalizedActualTypes);
        ArrayList<Couple> leftMappedTypes = new ArrayList<Couple>();
        ArrayList<Object> centerMappedTypes = new ArrayList<Object>();
        ArrayList<Couple> rightMappedTypes = new ArrayList<Couple>();
        boolean splittingTypeVarTuple = false;
        while (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !((leftmostExpected = expectedTypesDeque.peekFirst()) instanceof PyPositionalVariadicType)) {
            PyType leftmostActual = actualTypesDeque.peekFirst();
            if (leftmostExpected != null && leftmostActual != null && leftmostExpected instanceof PyCallableParameterVariadicType ^ leftmostActual instanceof PyCallableParameterVariadicType || leftmostActual instanceof PyPositionalVariadicType) break;
            expectedTypesDeque.removeFirst();
            actualTypesDeque.removeFirst();
            leftMappedTypes.add(Couple.of((Object)leftmostExpected, (Object)leftmostActual));
        }
        while (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !((rightmostExpected = expectedTypesDeque.peekLast()) instanceof PyPositionalVariadicType)) {
            rightmostActual = actualTypesDeque.peekLast();
            if (rightmostExpected != null && rightmostActual != null && rightmostExpected instanceof PyCallableParameterVariadicType ^ rightmostActual instanceof PyCallableParameterVariadicType) break;
            expectedTypesDeque.removeLast();
            if (rightmostActual instanceof PyPositionalVariadicType) {
                PyPositionalVariadicType rightmostActualVariadic = (PyPositionalVariadicType)rightmostActual;
                if (rightmostActualVariadic instanceof PyUnpackedTupleType && (unpackedTupleType = (PyUnpackedTupleType)rightmostActualVariadic).isUnbound()) {
                    PyType repeatedActualType = (PyType)unpackedTupleType.getElementTypes().get(0);
                    rightMappedTypes.add(Couple.of((Object)rightmostExpected, (Object)repeatedActualType));
                    continue;
                }
                splittingTypeVarTuple = true;
                break;
            }
            actualTypesDeque.removeLast();
            rightMappedTypes.add(Couple.of((Object)rightmostExpected, (Object)rightmostActual));
        }
        if (expectedTypesDeque.size() != 0 && actualTypesDeque.size() != 0 && !(expectedTypesDeque.peekFirst() instanceof PyVariadicType) && (rightmostActual = actualTypesDeque.peekFirst()) instanceof PyPositionalVariadicType) {
            PyPositionalVariadicType actualPositionalVariadic = (PyPositionalVariadicType)rightmostActual;
            if (actualPositionalVariadic instanceof PyUnpackedTupleType && (actualUnpackedTupleType = (PyUnpackedTupleType)actualPositionalVariadic).isUnbound()) {
                while (expectedTypesDeque.size() != 0 && !(expectedTypesDeque.peekFirst() instanceof PyVariadicType)) {
                    PyType repeatedActualType = (PyType)actualUnpackedTupleType.getElementTypes().get(0);
                    leftMappedTypes.add(Couple.of((Object)expectedTypesDeque.peekFirst(), (Object)repeatedActualType));
                    expectedTypesDeque.removeFirst();
                }
            } else {
                splittingTypeVarTuple = true;
            }
        }
        if (splittingTypeVarTuple) {
            return null;
        }
        if (expectedTypesDeque.size() != 0 && (actualUnpackedTupleType = expectedTypesDeque.peekFirst()) instanceof PyPositionalVariadicType) {
            PyTypeVarTupleType typeVarTupleType;
            PyPositionalVariadicType expectedPositionalVariadic = (PyPositionalVariadicType)actualUnpackedTupleType;
            if (actualTypesDeque.size() == 1 && (unpackedTupleType = actualTypesDeque.peekFirst()) instanceof PyPositionalVariadicType) {
                PyPositionalVariadicType variadicType = (PyPositionalVariadicType)unpackedTupleType;
                expectedTypesDeque.removeFirst();
                actualTypesDeque.removeFirst();
                centerMappedTypes.add(Couple.of((Object)expectedPositionalVariadic, (Object)variadicType));
            } else if (actualTypesDeque.size() == 0 && optionSet.contains((Object)Option.USE_DEFAULTS) && expectedPositionalVariadic instanceof PyTypeVarTupleType && (typeVarTupleType = (PyTypeVarTupleType)expectedPositionalVariadic).getDefaultType() != null) {
                expectedTypesDeque.removeFirst();
                centerMappedTypes.add(Couple.of((Object)expectedPositionalVariadic, (Object)((PyType)Ref.deref((Ref)typeVarTupleType.getDefaultType()))));
            } else {
                ArrayList<PyType> nonParamVariadicActualTypes = new ArrayList<PyType>();
                while (actualTypesDeque.size() != 0 && !(actualTypesDeque.peekFirst() instanceof PyCallableParameterVariadicType)) {
                    nonParamVariadicActualTypes.add(actualTypesDeque.peekFirst());
                    actualTypesDeque.removeFirst();
                }
                expectedTypesDeque.removeFirst();
                centerMappedTypes.add(Couple.of((Object)expectedPositionalVariadic, (Object)PyUnpackedTupleTypeImpl.create(nonParamVariadicActualTypes)));
            }
        }
        boolean sizeMismatch = true;
        if (expectedTypesDeque.size() == 0) {
            boolean allActualTypesMatched = actualTypesDeque.size() == 0;
            boolean onlySingleActualVariadicLeft = actualTypesDeque.size() == 1 && actualTypesDeque.peekFirst() instanceof PyPositionalVariadicType;
            sizeMismatch = !allActualTypesMatched && !onlySingleActualVariadicLeft;
        } else if (actualTypesDeque.size() == 0) {
            boolean allMapped = true;
            for (PyType unmatchedType : expectedTypesDeque.toList()) {
                Couple<PyType> fallbackMapping = PyTypeParameterMapping.mapToFallback(unmatchedType, optionSet);
                boolean bl = allMapped = fallbackMapping != null;
                if (!allMapped) break;
                centerMappedTypes.add(fallbackMapping);
            }
            boolean bl = sizeMismatch = !allMapped;
        }
        if (sizeMismatch) {
            return null;
        }
        ArrayList<Couple<PyType>> resultMapping = new ArrayList<Couple<PyType>>(leftMappedTypes);
        resultMapping.addAll(centerMappedTypes);
        Collections.reverse(rightMappedTypes);
        resultMapping.addAll(rightMappedTypes);
        return new PyTypeParameterMapping(resultMapping);
    }

    @NotNull
    private static List<PyType> replaceExpectedTypesWithParameterList(@NotNull List<PyType> expectedTypes, @NotNull List<PyType> actualTypes) {
        if (expectedTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(4);
        }
        if (actualTypes == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(5);
        }
        if (ContainerUtil.getOnlyItem(expectedTypes) instanceof PyParamSpecType && !actualTypes.isEmpty() && !ContainerUtil.exists(actualTypes, o -> o instanceof PyVariadicType)) {
            PyCallableParameterListTypeImpl callableParameterListType = new PyCallableParameterListTypeImpl(ContainerUtil.map(actualTypes, PyCallableParameterImpl::nonPsi));
            List<PyCallableParameterListTypeImpl> list = Collections.singletonList(callableParameterListType);
            if (list == null) {
                PyTypeParameterMapping.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PyType> list = actualTypes;
        if (list == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static Couple<PyType> mapToFallback(@Nullable PyType unmatchedExpectedType, @NotNull EnumSet<Option> optionSet) {
        PyTypeParameterType typeParameterType;
        if (optionSet == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(8);
        }
        if (optionSet.contains((Object)Option.USE_DEFAULTS) && unmatchedExpectedType instanceof PyTypeParameterType && (typeParameterType = (PyTypeParameterType)unmatchedExpectedType).getDefaultType() != null) {
            return Couple.of((Object)unmatchedExpectedType, (Object)((PyType)Ref.deref((Ref)typeParameterType.getDefaultType())));
        }
        if (optionSet.contains((Object)Option.MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY)) {
            return Couple.of((Object)unmatchedExpectedType, null);
        }
        return null;
    }

    @NotNull
    private static List<PyType> flattenUnpackedTupleTypes(List<? extends PyType> types) {
        List list = ContainerUtil.flatMap(types, type -> {
            PyUnpackedTupleType unpackedTupleType;
            if (type instanceof PyUnpackedTupleType && !(unpackedTupleType = (PyUnpackedTupleType)type).isUnbound()) {
                return PyTypeParameterMapping.flattenUnpackedTupleTypes(unpackedTupleType.getElementTypes());
            }
            return Collections.singletonList(type);
        });
        if (list == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<Couple<PyType>> getMappedTypes() {
        List<Couple<PyType>> list = Collections.unmodifiableList(this.myMappedTypes);
        if (list == null) {
            PyTypeParameterMapping.$$$reportNull$$$0(10);
        }
        return list;
    }

    public String toString() {
        return StringUtil.join(this.myMappedTypes, pair -> String.valueOf(pair.first) + " -> " + String.valueOf(pair.second), (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParameterMapping";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParameterMapping";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpectedTypesWithParameterList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenUnpackedTupleTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mapByShape";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpectedTypesWithParameterList";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mapToFallback";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static enum Option {
        MAP_UNMATCHED_EXPECTED_TYPES_TO_ANY,
        USE_DEFAULTS;

    }

    private static final class NullTolerantDeque<T> {
        private final Deque<Ref<T>> myDeque;

        private NullTolerantDeque(@NotNull Collection<? extends @Nullable T> collection) {
            if (collection == null) {
                NullTolerantDeque.$$$reportNull$$$0(0);
            }
            this.myDeque = new ArrayDeque<Ref<T>>(ContainerUtil.map(collection, Ref::create));
        }

        @Nullable
        public T peekFirst() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)Ref.deref(this.myDeque.peekFirst());
        }

        @Nullable
        public T peekLast() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)Ref.deref(this.myDeque.peekLast());
        }

        public void removeFirst() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.myDeque.removeFirst();
        }

        public void removeLast() {
            if (this.myDeque.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.myDeque.removeLast();
        }

        public int size() {
            return this.myDeque.size();
        }

        public @NotNull List<@Nullable T> toList() {
            List list = ContainerUtil.map(this.myDeque, Ref::deref);
            if (list == null) {
                NullTolerantDeque.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeParameterMapping$NullTolerantDeque";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeParameterMapping$NullTolerantDeque";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

