/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.util.LazyInitializer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class JBSwingUtilities {
    private static final List<BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D>> ourGlobalTransform = new CopyOnWriteArrayList(Collections.emptyList());
    private static final LazyInitializer.LazyValue<Graphics2D> DUMMY_GRAPHICS = LazyInitializer.create(() -> {
        BufferedImage image = new BufferedImage(1, 1, 2);
        return image.createGraphics();
    });
    @ApiStatus.Internal
    public static final RenderingHints.Key ADJUSTED_BACKGROUND_ALPHA = new RenderingHints.Key(1){

        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Float;
        }
    };

    @Deprecated(forRemoval=true)
    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return SwingUtilities.isLeftMouseButton(anEvent);
    }

    @Deprecated(forRemoval=true)
    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return SwingUtilities.isRightMouseButton(anEvent);
    }

    public static Disposable addGlobalCGTransform(final @NotNull BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D> fun) {
        if (fun == null) {
            JBSwingUtilities.$$$reportNull$$$0(0);
        }
        ourGlobalTransform.add(fun);
        return new Disposable(){

            public void dispose() {
                ourGlobalTransform.remove(fun);
            }
        };
    }

    @NotNull
    public static Graphics2D runGlobalCGTransform(@NotNull JComponent c, @NotNull Graphics g) {
        if (c == null) {
            JBSwingUtilities.$$$reportNull$$$0(1);
        }
        if (g == null) {
            JBSwingUtilities.$$$reportNull$$$0(2);
        }
        Graphics2D gg = (Graphics2D)g;
        for (BiFunction<? super JComponent, ? super Graphics2D, ? extends Graphics2D> transform : ourGlobalTransform) {
            gg = Objects.requireNonNull(transform.apply(c, gg));
        }
        Graphics2D graphics2D = gg;
        if (graphics2D == null) {
            JBSwingUtilities.$$$reportNull$$$0(3);
        }
        return graphics2D;
    }

    public static boolean hasCGTransform(@NotNull JComponent c) {
        Graphics2D dummyGraphics;
        if (c == null) {
            JBSwingUtilities.$$$reportNull$$$0(4);
        }
        return JBSwingUtilities.runGlobalCGTransform(c, dummyGraphics = (Graphics2D)DUMMY_GRAPHICS.get()) != dummyGraphics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBSwingUtilities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBSwingUtilities";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runGlobalCGTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalCGTransform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runGlobalCGTransform";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasCGTransform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

