/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.VcsExecutablePathSelector;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.git.GitDisplayName;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableInlineComponent;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.InlineComponent;
import git4idea.config.InlineErrorNotifier;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u0001:\u0003%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\r\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lgit4idea/config/GitExecutableSelectorPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "applicationSettings", "Lgit4idea/config/GitVcsApplicationSettings;", "kotlin.jvm.PlatformType", "getApplicationSettings", "()Lgit4idea/config/GitVcsApplicationSettings;", "projectSettings", "Lgit4idea/config/GitVcsSettings;", "getProjectSettings", "()Lgit4idea/config/GitVcsSettings;", "pathSelector", "Lcom/intellij/util/ui/VcsExecutablePathSelector;", "versionCheckRequested", "", "createRow", "Lcom/intellij/ui/dsl/builder/Row;", "Lcom/intellij/ui/dsl/builder/Panel;", "resetPathSelector", "", "testGitExecutable", "pathToGit", "", "validateExecutableOnceAfterClose", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "InlineErrorNotifierFromSettings", "GitExecutableHandler", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitExecutableSelectorPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitExecutableSelectorPanel.kt\ngit4idea/config/GitExecutableSelectorPanel\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,176:1\n46#2,6:177\n*S KotlinDebug\n*F\n+ 1 GitExecutableSelectorPanel.kt\ngit4idea/config/GitExecutableSelectorPanel\n*L\n135#1:177,6\n*E\n"})
public final class GitExecutableSelectorPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final VcsExecutablePathSelector pathSelector;
    private volatile boolean versionCheckRequested;

    public GitExecutableSelectorPanel(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.disposable = disposable;
        this.pathSelector = new VcsExecutablePathSelector(GitDisplayName.NAME, this.disposable, (VcsExecutablePathSelector.ExecutableHandler)new GitExecutableHandler());
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect(this.disposable);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> GitExecutableSelectorPanel._init_$lambda$0(this));
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.disposable, () -> GitExecutableSelectorPanel._init_$lambda$1(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    private final GitVcsApplicationSettings getApplicationSettings() {
        return GitVcsApplicationSettings.getInstance();
    }

    private final GitVcsSettings getProjectSettings() {
        return GitVcsSettings.getInstance(this.project);
    }

    private final Row createRow(Panel $this$createRow) {
        return Panel.row$default((Panel)$this$createRow, null, arg_0 -> GitExecutableSelectorPanel.createRow$lambda$0(this, arg_0), (int)1, null);
    }

    private final void resetPathSelector() {
        this.pathSelector.setAutoDetectedPath(GitExecutableManager.getInstance().getDetectedExecutable(this.project, false));
        this.pathSelector.reset(this.getApplicationSettings().getSavedPathToGit(), this.getProjectSettings().getPathToGit() != null, this.getProjectSettings().getPathToGit());
    }

    private final void testGitExecutable(String pathToGit) {
        ModalityState modalityState = this.getModalityState();
        BorderLayoutPanel borderLayoutPanel = this.pathSelector.getErrorComponent();
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"getErrorComponent(...)");
        InlineErrorNotifierFromSettings errorNotifier = new InlineErrorNotifierFromSettings(new GitExecutableInlineComponent(borderLayoutPanel, modalityState, null), modalityState, this.disposable);
        if (!this.project.isDefault() && !TrustedProjects.isProjectTrusted((Project)this.project)) {
            String string = GitBundle.message("git.executable.validation.cant.run.in.safe.mode", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            errorNotifier.showError(string, null);
            return;
        }
        ModalTaskOwner modalTaskOwner = ModalTaskOwner.component((Component)this.pathSelector.getMainPanel());
        Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"component(...)");
        String string = GitBundle.message("git.executable.version.progress.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, pathToGit, errorNotifier, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int I$1;
            int I$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GitExecutableSelectorPanel this$0;
            final /* synthetic */ String $pathToGit;
            final /* synthetic */ InlineErrorNotifierFromSettings $errorNotifier;
            {
                this.this$0 = $receiver;
                this.$pathToGit = $pathToGit;
                this.$errorNotifier = $errorNotifier;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                void $this$runWithModalProgressBlocking;
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$getOrHandleException$iv;
                        Object $this$invokeSuspend_u24lambda_u240;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $this$runWithModalProgressBlocking;
                        GitExecutableSelectorPanel gitExecutableSelectorPanel = this.this$0;
                        Object object4 = this.$pathToGit;
                        try {
                            $this$invokeSuspend_u24lambda_u240 = object3;
                            boolean bl = false;
                            GitExecutableManager executableManager = GitExecutableManager.getInstance();
                            GitExecutable gitExecutable = executableManager.getExecutable(gitExecutableSelectorPanel.getProject(), (String)object4);
                            Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
                            GitExecutable executable = gitExecutable;
                            executableManager.dropVersionCache(executable);
                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)executableManager.identifyVersion(gitExecutableSelectorPanel.getProject(), executable));
                        }
                        catch (Throwable throwable) {
                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object3 = $this$invokeSuspend_u24lambda_u240;
                        gitExecutableSelectorPanel = this.this$0;
                        object4 = this.$errorNotifier;
                        int $i$f$getOrHandleException = 0;
                        object = $this$getOrHandleException$iv;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable == null) break;
                        Throwable e$iv = throwable;
                        int n = 0;
                        LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                        Throwable err = e$iv;
                        int n2 = 0;
                        GitExecutableProblemHandler problemHandler = GitExecutableProblemHandlersKt.findGitExecutableProblemHandler(gitExecutableSelectorPanel.getProject());
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runWithModalProgressBlocking);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$getOrHandleException$iv);
                        this.L$2 = object;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)e$iv);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)err);
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)problemHandler);
                        this.I$0 = $i$f$getOrHandleException;
                        this.I$1 = n;
                        this.I$2 = n2;
                        this.label = 1;
                        Object object5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(problemHandler, err, (InlineErrorNotifierFromSettings)object4, null){
                            int label;
                            final /* synthetic */ GitExecutableProblemHandler $problemHandler;
                            final /* synthetic */ Throwable $err;
                            final /* synthetic */ InlineErrorNotifierFromSettings $errorNotifier;
                            {
                                this.$problemHandler = $problemHandler;
                                this.$err = $err;
                                this.$errorNotifier = $errorNotifier;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.$problemHandler.showError(this.$err, this.$errorNotifier);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (object5 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        int n = this.I$2;
                        int n3 = this.I$1;
                        int $i$f$getOrHandleException = this.I$0;
                        GitExecutableProblemHandler problemHandler = (GitExecutableProblemHandler)this.L$5;
                        Throwable err = (Throwable)this.L$4;
                        Throwable e$iv = (Throwable)this.L$3;
                        object = this.L$2;
                        Object $this$getOrHandleException$iv = this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object5 = $result;
                        break;
                    }
                }
                GitVersion gitVersion2 = (GitVersion)(Result.isFailure-impl((Object)object) ? null : object);
                if (gitVersion2 == null) {
                    return Unit.INSTANCE;
                }
                GitVersion gitVersion3 = gitVersion2;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runWithModalProgressBlocking);
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)gitVersion3);
                this.L$2 = null;
                this.L$3 = null;
                this.L$4 = null;
                this.L$5 = null;
                this.label = 2;
                Object object6 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(gitVersion3, this.$errorNotifier, this.this$0, null){
                    int label;
                    final /* synthetic */ GitVersion $gitVersion;
                    final /* synthetic */ InlineErrorNotifierFromSettings $errorNotifier;
                    final /* synthetic */ GitExecutableSelectorPanel this$0;
                    {
                        this.$gitVersion = $gitVersion;
                        this.$errorNotifier = $errorNotifier;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$gitVersion.isSupported()) {
                                    Object[] objectArray = new Object[]{this.$gitVersion.getPresentation()};
                                    String string = GitBundle.message("git.executable.version.is", objectArray);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                    this.$errorNotifier.showMessage(string);
                                } else {
                                    GitExecutableProblemHandlersKt.showUnsupportedVersionError(this.this$0.getProject(), this.$gitVersion, this.$errorNotifier);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (object6 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        gitVersion = (GitVersion)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        object6 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)4, null);
    }

    private final void validateExecutableOnceAfterClose() {
        if (this.versionCheckRequested) {
            return;
        }
        this.versionCheckRequested = true;
        ActionsKt.runInEdt((ModalityState)ModalityState.nonModal(), () -> GitExecutableSelectorPanel.validateExecutableOnceAfterClose$lambda$0(this));
    }

    private final ModalityState getModalityState() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.pathSelector.getMainPanel());
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        return modalityState;
    }

    private static final Unit lambda$0$0(GitExecutableSelectorPanel this$0) {
        this$0.resetPathSelector();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(GitExecutableSelectorPanel this$0) {
        ActionsKt.runInEdt((ModalityState)this$0.getModalityState(), () -> GitExecutableSelectorPanel.lambda$0$0(this$0));
    }

    private static final void _init_$lambda$1(GitExecutableSelectorPanel this$0) {
        GitExecutableManager.getInstance().getDetectedExecutable(this$0.project, true);
    }

    private static final Unit createRow$lambda$0$0(GitExecutableSelectorPanel this$0) {
        this$0.resetPathSelector();
        return Unit.INSTANCE;
    }

    private static final boolean createRow$lambda$0$1(GitExecutableSelectorPanel this$0) {
        return this$0.pathSelector.isModified(this$0.getApplicationSettings().getSavedPathToGit(), this$0.getProjectSettings().getPathToGit() != null, this$0.getProjectSettings().getPathToGit());
    }

    private static final Unit createRow$lambda$0$2(GitExecutableSelectorPanel this$0) {
        String currentPath = this$0.pathSelector.getCurrentPath();
        if (this$0.pathSelector.isOverridden()) {
            this$0.getProjectSettings().setPathToGit(currentPath);
        } else {
            this$0.getApplicationSettings().setPathToGit(currentPath);
            this$0.getProjectSettings().setPathToGit(null);
        }
        this$0.validateExecutableOnceAfterClose();
        VcsDirtyScopeManager.getInstance((Project)this$0.project).markEverythingDirty();
        return Unit.INSTANCE;
    }

    private static final Unit createRow$lambda$0(GitExecutableSelectorPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel = this$0.pathSelector.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
        $this$row.cell((JComponent)jPanel).align((Align)AlignX.FILL.INSTANCE).onReset(() -> GitExecutableSelectorPanel.createRow$lambda$0$0(this$0)).onIsModified(() -> GitExecutableSelectorPanel.createRow$lambda$0$1(this$0)).onApply(() -> GitExecutableSelectorPanel.createRow$lambda$0$2(this$0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit validateExecutableOnceAfterClose$lambda$0(GitExecutableSelectorPanel this$0) {
        void title$iv;
        void project$iv;
        this$0.versionCheckRequested = false;
        String string = GitBundle.message("git.executable.version.progress.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Project project = this$0.project;
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, this$0){
            final /* synthetic */ GitExecutableSelectorPanel this$0;
            {
                this.this$0 = gitExecutableSelectorPanel;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                GitExecutableManager.getInstance().testGitExecutableVersionValid(this.this$0.getProject());
            }
        });
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$Companion;", "", "<init>", "()V", "createGitExecutableSelectorRow", "", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final void createGitExecutableSelectorRow(@NotNull Panel $this$createGitExecutableSelectorRow, @NotNull Project project, @NotNull Disposable disposable) {
            GitExecutableSelectorPanel panel2;
            Intrinsics.checkNotNullParameter((Object)$this$createGitExecutableSelectorRow, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            GitExecutableSelectorPanel $this$createGitExecutableSelectorRow_u24lambda_u240 = panel2 = new GitExecutableSelectorPanel(project, disposable);
            boolean bl = false;
            $this$createGitExecutableSelectorRow_u24lambda_u240.createRow($this$createGitExecutableSelectorRow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$GitExecutableHandler;", "Lcom/intellij/util/ui/VcsExecutablePathSelector$ExecutableHandler;", "<init>", "(Lgit4idea/config/GitExecutableSelectorPanel;)V", "patchExecutable", "", "executable", "testExecutable", "", "intellij.vcs.git"})
    private final class GitExecutableHandler
    implements VcsExecutablePathSelector.ExecutableHandler {
        @Nullable
        public String patchExecutable(@NotNull String executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            return GitExecutableDetector.patchExecutablePath(GitExecutableSelectorPanel.this.getProject(), executable);
        }

        public void testExecutable(@NotNull String executable) {
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            GitExecutableSelectorPanel.this.testGitExecutable(executable);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/config/GitExecutableSelectorPanel$InlineErrorNotifierFromSettings;", "Lgit4idea/config/InlineErrorNotifier;", "inlineComponent", "Lgit4idea/config/InlineComponent;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lgit4idea/config/GitExecutableSelectorPanel;Lgit4idea/config/InlineComponent;Lcom/intellij/openapi/application/ModalityState;Lcom/intellij/openapi/Disposable;)V", "showError", "", "text", "", "description", "fixOption", "Lgit4idea/config/ErrorNotifier$FixOption;", "resetGitExecutable", "intellij.vcs.git"})
    private final class InlineErrorNotifierFromSettings
    extends InlineErrorNotifier {
        @NotNull
        private final ModalityState modalityState;

        public InlineErrorNotifierFromSettings(@NotNull InlineComponent inlineComponent, @NotNull ModalityState modalityState, Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)inlineComponent, (String)"inlineComponent");
            Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            super(inlineComponent, modalityState, disposable);
            this.modalityState = modalityState;
        }

        @Override
        public void showError(@NotNull String text2, @Nullable String description, @Nullable ErrorNotifier.FixOption fixOption) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (fixOption instanceof ErrorNotifier.FixOption.Configure) {
                super.showError(text2, description, null);
            } else {
                super.showError(text2, description, fixOption);
            }
        }

        @Override
        public void resetGitExecutable() {
            super.resetGitExecutable();
            GitExecutableManager.getInstance().getDetectedExecutable(GitExecutableSelectorPanel.this.getProject(), true);
            ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.modalityState, () -> InlineErrorNotifierFromSettings.resetGitExecutable$lambda$0(GitExecutableSelectorPanel.this));
        }

        private static final Unit resetGitExecutable$lambda$0(GitExecutableSelectorPanel this$0) {
            this$0.resetPathSelector();
            return Unit.INSTANCE;
        }
    }
}

