/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JButtonAction;
import com.intellij.util.ui.UIUtil;
import git4idea.conflicts.GitConflictsPanel;
import git4idea.conflicts.GitMergeHandler;
import git4idea.i18n.GitBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lgit4idea/conflicts/GitConflictsView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeDialogCustomizer", "Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/merge/MergeDialogCustomizer;)V", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "panel", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "descriptionLabel", "Ljavax/swing/JLabel;", "conflictsPanel", "Lgit4idea/conflicts/GitConflictsPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "dispose", "", "ResolveAction", "AcceptSideAction", "intellij.vcs.git"})
public final class GitConflictsView
implements Disposable {
    @NotNull
    private final GitMergeHandler mergeHandler;
    @NotNull
    private final SimpleToolWindowPanel panel;
    @NotNull
    private final JLabel descriptionLabel;
    @NotNull
    private final GitConflictsPanel conflictsPanel;

    public GitConflictsView(@NotNull Project project, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mergeDialogCustomizer, (String)"mergeDialogCustomizer");
        this.mergeHandler = new GitMergeHandler(project, mergeDialogCustomizer);
        this.conflictsPanel = new GitConflictsPanel(project, this.mergeHandler);
        Disposer.register((Disposable)this, (Disposable)this.conflictsPanel);
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAction((AnAction)new ResolveAction());
        toolbarGroup.addAction((AnAction)new AcceptSideAction(false));
        toolbarGroup.addAction((AnAction)new AcceptSideAction(true));
        toolbarGroup.addAction((AnAction)Separator.getInstance());
        toolbarGroup.addAction(actionManager.getAction("ChangesView.GroupBy"));
        ActionToolbar actionToolbar = actionManager.createActionToolbar("GitConflictsView", (ActionGroup)toolbarGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(this.conflictsPanel.getPreferredFocusableComponent());
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.descriptionLabel = new JLabel(GitBundle.message("conflicts.loading.status", new Object[0]));
        this.conflictsPanel.addListener(new GitConflictsPanel.Listener(){

            @Override
            public void onDescriptionChange(String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                descriptionLabel.setText(description);
            }
        });
        mainPanel.add((Component)this.descriptionLabel, "South");
        mainPanel.add((Component)this.conflictsPanel.getComponent(), "Center");
        this.descriptionLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        this.descriptionLabel.setForeground(UIUtil.getContextHelpForeground());
        this.descriptionLabel.setBackground(UIUtil.getTreeBackground());
        mainPanel.setBackground(UIUtil.getTreeBackground());
        this.panel = new SimpleToolWindowPanel(true, true);
        this.panel.setToolbar(toolbar.getComponent());
        this.panel.setContent((JComponent)mainPanel);
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return this.conflictsPanel.getPreferredFocusableComponent();
    }

    public void dispose() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lgit4idea/conflicts/GitConflictsView$AcceptSideAction;", "Lcom/intellij/util/ui/JButtonAction;", "takeTheirs", "", "<init>", "(Lgit4idea/conflicts/GitConflictsView;Z)V", "getTakeTheirs", "()Z", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
    private final class AcceptSideAction
    extends JButtonAction {
        private final boolean takeTheirs;

        public AcceptSideAction(boolean takeTheirs) {
            super(takeTheirs ? GitBundle.message("conflicts.accept.theirs.action.text", new Object[0]) : GitBundle.message("conflicts.accept.yours.action.text", new Object[0]), null, null, 6, null);
            this.takeTheirs = takeTheirs;
        }

        public final boolean getTakeTheirs() {
            return this.takeTheirs;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(GitConflictsView.this.conflictsPanel.canAcceptConflictSideForSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GitConflictsView.this.conflictsPanel.acceptConflictSideForSelection(this.takeTheirs);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgit4idea/conflicts/GitConflictsView$ResolveAction;", "Lcom/intellij/util/ui/JButtonAction;", "<init>", "(Lgit4idea/conflicts/GitConflictsView;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.vcs.git"})
    private final class ResolveAction
    extends JButtonAction {
        public ResolveAction() {
            super(GitBundle.message("conflicts.resolve.action.text", new Object[0]), null, null, 6, null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(GitConflictsView.this.conflictsPanel.canShowMergeWindowForSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GitConflictsView.this.conflictsPanel.showMergeWindowForSelection();
        }
    }
}

