/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote.hosting.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.i18n.GitBundle;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lgit4idea/remote/hosting/ui/ShareProjectUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "createNorthPanel", "Ljavax/swing/JComponent;", "createCenterPanel", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getDimensionServiceKey", "intellij.vcs.git"})
public final class ShareProjectUntrackedFilesDialog
extends SelectFilesDialog
implements UiDataProvider {
    @NotNull
    private final Project myProject;
    @Nullable
    private CommitMessage myCommitMessagePanel;

    public ShareProjectUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter(untrackedFiles, (String)"untrackedFiles");
        super(myProject, untrackedFiles, null, null, true, false);
        this.myProject = myProject;
        this.setTitle(GitBundle.message("share.untracked.files.dialog.title", new Object[0]));
        this.setOKButtonText(CommonBundle.getAddButtonText());
        this.setCancelButtonText(CommonBundle.getCancelButtonText());
        this.init();
    }

    @NotNull
    public final String getCommitMessage() {
        CommitMessage commitMessage = this.myCommitMessagePanel;
        Intrinsics.checkNotNull((Object)commitMessage);
        String string = commitMessage.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        return string;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent tree = super.createCenterPanel();
        CommitMessage commitMessage = new CommitMessage(this.myProject);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)commitMessage));
        commitMessage.setCommitMessage("Initial commit");
        this.myCommitMessagePanel = commitMessage;
        Splitter splitter = new Splitter(true);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(tree);
        splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
        splitter.setProportion(0.7f);
        return (JComponent)splitter;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = VcsDataKeys.COMMIT_MESSAGE_CONTROL;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COMMIT_MESSAGE_CONTROL");
        sink.set(dataKey, (Object)this.myCommitMessagePanel);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Git.ShareProject.UntrackedFilesDialog";
    }
}

