/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0006\u0018\u0019\u001a\u001b\u001c\u001dB;\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0007J\u0006\u0010\u0017\u001a\u00020\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/repo/GitConfig;", "", "remotes", "", "Lgit4idea/repo/GitConfig$Remote;", "urls", "Lgit4idea/repo/GitConfig$Url;", "trackedInfos", "Lgit4idea/repo/GitConfig$BranchConfig;", "core", "Lgit4idea/repo/GitConfig$Core;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lgit4idea/repo/GitConfig$Core;)V", "parseRemotes", "", "Lgit4idea/repo/GitRemote;", "parseTrackInfos", "Lgit4idea/repo/GitBranchTrackInfo;", "localBranches", "", "Lgit4idea/GitLocalBranch;", "remoteBranches", "Lgit4idea/GitRemoteBranch;", "parseCore", "UrlsAndPushUrls", "Remote", "Url", "BranchConfig", "Core", "Companion", "intellij.vcs.git"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGitConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfig.kt\ngit4idea/repo/GitConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1642#2,10:373\n1915#2:383\n1916#2:385\n1652#2:386\n1#3:384\n*S KotlinDebug\n*F\n+ 1 GitConfig.kt\ngit4idea/repo/GitConfig\n*L\n55#1:373,10\n55#1:383\n55#1:385\n55#1:386\n55#1:384\n*E\n"})
public final class GitConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Remote> remotes;
    @NotNull
    private final List<Url> urls;
    @NotNull
    private final List<BranchConfig> trackedInfos;
    @NotNull
    private final Core core;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SVN_REMOTE_SECTION = "svn-remote";
    @NotNull
    private static final String GIT_REMOTE_SECTION = "remote";
    @NotNull
    private static final String URL_SECTION = "url";
    @NotNull
    private static final String BRANCH_INFO_SECTION = "branch";
    @NotNull
    private static final String CORE_SECTION = "core";

    private GitConfig(List<Remote> remotes, List<Url> urls, List<BranchConfig> trackedInfos, Core core) {
        this.remotes = remotes;
        this.urls = urls;
        this.trackedInfos = trackedInfos;
        this.core = core;
    }

    @VisibleForTesting
    @NotNull
    public final Set<GitRemote> parseRemotes() {
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.remotes), GitConfig::parseRemotes$lambda$0), arg_0 -> GitConfig.parseRemotes$lambda$1(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<GitBranchTrackInfo> parseTrackInfos(@NotNull Collection<GitLocalBranch> localBranches2, @NotNull Collection<? extends GitRemoteBranch> remoteBranches2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(localBranches2, (String)"localBranches");
        Intrinsics.checkNotNullParameter(remoteBranches2, (String)"remoteBranches");
        Iterable $this$mapNotNull$iv = this.trackedInfos;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitBranchTrackInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BranchConfig config = (BranchConfig)element$iv$iv;
            boolean bl2 = false;
            if (GitConfig.Companion.convertBranchConfig(config, localBranches2, remoteBranches2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Core parseCore() {
        return this.core;
    }

    private static final boolean parseRemotes$lambda$0(Remote remote) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)GIT_REMOTE_SECTION);
        return !((Collection)remote.getUrls()).isEmpty();
    }

    private static final GitRemote parseRemotes$lambda$1(GitConfig this$0, Remote remote) {
        Intrinsics.checkNotNullParameter((Object)remote, (String)GIT_REMOTE_SECTION);
        return GitConfig.Companion.convertRemoteToGitRemote(this$0.urls, remote);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final GitConfig read(@Nullable Project project, @NotNull Path root) {
        return Companion.read(project, root);
    }

    public /* synthetic */ GitConfig(List remotes, List urls, List trackedInfos, Core core, DefaultConstructorMarker $constructor_marker) {
        this(remotes, urls, trackedInfos, core);
    }

    static {
        Logger logger = Logger.getInstance(GitConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lgit4idea/repo/GitConfig$BranchConfig;", "", "name", "", "remote", "merge", "rebase", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRemote", "getMerge", "getRebase", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class BranchConfig {
        @NotNull
        private final String name;
        @Nullable
        private final String remote;
        @Nullable
        private final String merge;
        @Nullable
        private final String rebase;

        public BranchConfig(@NotNull String name, @Nullable String remote, @Nullable String merge2, @Nullable String rebase2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.remote = remote;
            this.merge = merge2;
            this.rebase = rebase2;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getRemote() {
            return this.remote;
        }

        @Nullable
        public final String getMerge() {
            return this.merge;
        }

        @Nullable
        public final String getRebase() {
            return this.rebase;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.remote;
        }

        @Nullable
        public final String component3() {
            return this.merge;
        }

        @Nullable
        public final String component4() {
            return this.rebase;
        }

        @NotNull
        public final BranchConfig copy(@NotNull String name, @Nullable String remote, @Nullable String merge2, @Nullable String rebase2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BranchConfig(name, remote, merge2, rebase2);
        }

        public static /* synthetic */ BranchConfig copy$default(BranchConfig branchConfig, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchConfig.name;
            }
            if ((n & 2) != 0) {
                string2 = branchConfig.remote;
            }
            if ((n & 4) != 0) {
                string3 = branchConfig.merge;
            }
            if ((n & 8) != 0) {
                string4 = branchConfig.rebase;
            }
            return branchConfig.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "BranchConfig(name=" + this.name + ", remote=" + this.remote + ", merge=" + this.merge + ", rebase=" + this.rebase + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.remote == null ? 0 : this.remote.hashCode());
            result2 = result2 * 31 + (this.merge == null ? 0 : this.merge.hashCode());
            result2 = result2 * 31 + (this.rebase == null ? 0 : this.rebase.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchConfig)) {
                return false;
            }
            BranchConfig branchConfig = (BranchConfig)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)branchConfig.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.remote, (Object)branchConfig.remote)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.merge, (Object)branchConfig.merge)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rebase, (Object)branchConfig.rebase);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J6\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001c0\u001b2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001eH\u0002J.\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$H\u0002J \u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010)\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J&\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$J\u001e\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\bH\u0002J2\u00104\u001a\u00020\"2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001e2\u0006\u00105\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0002J2\u00106\u001a\u00020\u00132\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001e2\u0006\u00105\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0002J2\u00107\u001a\u00020\u00112\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001e2\u0006\u00105\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002J\"\u00108\u001a\u0002092\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001eH\u0002J0\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001e2\u0006\u0010;\u001a\u00020\bH\u0002J,\u0010<\u001a\u0004\u0018\u00010\b2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u001e2\u0006\u0010=\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lgit4idea/repo/GitConfig$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SVN_REMOTE_SECTION", "", "GIT_REMOTE_SECTION", "URL_SECTION", "BRANCH_INFO_SECTION", "CORE_SECTION", "convertRemoteToGitRemote", "Lgit4idea/repo/GitRemote;", "urls", "", "Lgit4idea/repo/GitConfig$Url;", "remote", "Lgit4idea/repo/GitConfig$Remote;", "read", "Lgit4idea/repo/GitConfig;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Ljava/nio/file/Path;", "parseKeysIntoSections", "", "Lkotlin/Pair;", "configurations", "", "convertBranchConfig", "Lgit4idea/repo/GitBranchTrackInfo;", "branchConfig", "Lgit4idea/repo/GitConfig$BranchConfig;", "localBranches", "", "Lgit4idea/GitLocalBranch;", "remoteBranches", "Lgit4idea/GitRemoteBranch;", "findLocalBranch", "branchName", "findRemoteBranch", "remoteBranchName", "remoteName", "substituteUrls", "Lgit4idea/repo/GitConfig$UrlsAndPushUrls;", "urlSections", "substituteUrl", "remoteUrl", "url", "insteadOf", "createBranchConfig", "sectionName", "createRemote", "createUrl", "createCore", "Lgit4idea/repo/GitConfig$Core;", "getAllConfigs", "sectionKey", "getOneConfig", "key", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfig.kt\ngit4idea/repo/GitConfig$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1642#2,10:373\n1915#2:383\n1916#2:385\n1652#2:386\n1#3:384\n1#3:387\n*S KotlinDebug\n*F\n+ 1 GitConfig.kt\ngit4idea/repo/GitConfig$Companion\n*L\n162#1:373,10\n162#1:383\n162#1:385\n162#1:386\n162#1:384\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final GitRemote convertRemoteToGitRemote(List<Url> urls, Remote remote) {
            UrlsAndPushUrls substitutedUrls = this.substituteUrls(urls, remote);
            return new GitRemote(remote.getName(), substitutedUrls.getUrls(), (Collection<String>)substitutedUrls.getPushUrls(), remote.getFetchSpecs(), remote.getPushSpec());
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final GitConfig read(@Nullable Project project, @NotNull Path root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Map<String, List<String>> configurations = null;
            try {
                Map<String, List<String>> map2 = GitConfigUtil.getValues(project, root, null);
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getValues(...)");
                configurations = map2;
            }
            catch (VcsException vcsException) {
                return new GitConfig(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), new Core(null), null);
            }
            List remotes = new ArrayList();
            List urls = new ArrayList();
            List trackedInfos = new ArrayList();
            Core core = this.createCore(configurations);
            Set<Pair<String, String>> sections = this.parseKeysIntoSections(configurations);
            for (Pair<String, String> section : sections) {
                String sectionName = (String)section.getFirst();
                String sectionVariable = (String)section.getSecond();
                switch (sectionName) {
                    case "svn-remote": 
                    case "remote": {
                        if (sectionVariable == null) break;
                        remotes.add(this.createRemote(configurations, sectionName, sectionVariable));
                        break;
                    }
                    case "url": {
                        if (sectionVariable == null) break;
                        urls.add(this.createUrl(configurations, sectionName, sectionVariable));
                        break;
                    }
                    case "branch": {
                        if (sectionVariable == null) {
                            Logger logger = LOG;
                            String string = "Common branch option(s) defined .git/config. sectionName: %s%n section: %s";
                            Object[] objectArray = new Object[]{sectionName, section};
                            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                            logger.debug(string2);
                            break;
                        }
                        trackedInfos.add(this.createBranchConfig(configurations, sectionName, sectionVariable));
                    }
                }
            }
            return new GitConfig(remotes, urls, trackedInfos, core, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Pair<String, String>> parseKeysIntoSections(Map<String, ? extends List<String>> configurations) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = configurations.entrySet();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                String key = (String)entry.getKey();
                int variableSeparatorIndex = StringsKt.lastIndexOf$default((CharSequence)key, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (variableSeparatorIndex == -1) {
                    pair = null;
                } else {
                    String section = StringsKt.take((String)key, (int)variableSeparatorIndex);
                    int sectionNameSeparatorIndex = StringsKt.indexOf$default((CharSequence)section, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (sectionNameSeparatorIndex == -1) {
                        pair = TuplesKt.to((Object)section, null);
                    } else {
                        String sectionVariable;
                        String sectionName = StringsKt.take((String)section, (int)sectionNameSeparatorIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)section.substring(sectionNameSeparatorIndex + 1), (String)"substring(...)");
                        pair = TuplesKt.to((Object)sectionName, (Object)sectionVariable);
                    }
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private final GitBranchTrackInfo convertBranchConfig(BranchConfig branchConfig, Collection<GitLocalBranch> localBranches2, Collection<? extends GitRemoteBranch> remoteBranches2) {
            String branchName = branchConfig.getName();
            String remoteName = branchConfig.getRemote();
            String mergeName = branchConfig.getMerge();
            String rebaseName = branchConfig.getRebase();
            CharSequence charSequence = mergeName;
            if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)rebaseName) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                LOG.debug("No branch." + branchName + ".merge/rebase item in the .git/config");
                return null;
            }
            charSequence = remoteName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                LOG.debug("No branch." + branchName + ".remote item in the .git/config");
                return null;
            }
            boolean merge2 = mergeName != null;
            String string = merge2 ? mergeName : rebaseName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = StringUtil.unquoteString((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteString(...)");
            String remoteBranchName = string2;
            GitLocalBranch localBranch = this.findLocalBranch(branchName, localBranches2);
            GitRemoteBranch remoteBranch = this.findRemoteBranch(remoteBranchName, remoteName, remoteBranches2);
            if (localBranch == null || remoteBranch == null) {
                LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
                return null;
            }
            return new GitBranchTrackInfo(localBranch, remoteBranch, merge2);
        }

        private final GitLocalBranch findLocalBranch(String branchName, Collection<GitLocalBranch> localBranches2) {
            Object v1;
            block1: {
                String string = GitBranchUtil.stripRefsPrefix(branchName);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripRefsPrefix(...)");
                String name = string;
                Iterable iterable = localBranches2;
                for (Object t : iterable) {
                    GitLocalBranch input = (GitLocalBranch)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)input.getName(), (Object)name)) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        @Nullable
        public final GitRemoteBranch findRemoteBranch(@NotNull String remoteBranchName, @NotNull String remoteName, @NotNull Collection<? extends GitRemoteBranch> remoteBranches2) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)remoteBranchName, (String)"remoteBranchName");
                Intrinsics.checkNotNullParameter((Object)remoteName, (String)"remoteName");
                Intrinsics.checkNotNullParameter(remoteBranches2, (String)"remoteBranches");
                String string = GitBranchUtil.stripRefsPrefix(remoteBranchName);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripRefsPrefix(...)");
                String branchName = string;
                Iterable iterable = remoteBranches2;
                for (Object t : iterable) {
                    GitRemoteBranch branch = (GitRemoteBranch)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)branch.getNameForRemoteOperations(), (Object)branchName) && Intrinsics.areEqual((Object)branch.getRemote().getName(), (Object)remoteName))) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return v1;
        }

        private final UrlsAndPushUrls substituteUrls(List<Url> urlSections, Remote remote) {
            String insteadOf;
            boolean substituted;
            List urls = new ArrayList(remote.getUrls().size());
            List pushUrls = new ArrayList();
            for (String remoteUrl2 : remote.getUrls()) {
                substituted = false;
                for (Url url : urlSections) {
                    insteadOf = url.getInsteadOf();
                    String pushInsteadOf = url.getPushInsteadOf();
                    if (insteadOf != null && StringsKt.startsWith$default((String)remoteUrl2, (String)insteadOf, (boolean)false, (int)2, null)) {
                        urls.add(this.substituteUrl(remoteUrl2, url, insteadOf));
                        substituted = true;
                        break;
                    }
                    if (pushInsteadOf == null || !StringsKt.startsWith$default((String)remoteUrl2, (String)pushInsteadOf, (boolean)false, (int)2, null)) continue;
                    if (remote.getPushUrls().isEmpty()) {
                        pushUrls.add(this.substituteUrl(remoteUrl2, url, pushInsteadOf));
                    }
                    urls.add(remoteUrl2);
                    substituted = true;
                    break;
                }
                if (substituted) continue;
                urls.add(remoteUrl2);
            }
            for (String remotePushUrl : remote.getPushUrls()) {
                substituted = false;
                for (Url url : urlSections) {
                    insteadOf = url.getInsteadOf();
                    if (insteadOf == null || !StringsKt.startsWith$default((String)remotePushUrl, (String)insteadOf, (boolean)false, (int)2, null)) continue;
                    pushUrls.add(this.substituteUrl(remotePushUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (substituted) continue;
                pushUrls.add(remotePushUrl);
            }
            if (pushUrls.isEmpty()) {
                pushUrls = CollectionsKt.toMutableList((Collection)urls);
            }
            return new UrlsAndPushUrls(urls, pushUrls);
        }

        private final String substituteUrl(String remoteUrl2, Url url, String insteadOf) {
            String string = url.getName();
            String string2 = remoteUrl2.substring(insteadOf.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + string2;
        }

        private final BranchConfig createBranchConfig(Map<String, ? extends List<String>> configurations, String sectionName, String branchName) {
            String sectionKey = sectionName + "." + branchName;
            String remote = this.getOneConfig(configurations, sectionKey + ".remote");
            String merge2 = this.getOneConfig(configurations, sectionKey + ".merge");
            String rebase2 = this.getOneConfig(configurations, sectionKey + ".rebase");
            return new BranchConfig(branchName, remote, merge2, rebase2);
        }

        private final Remote createRemote(Map<String, ? extends List<String>> configurations, String sectionName, String remoteName) {
            String sectionKey = sectionName + "." + remoteName;
            List<String> fetchSpecs = this.getAllConfigs(configurations, sectionKey + ".fetch");
            List<String> pushSpecs = this.getAllConfigs(configurations, sectionKey + ".push");
            List<String> urls = this.getAllConfigs(configurations, sectionKey + ".url");
            List<String> pushUrls = this.getAllConfigs(configurations, sectionKey + ".pushurl");
            return new Remote(remoteName, fetchSpecs, pushSpecs, urls, pushUrls);
        }

        private final Url createUrl(Map<String, ? extends List<String>> configurations, String sectionName, String url) {
            String sectionKey = sectionName + "." + url;
            String insteadof = this.getOneConfig(configurations, sectionKey + ".insteadof");
            String pushInsteadof = this.getOneConfig(configurations, sectionKey + ".pushinsteadof");
            return new Url(url, insteadof, pushInsteadof);
        }

        private final Core createCore(Map<String, ? extends List<String>> configurations) {
            String hooksPath = this.getOneConfig(configurations, "core.hookspath");
            return new Core(hooksPath);
        }

        private final List<String> getAllConfigs(Map<String, ? extends List<String>> configurations, String sectionKey) {
            List list = configurations.get(sectionKey);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final String getOneConfig(Map<String, ? extends List<String>> configurations, String key) {
            List<String> list = configurations.get(key);
            return list != null ? (String)CollectionsKt.lastOrNull(list) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitConfig$Core;", "", "hooksPath", "", "<init>", "(Ljava/lang/String;)V", "getHooksPath", "()Ljava/lang/String;", "intellij.vcs.git"})
    public static final class Core {
        @Nullable
        private final String hooksPath;

        public Core(@Nullable String hooksPath) {
            this.hooksPath = hooksPath;
        }

        @Nullable
        public final String getHooksPath() {
            return this.hooksPath;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003JS\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lgit4idea/repo/GitConfig$Remote;", "", "name", "", "fetchSpecs", "", "pushSpec", "urls", "pushUrls", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getFetchSpecs", "()Ljava/util/List;", "getPushSpec", "getUrls", "getPushUrls", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class Remote {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> fetchSpecs;
        @NotNull
        private final List<String> pushSpec;
        @NotNull
        private final List<String> urls;
        @NotNull
        private final List<String> pushUrls;

        public Remote(@NotNull String name, @NotNull List<String> fetchSpecs, @NotNull List<String> pushSpec, @NotNull List<String> urls, @NotNull List<String> pushUrls) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(fetchSpecs, (String)"fetchSpecs");
            Intrinsics.checkNotNullParameter(pushSpec, (String)"pushSpec");
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            Intrinsics.checkNotNullParameter(pushUrls, (String)"pushUrls");
            this.name = name;
            this.fetchSpecs = fetchSpecs;
            this.pushSpec = pushSpec;
            this.urls = urls;
            this.pushUrls = pushUrls;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getFetchSpecs() {
            return this.fetchSpecs;
        }

        @NotNull
        public final List<String> getPushSpec() {
            return this.pushSpec;
        }

        @NotNull
        public final List<String> getUrls() {
            return this.urls;
        }

        @NotNull
        public final List<String> getPushUrls() {
            return this.pushUrls;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.fetchSpecs;
        }

        @NotNull
        public final List<String> component3() {
            return this.pushSpec;
        }

        @NotNull
        public final List<String> component4() {
            return this.urls;
        }

        @NotNull
        public final List<String> component5() {
            return this.pushUrls;
        }

        @NotNull
        public final Remote copy(@NotNull String name, @NotNull List<String> fetchSpecs, @NotNull List<String> pushSpec, @NotNull List<String> urls, @NotNull List<String> pushUrls) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(fetchSpecs, (String)"fetchSpecs");
            Intrinsics.checkNotNullParameter(pushSpec, (String)"pushSpec");
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            Intrinsics.checkNotNullParameter(pushUrls, (String)"pushUrls");
            return new Remote(name, fetchSpecs, pushSpec, urls, pushUrls);
        }

        public static /* synthetic */ Remote copy$default(Remote remote, String string, List list, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                string = remote.name;
            }
            if ((n & 2) != 0) {
                list = remote.fetchSpecs;
            }
            if ((n & 4) != 0) {
                list2 = remote.pushSpec;
            }
            if ((n & 8) != 0) {
                list3 = remote.urls;
            }
            if ((n & 0x10) != 0) {
                list4 = remote.pushUrls;
            }
            return remote.copy(string, list, list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "Remote(name=" + this.name + ", fetchSpecs=" + this.fetchSpecs + ", pushSpec=" + this.pushSpec + ", urls=" + this.urls + ", pushUrls=" + this.pushUrls + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.fetchSpecs).hashCode();
            result2 = result2 * 31 + ((Object)this.pushSpec).hashCode();
            result2 = result2 * 31 + ((Object)this.urls).hashCode();
            result2 = result2 * 31 + ((Object)this.pushUrls).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Remote)) {
                return false;
            }
            Remote remote = (Remote)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)remote.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fetchSpecs, remote.fetchSpecs)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pushSpec, remote.pushSpec)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.urls, remote.urls)) {
                return false;
            }
            return Intrinsics.areEqual(this.pushUrls, remote.pushUrls);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lgit4idea/repo/GitConfig$Url;", "", "name", "", "insteadOf", "pushInsteadOf", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getInsteadOf", "getPushInsteadOf", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class Url {
        @NotNull
        private final String name;
        @Nullable
        private final String insteadOf;
        @Nullable
        private final String pushInsteadOf;

        public Url(@NotNull String name, @Nullable String insteadOf, @Nullable String pushInsteadOf) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.insteadOf = insteadOf;
            this.pushInsteadOf = pushInsteadOf;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getInsteadOf() {
            return this.insteadOf;
        }

        @Nullable
        public final String getPushInsteadOf() {
            return this.pushInsteadOf;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.insteadOf;
        }

        @Nullable
        public final String component3() {
            return this.pushInsteadOf;
        }

        @NotNull
        public final Url copy(@NotNull String name, @Nullable String insteadOf, @Nullable String pushInsteadOf) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Url(name, insteadOf, pushInsteadOf);
        }

        public static /* synthetic */ Url copy$default(Url url, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = url.name;
            }
            if ((n & 2) != 0) {
                string2 = url.insteadOf;
            }
            if ((n & 4) != 0) {
                string3 = url.pushInsteadOf;
            }
            return url.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Url(name=" + this.name + ", insteadOf=" + this.insteadOf + ", pushInsteadOf=" + this.pushInsteadOf + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + (this.insteadOf == null ? 0 : this.insteadOf.hashCode());
            result2 = result2 * 31 + (this.pushInsteadOf == null ? 0 : this.pushInsteadOf.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Url)) {
                return false;
            }
            Url url = (Url)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)url.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.insteadOf, (Object)url.insteadOf)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pushInsteadOf, (Object)url.pushInsteadOf);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lgit4idea/repo/GitConfig$UrlsAndPushUrls;", "", "urls", "", "", "pushUrls", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getUrls", "()Ljava/util/List;", "getPushUrls", "intellij.vcs.git"})
    private static final class UrlsAndPushUrls {
        @NotNull
        private final List<String> urls;
        @NotNull
        private final List<String> pushUrls;

        public UrlsAndPushUrls(@NotNull List<String> urls, @NotNull List<String> pushUrls) {
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            Intrinsics.checkNotNullParameter(pushUrls, (String)"pushUrls");
            this.urls = urls;
            this.pushUrls = pushUrls;
        }

        @NotNull
        public final List<String> getUrls() {
            return this.urls;
        }

        @NotNull
        public final List<String> getPushUrls() {
            return this.pushUrls;
        }
    }
}

