/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.JsonParseException;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.net.PlatformHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@ApiStatus.Internal
public final class RegionUrlMapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.RegionUrlMapper");
    private static final int CACHE_DATA_EXPIRATION_MIN = SystemProperties.getIntProperty((String)"ide.region.url.mapping.expiration.timeout", (int)2);
    private static final String CONFIG_URL_DEFAULT = "https://www.jetbrains.com/config/JetBrainsResourceMapping.json";
    private static final Map<Region, String> CONFIG_URL_TABLE = Map.of(Region.CHINA, "https://www.jetbrains.com.cn/config/JetBrainsResourceMapping.json");
    private static final Map<Region, String> OVERRIDE_CONFIG_URL_TABLE = new HashMap<Region, String>();
    private static final boolean FORCE_REGION_MAPPINGS_LOAD = Boolean.getBoolean("force.region.mappings.load");
    private static final AsyncLoadingCache<@NotNull Region, @NotNull RegionMapping> ourCache;

    private RegionUrlMapper() {
    }

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @NotNull
    public static String tryMapUrlBlocking(@NotNull String url) {
        if (url == null) {
            RegionUrlMapper.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertNoReadAccess();
        return RegionUrlMapper.tryMapUrlBlocking(url, RegionSettings.getRegion());
    }

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @NotNull
    public static String tryMapUrlBlocking(@NotNull String url, @NotNull Region region) {
        String string;
        if (url == null) {
            RegionUrlMapper.$$$reportNull$$$0(1);
        }
        if (region == null) {
            RegionUrlMapper.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertNoReadAccess();
        try {
            string = RegionUrlMapper.tryMapUrl(url, region).join();
        }
        catch (Throwable e) {
            LOG.warn("Unexpected exception when mapping region-specific url", e);
            String string2 = url;
            if (string2 == null) {
                RegionUrlMapper.$$$reportNull$$$0(4);
            }
            return string2;
        }
        if (string == null) {
            RegionUrlMapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull String> tryMapUrl(@NotNull String url) {
        if (url == null) {
            RegionUrlMapper.$$$reportNull$$$0(5);
        }
        return RegionUrlMapper.tryMapUrl(url, RegionSettings.getRegion());
    }

    @NotNull
    public static @NotNull CompletableFuture<@NotNull String> tryMapUrl(@NotNull String url, @NotNull Region region) {
        if (url == null) {
            RegionUrlMapper.$$$reportNull$$$0(6);
        }
        if (region == null) {
            RegionUrlMapper.$$$reportNull$$$0(7);
        }
        CompletionStage completionStage = ((CompletableFuture)ourCache.get((Object)region).exceptionally(t -> {
            while (t instanceof CompletionException) {
                t = t.getCause();
            }
            if (t instanceof CancellationException || t instanceof ControlFlowException) {
                LOG.debug("Loading regional URL mappings interrupted (using non-regional URL as fallback): " + String.valueOf(t));
            } else {
                if (FORCE_REGION_MAPPINGS_LOAD) {
                    LOG.error("Failed to load URL mappings for " + String.valueOf(region) + ", URL=" + RegionUrlMapper.getConfigUrl(region), t);
                    return RegionMapping.FAILED;
                }
                if (t instanceof IOException) {
                    LOG.info("Failed to fetch regional URL mappings (using non-regional URL as fallback): " + String.valueOf(t));
                } else if (t instanceof JsonParseException) {
                    LOG.warn("Failed to parse regional URL mappings (using non-regional URL as fallback): " + String.valueOf(t));
                } else {
                    LOG.error("Failed to load regional URL mappings (using non-regional URL as fallback)", t);
                }
            }
            return RegionMapping.EMPTY;
        })).thenApply(mapping -> mapping.apply(url));
        if (completionStage == null) {
            RegionUrlMapper.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    private static RegionMapping doLoadMappingOrThrow(Region reg) throws Exception {
        String configUrl = RegionUrlMapper.getConfigUrl(reg);
        try (HttpClient client2 = PlatformHttpClient.client();){
            HttpRequest request = PlatformHttpClient.request((URI)new URI(configUrl));
            HttpResponse response = PlatformHttpClient.checkResponse(client2.send(request, HttpResponse.BodyHandlers.ofString()));
            RegionMapping regionMapping = RegionMapping.fromJson((String)response.body());
            return regionMapping;
        }
    }

    @NotNull
    private static String getConfigUrl(@NotNull Region reg) {
        String overridden;
        if (reg == null) {
            RegionUrlMapper.$$$reportNull$$$0(9);
        }
        String string = (overridden = OVERRIDE_CONFIG_URL_TABLE.get(reg)) != null ? overridden : CONFIG_URL_TABLE.getOrDefault(reg, CONFIG_URL_DEFAULT);
        if (string == null) {
            RegionUrlMapper.$$$reportNull$$$0(10);
        }
        return string;
    }

    static {
        for (Region reg : Region.values()) {
            String overridden;
            Object propName = "jb.mapper.configuration.url";
            if (reg != Region.NOT_SET) {
                propName = (String)propName + "." + reg.name().toLowerCase(Locale.ENGLISH);
            }
            if ((overridden = System.getProperty((String)propName, "")).isBlank()) continue;
            OVERRIDE_CONFIG_URL_TABLE.put(reg, overridden);
        }
        ourCache = Caffeine.newBuilder().expireAfterWrite((long)CACHE_DATA_EXPIRATION_MIN, TimeUnit.MINUTES).buildAsync(RegionUrlMapper::doLoadMappingOrThrow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/RegionUrlMapper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/RegionUrlMapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tryMapUrlBlocking";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryMapUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryMapUrlBlocking";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryMapUrl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 10 -> new IllegalStateException(string);
        };
    }

    private static final class RegionMapping {
        private static final RegionMapping EMPTY = new RegionMapping(List.of());
        private static final RegionMapping FAILED = new RegionMapping(List.of(new PatternReplacement("https:", "mapping-failed:"), new PatternReplacement("http:", "mapping-failed:"), new PatternReplacement("ftp:", "mapping-failed:")));
        private final List<PatternReplacement> myPatternReplacements;

        private RegionMapping(List<PatternReplacement> patternReplacements) {
            this.myPatternReplacements = patternReplacements;
        }

        @NotNull
        public String apply(@NotNull String url) {
            if (url == null) {
                RegionMapping.$$$reportNull$$$0(0);
            }
            for (PatternReplacement pair : this.myPatternReplacements) {
                int entry = Strings.indexOfIgnoreCase((String)url, (String)pair.pattern, (int)0);
                if (entry < 0) continue;
                String string = url.substring(0, entry) + pair.replacement + url.substring(entry + pair.pattern.length());
                if (string == null) {
                    RegionMapping.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = url;
            if (string == null) {
                RegionMapping.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public static RegionMapping fromJson(@NotNull String json) throws JsonParseException {
            if (json == null) {
                RegionMapping.$$$reportNull$$$0(3);
            }
            SmartList result2 = new SmartList();
            for (Map mapping : JsonUtil.nextList(new JsonReaderEx(json))) {
                Object v;
                Map.Entry entry;
                String pattern;
                if (mapping.size() != 1 || Strings.isEmpty((String)(pattern = (String)(entry = mapping.entrySet().iterator().next()).getKey())) || !((v = entry.getValue()) instanceof String)) continue;
                String replacement = (String)v;
                result2.add(new PatternReplacement(pattern, replacement));
            }
            return new RegionMapping((List<PatternReplacement>)result2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj2) {
            if (obj2 == this) return true;
            if (!(obj2 instanceof RegionMapping)) return false;
            RegionMapping that = (RegionMapping)obj2;
            if (!Objects.equals(this.myPatternReplacements, that.myPatternReplacements)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.myPatternReplacements);
        }

        public String toString() {
            return "RegionMapping[mappings=" + String.valueOf(this.myPatternReplacements) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/RegionUrlMapper$RegionMapping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "json";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/RegionUrlMapper$RegionMapping";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromJson";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }

        private record PatternReplacement(@NotNull String pattern, @NotNull String replacement) {
            @NotNull
            private final String pattern;
            @NotNull
            private final String replacement;

            private PatternReplacement(@NotNull String pattern, @NotNull String replacement) {
                if (pattern == null) {
                    PatternReplacement.$$$reportNull$$$0(0);
                }
                if (replacement == null) {
                    PatternReplacement.$$$reportNull$$$0(1);
                }
            }

            @Override
            public String toString() {
                return this.pattern + " -> " + this.replacement;
            }

            @NotNull
            public String pattern() {
                String string = this.pattern;
                if (string == null) {
                    PatternReplacement.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String replacement() {
                String string = this.replacement;
                if (string == null) {
                    PatternReplacement.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "replacement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/RegionUrlMapper$RegionMapping$PatternReplacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/RegionUrlMapper$RegionMapping$PatternReplacement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pattern";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "replacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }
    }
}

