/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ColorModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    private static final int CYCLE_TIME_DEFAULT = 800;
    private static final int REPAINT_INTERVAL_DEFAULT = 50;
    private static final int CYCLE_TIME_SIMPLIFIED = 1000;
    private static final int REPAINT_INTERVAL_SIMPLIFIED = 500;
    private static final int ourCycleTime = DarculaProgressBarUI.isSimplified() ? 1000 : 800;
    private static final int ourRepaintInterval = DarculaProgressBarUI.isSimplified() ? 500 : 50;
    private static final int DEFAULT_WIDTH = 4;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        UIManager.put("ProgressBar.repaintInterval", ourRepaintInterval);
        UIManager.put("ProgressBar.cycleTime", ourCycleTime);
    }

    public void updateIndeterminateAnimationIndex(long startMillis) {
        int numFrames = ourCycleTime / ourRepaintInterval;
        long timePassed = System.currentTimeMillis() - startMillis;
        this.setAnimationIndex((int)(timePassed / (long)ourRepaintInterval % (long)numFrames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Color endColor;
            Color startColor;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque()) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i2 = this.progressBar.getInsets();
            JBInsets.removeFrom((Rectangle)r, (Insets)i2);
            int orientation = this.progressBar.getOrientation();
            Color foreground = this.progressBar.getForeground();
            Object statusProperty = this.progressBar.getClientProperty("ProgressBar.status");
            if ("failed".equals(statusProperty) || foreground == ColorProgressBar.RED) {
                startColor = JBUI.CurrentTheme.ProgressBar.FAILED;
                endColor = JBUI.CurrentTheme.ProgressBar.FAILED_END;
            } else if ("passed".equals(statusProperty) || foreground == ColorProgressBar.GREEN) {
                startColor = JBUI.CurrentTheme.ProgressBar.PASSED;
                endColor = JBUI.CurrentTheme.ProgressBar.PASSED_END;
            } else if ("warning".equals(statusProperty) || foreground == ColorProgressBar.YELLOW) {
                startColor = JBUI.CurrentTheme.ProgressBar.WARNING;
                endColor = JBUI.CurrentTheme.ProgressBar.WARNING_END;
            } else {
                Object clientPropertyStartColor = this.progressBar.getClientProperty("ProgressBar.indeterminateStartColor");
                Object clientPropertyEndColor = this.progressBar.getClientProperty("ProgressBar.indeterminateEndColor");
                startColor = clientPropertyStartColor instanceof Color ? (Color)clientPropertyStartColor : this.getStartColor(c);
                endColor = clientPropertyEndColor instanceof Color ? (Color)clientPropertyEndColor : this.getEndColor(c);
            }
            int pHeight = this.progressBar.getPreferredSize().height;
            int pWidth = this.progressBar.getPreferredSize().width;
            int yOffset = r.y + (r.height - pHeight) / 2;
            int xOffset = r.x + (r.width - pWidth) / 2;
            if (DarculaProgressBarUI.isSimplified()) {
                Color[] ca = new Color[]{startColor, endColor};
                int idx = 0;
                int delta = JBUIScale.scale((int)10);
                if (orientation == 0) {
                    float offset = r.x;
                    while (offset - (float)r.x < (float)r.width) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(offset, yOffset, delta, pHeight));
                        offset += (float)delta;
                    }
                } else {
                    float offset = r.y;
                    while (offset - (float)r.y < (float)r.height) {
                        g2.setPaint(ca[(this.getAnimationIndex() + idx++) % 2]);
                        g2.fill(new Rectangle2D.Float(xOffset, offset, delta, pWidth));
                        offset += (float)delta;
                    }
                }
            } else {
                Shape shape;
                int step2 = JBUIScale.scale((int)6);
                if (orientation == 0) {
                    shape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                    yOffset = r.y + pHeight / 2;
                    g2.setPaint(new GradientPaint(r.x + this.getAnimationIndex() * step2 * 2, yOffset, startColor, r.x + this.getFrameCount() * step2 + this.getAnimationIndex() * step2 * 2, yOffset, endColor, true));
                } else {
                    shape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                    xOffset = r.x + pWidth / 2;
                    g2.setPaint(new GradientPaint(xOffset, r.y + this.getAnimationIndex() * step2 * 2, startColor, xOffset, r.y + this.getFrameCount() * step2 + this.getAnimationIndex() * step2 * 2, endColor, true));
                }
                g2.fill(shape);
            }
            if (this.progressBar.isStringPainted()) {
                if (this.progressBar.getOrientation() == 0) {
                    this.paintString((Graphics2D)g, i2.left, i2.top, r.width, r.height, this.boxRect.x, this.boxRect.width);
                } else {
                    this.paintString((Graphics2D)g, i2.left, i2.top, r.width, r.height, this.boxRect.y, this.boxRect.height);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getStartColor(JComponent c) {
        return JBUI.CurrentTheme.ProgressBar.INDETERMINATE_START;
    }

    protected Color getEndColor(JComponent c) {
        return JBUI.CurrentTheme.ProgressBar.INDETERMINATE_END;
    }

    private void paintString(Graphics2D g, int x, int y, int w, int h, int fillStart, int amountFull) {
        String progressString = this.progressBar.getString();
        g.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
        Rectangle oldClip = g.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g.setColor(this.getSelectionBackground());
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(fillStart, y, amountFull, h);
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
        } else {
            g.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g, progressString, x, y, w, h);
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
            g.setColor(this.getSelectionForeground());
            g.clipRect(x, fillStart, w, amountFull);
            UIUtilities.drawString((JComponent)this.progressBar, (Graphics)g, progressString, renderLocation.x, renderLocation.y);
        }
        g.setClip(oldClip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Shape coloredShape;
            Shape fullShape;
            boolean horizontalOrientation;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(this.progressBar.getSize());
            if (c.isOpaque() && c.getParent() != null) {
                g2.setColor(c.getParent().getBackground());
                g2.fill(r);
            }
            Insets i2 = this.progressBar.getInsets();
            JBInsets.removeFrom((Rectangle)r, (Insets)i2);
            int amountFull = this.getAmountFull(i2, r.width, r.height);
            boolean bl = horizontalOrientation = this.progressBar.getOrientation() == 0;
            if (horizontalOrientation) {
                int pHeight = this.progressBar.getPreferredSize().height;
                int yOffset = r.y + (r.height - pHeight) / 2;
                fullShape = this.getShapedRect(r.x, yOffset, r.width, pHeight, pHeight);
                coloredShape = this.getShapedRect(r.x, yOffset, amountFull, pHeight, pHeight);
            } else {
                int pWidth = this.progressBar.getPreferredSize().width;
                int xOffset = r.x + (r.width - pWidth) / 2;
                fullShape = this.getShapedRect(xOffset, r.y, pWidth, r.height, pWidth);
                coloredShape = this.getShapedRect(xOffset, r.y, pWidth, amountFull, pWidth);
            }
            g2.setColor(this.getRemainderColor());
            g2.fill(fullShape);
            Color foreground = this.progressBar.getForeground();
            Object statusProperty = this.progressBar.getClientProperty("ProgressBar.status");
            Object object = this.progressBar.getClientProperty("ProgressBar.progressPaint");
            if (object instanceof Paint) {
                Paint progressPaint = (Paint)object;
                PaintTransformer paint = new PaintTransformer(progressPaint, horizontalOrientation, horizontalOrientation ? r.x : r.y, amountFull);
                g2.setPaint(paint);
            } else if ("failed".equals(statusProperty) || foreground == ColorProgressBar.RED) {
                g2.setColor(JBUI.CurrentTheme.ProgressBar.FAILED);
            } else if ("passed".equals(statusProperty) || foreground == ColorProgressBar.GREEN) {
                g2.setColor(JBUI.CurrentTheme.ProgressBar.PASSED);
            } else if ("warning".equals(statusProperty) || foreground == ColorProgressBar.YELLOW) {
                g2.setColor(JBUI.CurrentTheme.ProgressBar.WARNING);
            } else {
                g2.setColor(this.getFinishedColor(c));
            }
            g2.fill(coloredShape);
            if (this.progressBar.isStringPainted()) {
                this.paintString(g, i2.left, i2.top, r.width, r.height, amountFull, i2);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getRemainderColor() {
        return JBUI.CurrentTheme.ProgressBar.TRACK;
    }

    protected Color getFinishedColor(JComponent c) {
        return JBUI.CurrentTheme.ProgressBar.PROGRESS;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size2 = super.getPreferredSize(c);
        if (!(c instanceof JProgressBar)) {
            return size2;
        }
        if (!((JProgressBar)c).isStringPainted()) {
            if (((JProgressBar)c).getOrientation() == 0) {
                size2.height = this.getStripeWidth();
            } else {
                size2.width = this.getStripeWidth();
            }
        }
        return size2;
    }

    private int getStripeWidth() {
        Object ho = this.progressBar.getClientProperty("ProgressBar.stripeWidth");
        if (ho != null) {
            try {
                return JBUIScale.scale((int)Integer.parseInt(ho.toString()));
            }
            catch (NumberFormatException nfe) {
                return JBUIScale.scale((int)4);
            }
        }
        return JBUIScale.scale((int)4);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    private Shape getShapedRect(float x, float y, float w, float h, float ar) {
        boolean flatEnds = UIUtil.isUnderWin10LookAndFeel() || this.progressBar.getClientProperty("ProgressBar.flatEnds") == Boolean.TRUE;
        return flatEnds ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, ar, ar);
    }

    private static boolean isSimplified() {
        return false;
    }

    private static class PaintTransformer
    implements Paint {
        private final Paint originalPaint;
        private final boolean isHorizontal;
        private final int start;
        private final int size;

        private PaintTransformer(Paint paint, boolean isHorizontal, int start2, int size2) {
            this.originalPaint = paint;
            this.isHorizontal = isHorizontal;
            this.start = start2;
            this.size = size2;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            AffineTransform transform;
            AffineTransform affineTransform = transform = xform == null ? new AffineTransform() : (AffineTransform)xform.clone();
            if (this.start != 0) {
                if (this.isHorizontal) {
                    transform.translate(this.start, 0.0);
                } else {
                    transform.translate(0.0, this.start);
                }
            }
            if (this.size > 0) {
                transform.scale(this.size, this.size);
            }
            if (!this.isHorizontal) {
                transform.rotate(Math.toRadians(90.0), 0.0, 0.0);
            }
            return this.originalPaint.createContext(cm, deviceBounds, userBounds, transform, hints);
        }

        @Override
        public int getTransparency() {
            return this.originalPaint.getTransparency();
        }
    }
}

