/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.newItemPopup;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.ide.ui.newItemPopup.TemplatesListVisibilityListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class NewItemWithTemplatesPopupPanel<T>
extends NewItemSimplePopupPanel {
    protected final JList<T> myTemplatesList;
    private final MyListModel myTemplatesListModel;
    private final Box templatesListHolder;
    private final Collection<TemplatesListVisibilityListener> myVisibilityListeners = new ArrayList<TemplatesListVisibilityListener>();

    public NewItemWithTemplatesPopupPanel(List<? extends T> templatesList, ListCellRenderer<T> renderer2) {
        this(templatesList, renderer2, false);
    }

    public NewItemWithTemplatesPopupPanel(List<? extends T> templatesList, ListCellRenderer<T> renderer2, boolean liveErrorValidation) {
        super(liveErrorValidation);
        this.setBackground(JBUI.CurrentTheme.NewClassDialog.panelBackground());
        this.myTemplatesListModel = new MyListModel(templatesList);
        this.myTemplatesList = this.createTemplatesList(this.myTemplatesListModel, renderer2);
        this.myTemplatesList.getAccessibleContext().setAccessibleName(IdeBundle.message((String)"action.create.new.class.templates.list.accessible.name", (Object[])new Object[0]));
        final JTextField textField2 = this.getTextField();
        if (!ScreenReader.isActive()) {
            ScrollingUtil.installMoveUpAction(this.myTemplatesList, (JComponent)this.myTextField);
            ScrollingUtil.installMoveDownAction(this.myTemplatesList, (JComponent)this.myTextField);
        } else {
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            textField2.addKeyListener(new KeyAdapter(this){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e != null && (e.getKeyCode() == 40 || e.getKeyCode() == 38)) {
                        textField2.transferFocus();
                    }
                }
            });
            this.myTemplatesList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    NewItemWithTemplatesPopupPanel.this.performApplyActionOnEnter(e);
                }
            });
        }
        JBScrollPane scrollPane = new JBScrollPane(this.myTemplatesList);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.templatesListHolder = new JBBox(1);
        this.setBottomSpace(false);
        if (ExperimentalUI.isNewUI()) {
            scrollPane.setOverlappingScrollBar(true);
            SeparatorComponent separator = new SeparatorComponent(JBUI.CurrentTheme.Popup.separatorColor(), SeparatorOrientation.HORIZONTAL);
            separator.setHGap(JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get());
            this.templatesListHolder.add((Component)separator);
            this.myTemplatesList.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)JBUI.CurrentTheme.Popup.bodyBottomInsetNoAd(), (int)0));
            this.templatesListHolder.setOpaque(true);
            this.templatesListHolder.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        } else {
            Border lineBorder = JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.NewClassDialog.bordersColor());
            Border outerBorder = JBUI.Borders.compound((Border)lineBorder, (Border)JBUI.Borders.emptyTop((int)JBUI.CurrentTheme.NewClassDialog.fieldsSeparatorWidth()));
            this.templatesListHolder.setBorder(JBUI.Borders.merge((Border)lineBorder, (Border)outerBorder, (boolean)true));
        }
        this.templatesListHolder.add((Component)scrollPane);
        this.add(this.templatesListHolder, "Center");
    }

    public void addTemplatesVisibilityListener(TemplatesListVisibilityListener listener2) {
        this.myVisibilityListeners.add(listener2);
    }

    public void removeTemplatesVisibilityListener(TemplatesListVisibilityListener listener2) {
        this.myVisibilityListeners.remove(listener2);
    }

    protected void setTemplatesListVisible(boolean visible) {
        if (this.templatesListHolder.isVisible() != visible) {
            this.setBottomSpace(!visible);
            this.templatesListHolder.setVisible(visible);
            this.myVisibilityListeners.forEach(l -> l.visibilityChanged(visible));
        }
    }

    protected void updateTemplatesList(List<? extends T> templatesList) {
        this.myTemplatesListModel.update(templatesList);
    }

    @NotNull
    private JBList<T> createTemplatesList(@NotNull ListModel<T> model2, ListCellRenderer<T> renderer2) {
        if (model2 == null) {
            NewItemWithTemplatesPopupPanel.$$$reportNull$$$0(0);
        }
        JBList list2 = new JBList(model2);
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (NewItemWithTemplatesPopupPanel.this.myApplyAction == null || e.getClickCount() <= 1) {
                    return;
                }
                try (AccessToken ignored = SlowOperations.startSection((String)"action.perform");){
                    NewItemWithTemplatesPopupPanel.this.myApplyAction.consume((Object)e);
                }
            }
        };
        list2.addMouseListener((MouseListener)mouseListener2);
        list2.setCellRenderer(renderer2);
        list2.setFocusable(ScreenReader.isActive());
        list2.setSelectionMode(0);
        list2.putClientProperty((Object)RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)(!ScreenReader.isActive() ? 1 : 0));
        JBList jBList = list2;
        if (jBList == null) {
            NewItemWithTemplatesPopupPanel.$$$reportNull$$$0(1);
        }
        return jBList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/newItemPopup/NewItemWithTemplatesPopupPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/newItemPopup/NewItemWithTemplatesPopupPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplatesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplatesList";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    protected final class MyListModel
    extends AbstractListModel<T> {
        private final List<T> myItems = new ArrayList();

        private MyListModel(List<? extends T> items2) {
            this.myItems.addAll(items2);
        }

        public void update(List<? extends T> newItems) {
            if (!this.myItems.isEmpty()) {
                int end = this.myItems.size() - 1;
                this.myItems.clear();
                this.fireIntervalRemoved(this, 0, end);
            }
            if (!newItems.isEmpty()) {
                this.myItems.addAll(newItems);
                this.fireIntervalAdded(this, 0, this.myItems.size() - 1);
            }
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public T getElementAt(int index) {
            return this.myItems.get(index);
        }
    }
}

