/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public final class ExportToFileUtil {
    private static final Logger LOG = Logger.getInstance(ExportToFileUtil.class);

    @RequiresEdt
    public static void chooseFileAndExport(@NotNull Project project2, @NotNull ExporterToTextFile exporter) {
        if (project2 == null) {
            ExportToFileUtil.$$$reportNull$$$0(0);
        }
        if (exporter == null) {
            ExportToFileUtil.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ExportDialogBase dlg = new ExportDialogBase(project2, exporter);
        if (!dlg.showAndGet()) {
            return;
        }
        ExportToFileUtil.exportTextToFile(project2, dlg.getFileName(), dlg.getText());
        exporter.exportedTo(dlg.getFileName());
    }

    private static void exportTextToFile(Project project2, String fileName, String textToExport) {
        boolean append = false;
        File file2 = new File(fileName);
        if (file2.exists()) {
            int result2 = Messages.showYesNoCancelDialog((Project)project2, (String)IdeBundle.message((String)"error.text.file.already.exists", (Object[])new Object[]{fileName}), (String)IdeBundle.message((String)"dialog.title.export.to.file", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.overwrite", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.append", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (result2 != 1 && result2 != 0) {
                return;
            }
            if (result2 == 1) {
                append = true;
            }
        }
        try (FileWriter writer = new FileWriter(fileName, StandardCharsets.UTF_8, append);){
            writer.write(textToExport);
        }
        catch (IOException e) {
            Messages.showMessageDialog((Project)project2, (String)IdeBundle.message((String)"error.writing.to.file", (Object[])new Object[]{fileName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exporter";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/ExportToFileUtil";
        objectArray[2] = "chooseFileAndExport";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ExportDialogBase
    extends DialogWrapper {
        private final Project myProject;
        private final ExporterToTextFile myExporter;
        private Editor myTextArea;
        private TextFieldWithBrowseButton myTfFile;
        private ChangeListener myListener;

        ExportDialogBase(Project project2, ExporterToTextFile exporter) {
            super(project2, true);
            this.myProject = project2;
            this.myExporter = exporter;
            this.myTfFile = new TextFieldWithBrowseButton();
            this.myTfFile.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), this.myProject){

                @NotNull
                protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object res = super.chosenFileToResultingText(chosenFile);
                    if (chosenFile.isDirectory()) {
                        res = (String)res + File.separator + PathUtil.getFileName((String)myExporter.getDefaultFilePath());
                    }
                    String string = res;
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "chosenFile";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "chosenFileToResultingText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "chosenFileToResultingText";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            this.setTitle(IdeBundle.message((String)"title.export.preview", (Object[])new Object[0]));
            this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
            this.init();
            try {
                this.myListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        this.initText();
                    }
                };
                this.myExporter.addSettingsChangedListener(this.myListener);
            }
            catch (TooManyListenersException e) {
                LOG.error((Throwable)e);
            }
            this.initText();
        }

        public void dispose() {
            this.myExporter.removeSettingsChangedListener(this.myListener);
            EditorFactory.getInstance().releaseEditor(this.myTextArea);
            super.dispose();
        }

        private void initText() {
            this.myTextArea.getDocument().setText((CharSequence)this.myExporter.getReportText());
        }

        protected JComponent createCenterPanel() {
            Document document2 = EditorFactory.getInstance().createDocument(true);
            ((DocumentImpl)document2).setAcceptSlashR(true);
            this.myTextArea = EditorFactory.getInstance().createEditor(document2, this.myProject, (FileType)FileTypes.PLAIN_TEXT, true);
            EditorSettings settings = this.myTextArea.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setFoldingOutlineShown(false);
            settings.setRightMarginShown(false);
            settings.setAdditionalLinesCount(0);
            settings.setAdditionalColumnsCount(0);
            settings.setAdditionalPageAtBottom(false);
            EditorEx editorEx = (EditorEx)this.myTextArea;
            editorEx.setBackgroundColor(UIUtil.getInactiveTextFieldBackgroundColor());
            editorEx.setColorsScheme(EditorColorsManager.getInstance().getSchemeForCurrentUITheme());
            editorEx.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter());
            this.myTextArea.getComponent().setPreferredSize(new Dimension(700, 400));
            return this.myTextArea.getComponent();
        }

        protected JComponent createNorthPanel() {
            JPanel filePanel = this.createFilePanel();
            JComponent settingsPanel = this.myExporter.getSettingsEditor();
            if (settingsPanel == null) {
                return filePanel;
            }
            JPanel northPanel2 = new JPanel(new BorderLayout());
            northPanel2.add((Component)filePanel, "North");
            northPanel2.add((Component)settingsPanel, "Center");
            return northPanel2;
        }

        private JPanel createFilePanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.fill = 2;
            JLabel promptLabel = new JLabel(IdeBundle.message((String)"editbox.export.to.file", (Object[])new Object[0]));
            gbConstraints.weightx = 0.0;
            panel2.add((Component)promptLabel, gbConstraints);
            gbConstraints.weightx = 1.0;
            panel2.add((Component)this.myTfFile, gbConstraints);
            String defaultFilePath = this.myExporter.getDefaultFilePath();
            if (!new File(defaultFilePath).isAbsolute()) {
                defaultFilePath = PathMacroManager.getInstance((ComponentManager)this.myProject).collapsePath(defaultFilePath);
            }
            this.myTfFile.setText(FileUtil.toSystemDependentName((String)defaultFilePath));
            panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
            return panel2;
        }

        public String getText() {
            return this.myTextArea.getDocument().getText();
        }

        public void setFileName(@NlsSafe String s) {
            this.myTfFile.setText(s);
        }

        public String getFileName() {
            return this.myTfFile.getText();
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), new CopyToClipboardAction(), this.getCancelAction()};
            if (actionArray == null) {
                ExportDialogBase.$$$reportNull$$$0(0);
            }
            return actionArray;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.ExportDialog";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase", "createActions"));
        }

        protected final class CopyToClipboardAction
        extends AbstractAction {
            public CopyToClipboardAction() {
                super(IdeBundle.message((String)"button.copy", (Object[])new Object[0]));
                this.putValue("ShortDescription", IdeBundle.message((String)"description.copy.text.to.clipboard", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = StringUtil.convertLineSeparators((String)ExportDialogBase.this.getText());
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
            }
        }
    }
}

