/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.impl.SeparatedCommandListener;
import com.intellij.openapi.command.impl.UndoSpy;
import com.intellij.openapi.command.impl.cmd.CmdEvent;
import com.intellij.openapi.command.impl.cmd.CmdEventTransform;
import com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class CommandSeparator
implements CommandListener {
    @NotNull
    private final SeparatedCommandListener publisher;
    private boolean commandStarted;
    private boolean transparentStarted;
    private boolean commandInsideTransparent;
    private boolean transparentInsideCommand;

    CommandSeparator() {
        this(CommandSeparator.getPublisher());
    }

    public CommandSeparator(@NotNull SeparatedCommandListener publisher) {
        if (publisher == null) {
            CommandSeparator.$$$reportNull$$$0(0);
        }
        this.publisher = publisher;
    }

    public void commandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(1);
        }
        this.assertOutsideCommand();
        this.commandStarted = true;
        if (this.transparentStarted) {
            this.commandInsideTransparent = true;
        } else {
            this.notifyCommandStarted(event);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(2);
        }
        this.assertInsideCommand();
        this.commandStarted = false;
        if (this.commandInsideTransparent) {
            this.commandInsideTransparent = false;
        } else {
            this.notifyCommandFinished(event);
        }
        if (this.transparentInsideCommand) {
            this.transparentInsideCommand = false;
            this.notifyTransparentStarted();
        }
    }

    public void undoTransparentActionStarted() {
        this.assertOutsideTransparent();
        this.transparentStarted = true;
        if (this.commandStarted) {
            this.transparentInsideCommand = true;
        } else {
            this.notifyTransparentStarted();
        }
    }

    public void undoTransparentActionFinished() {
        this.assertInsideTransparent();
        this.transparentStarted = false;
        if (this.transparentInsideCommand) {
            this.transparentInsideCommand = false;
        } else {
            this.notifyTransparentFinished();
        }
    }

    @TestOnly
    public boolean isInitialState() {
        return !this.commandStarted && !this.transparentStarted && !this.commandInsideTransparent && !this.transparentInsideCommand;
    }

    private void notifyCommandStarted(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(3);
        }
        this.notifyCommand(event, true);
    }

    private void notifyCommandFinished(@NotNull CommandEvent event) {
        if (event == null) {
            CommandSeparator.$$$reportNull$$$0(4);
        }
        this.notifyCommand(event, false);
    }

    private void notifyTransparentStarted() {
        this.notifyCommand(null, true);
    }

    private void notifyTransparentFinished() {
        this.notifyCommand(null, false);
    }

    private void notifyCommand(@Nullable CommandEvent event, boolean isStart) {
        CmdEvent cmdEvent = (CmdEvent)ProgressManager.getInstance().computeInNonCancelableSection(() -> CmdEventTransform.getInstance().create(event, isStart));
        if (isStart) {
            this.publisher.onCommandStarted(cmdEvent);
        } else {
            this.publisher.onCommandFinished(cmdEvent);
        }
        UndoSpy undoSpy = UndoSpy.getInstance();
        if (undoSpy != null) {
            if (isStart) {
                undoSpy.commandStarted(cmdEvent);
            } else {
                undoSpy.commandFinished(cmdEvent);
            }
        }
    }

    private void assertInsideCommand() {
        if (!this.commandStarted) {
            throw new IllegalStateException("Command not started");
        }
    }

    private void assertOutsideCommand() {
        if (this.commandStarted) {
            throw new IllegalStateException("Command already started");
        }
    }

    private void assertInsideTransparent() {
        if (!this.transparentStarted) {
            throw new IllegalStateException("Transparent action not started");
        }
    }

    private void assertOutsideTransparent() {
        if (this.transparentStarted) {
            throw new IllegalStateException("Transparent action already started");
        }
    }

    @NotNull
    private static SeparatedCommandListener getPublisher() {
        SeparatedCommandListener separatedCommandListener = (SeparatedCommandListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SeparatedCommandListener.TOPIC);
        if (separatedCommandListener == null) {
            CommandSeparator.$$$reportNull$$$0(5);
        }
        return separatedCommandListener;
    }

    public String toString() {
        return "CommandSeparator{commandStarted=" + this.commandStarted + ", transparentStarted=" + this.transparentStarted + ", commandInsideTransparent=" + this.commandInsideTransparent + ", transparentInsideCommand=" + this.transparentInsideCommand + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CommandSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CommandSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "commandStarted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "commandFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyCommandStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyCommandFinished";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

