/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorCompositePanel;
import com.intellij.openapi.fileEditor.impl.EditorTabLabel;
import com.intellij.openapi.fileEditor.impl.EditorTabPainterAdapter;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWindowKt;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.tabActions.CloseTab;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.toolWindow.ToolWindowHeader;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBEditorTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.TabListOptions;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.multiRow.CompressibleMultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.ScrollableMultiRowLayout;
import com.intellij.ui.tabs.impl.multiRow.WrapMultiRowLayout;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0015J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0010H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u0002002\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020\u0010H\u0016J\u0006\u00102\u001a\u00020\u0012J\b\u00103\u001a\u00020\u0012H\u0002J\u0012\u00104\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010'2\u0006\u00106\u001a\u00020'H\u0016J\u0010\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00069"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabs;", "Lcom/intellij/ui/tabs/impl/JBEditorTabs;", "Lcom/intellij/ui/ComponentWithMnemonics;", "Lcom/intellij/openapi/fileEditor/impl/EditorWindowHolder;", "Lcom/intellij/ide/actions/CloseAction$CloseTarget;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "_entryPointActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "isActive", "", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "close", "getEditorWindow", "minHeaderHeight", "", "createRowLayout", "Lcom/intellij/ui/tabs/impl/TabLayout;", "paintChildren", "g", "Ljava/awt/Graphics;", "shouldPaintBottomBorder", "entryPointActionGroup", "getEntryPointActionGroup", "()Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getTabLabelInsets", "Lcom/intellij/util/ui/JBInsets;", "createTabLabel", "Lcom/intellij/ui/tabs/impl/TabLabel;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "getTabActionIcon", "Ljavax/swing/Icon;", "isHovered", "createTabPainterAdapter", "Lcom/intellij/ui/tabs/impl/TabPainterAdapter;", "createTabBorder", "Lcom/intellij/ui/tabs/JBTabsBorder;", "select", "Lcom/intellij/openapi/util/ActionCallback;", "requestFocus", "updateActive", "checkActive", "isActiveTabs", "getToSelectOnRemoveOf", "tab", "revalidateAndRepaint", "layoutNow", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEditorTabbedContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabs\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,765:1\n13#2:766\n*S KotlinDebug\n*F\n+ 1 EditorTabbedContainer.kt\ncom/intellij/openapi/fileEditor/impl/EditorTabs\n*L\n534#1:766\n*E\n"})
final class EditorTabs
extends JBEditorTabs
implements ComponentWithMnemonics,
EditorWindowHolder,
CloseAction.CloseTarget {
    @NotNull
    private final EditorWindow window;
    @NotNull
    private final DefaultActionGroup _entryPointActionGroup;
    private boolean isActive;

    public EditorTabs(@NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable, @NotNull EditorWindow window) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Project project2 = window.getManager().getProject();
            CoroutineScope coroutineScope2 = window.coroutineScope;
            boolean bl = UISettings.Companion.getInstance().getScrollTabLayoutInEditor();
            int tabPlacement = UISettings.Companion.getInstance().getEditorTabPlacement();
            super(project2, parentDisposable, coroutineScope2, new TabListOptions(true, bl, true, false, true, switch (tabPlacement) {
                case 1 -> JBTabsPosition.top;
                case 3 -> JBTabsPosition.bottom;
                case 2 -> JBTabsPosition.left;
                case 4 -> JBTabsPosition.right;
                case 0 -> JBTabsPosition.top;
                default -> {
                    boolean $i$f$logger = false;
                    Logger v4 = Logger.getInstance(EditorTabs.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                    v4.error("Unknown tab placement code=" + tabPlacement);
                    yield JBTabsPosition.top;
                }
            }, UISettings.Companion.getInstance().getEditorTabPlacement() == 0, false, 136, null));
            this.window = window;
            AWTEventListener listener2 = arg_0 -> EditorTabs._init_$lambda$0(this, arg_0);
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 4L);
            JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> EditorTabs._init_$lambda$1(listener2, arg_0));
            this.setUiDecoratorWithoutApply(new UiDecorator(){

                public UiDecorator.UiDecoration getDecoration() {
                    return new UiDecorator.UiDecoration(null, (Insets)this.getTabLabelInsets(), 2::getDecoration$lambda$0, Integer.valueOf(JBUI.scale((int)4)), 1, null);
                }

                private static final Insets getDecoration$lambda$0(TabLabel.ActionsPosition position2) {
                    Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
                    return JBUI.CurrentTheme.EditorTabs.tabContentInsets((Boolean)(switch (WhenMappings.$EnumSwitchMapping$0[position2.ordinal()]) {
                        case 1 -> true;
                        case 2 -> false;
                        case 3 -> null;
                        default -> throw new NoWhenBranchMatchedException();
                    }));
                }

                @Metadata(mv={2, 3, 0}, k=3, xi=48)
                public static final class WhenMappings {
                    public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                    static {
                        int[] nArray = new int[TabLabel.ActionsPosition.values().length];
                        try {
                            nArray[TabLabel.ActionsPosition.RIGHT.ordinal()] = 1;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[TabLabel.ActionsPosition.LEFT.ordinal()] = 2;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        try {
                            nArray[TabLabel.ActionsPosition.NONE.ordinal()] = 3;
                        }
                        catch (NoSuchFieldError noSuchFieldError) {
                            // empty catch block
                        }
                        $EnumSwitchMapping$0 = nArray;
                    }
                }
            });
            AnAction source = ActionManager.getInstance().getAction("EditorTabsEntryPoint");
            source.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
            source.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
            this._entryPointActionGroup = new DefaultActionGroup(List.of(source));
            InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
            if (internalUICustomization == null) break block7;
            internalUICustomization.installEditorBackground((JComponent)((Object)this));
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        sink.set(dataKey, (Object)this.window.getOwner().getManager().getProject());
        sink.set(EditorWindow.DATA_KEY, (Object)this.window);
        DataKey<CloseAction.CloseTarget> dataKey2 = CloseAction.CloseTarget.KEY;
        Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"KEY");
        sink.set(dataKey2, (Object)(this.getSelectedInfo() == null ? null : this));
        DataKey dataKey3 = PlatformCoreDataKeys.FILE_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"FILE_EDITOR");
        EditorComposite editorComposite = this.window.getSelectedComposite();
        sink.set(dataKey3, editorComposite != null ? editorComposite.getSelectedEditor() : null);
        DataKey dataKey4 = PlatformDataKeys.LAST_ACTIVE_FILE_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"LAST_ACTIVE_FILE_EDITOR");
        EditorComposite editorComposite2 = (EditorComposite)this.window.getOwner().currentCompositeFlow.getValue();
        sink.set(dataKey4, editorComposite2 != null ? editorComposite2.getSelectedEditor() : null);
        DataKey dataKey5 = CommonDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"VIRTUAL_FILE");
        EditorComposite editorComposite3 = this.window.getSelectedComposite();
        sink.set(dataKey5, editorComposite3 != null ? editorComposite3.getFile() : null);
        DataKey dataKey6 = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"HELP_ID");
        sink.set(dataKey6, (Object)"ideaInterface.editor");
    }

    @Override
    public void close() {
        TabInfo tabInfo = this.getTargetInfo();
        if (tabInfo == null) {
            return;
        }
        TabInfo selected = tabInfo;
        FileEditorManagerImpl fileEditorManagerImpl = this.window.getManager();
        Object object = selected.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFile");
        fileEditorManagerImpl.closeFile((VirtualFile)object, this.window);
    }

    @Override
    @NotNull
    public EditorWindow getEditorWindow() {
        return this.window;
    }

    @ApiStatus.Internal
    protected int minHeaderHeight() {
        return ToolWindowHeader.Companion.getUnscaledHeight$intellij_platform_ide_impl();
    }

    @NotNull
    protected TabLayout createRowLayout() {
        block3: {
            block2: {
                if (!this.isSingleRow()) break block2;
                if (!this.isHorizontalTabs()) break block3;
                if (TabLayout.showPinnedTabsSeparately()) break block2;
                if (UISettings.Companion.getInstance().getHideTabsIfNeeded()) break block3;
            }
            return !this.isSingleRow() ? (TabLayout)new WrapMultiRowLayout((JBTabsImpl)this, TabLayout.showPinnedTabsSeparately()) : (UISettings.Companion.getInstance().getHideTabsIfNeeded() ? (TabLayout)new ScrollableMultiRowLayout((JBTabsImpl)this, true, ExperimentalUI.Companion.isEditorTabsWithScrollBar()) : (TabLayout)new CompressibleMultiRowLayout((JBTabsImpl)this, TabLayout.showPinnedTabsSeparately()));
        }
        return (TabLayout)new ScrollableSingleRowLayout((JBTabsImpl)this, ExperimentalUI.Companion.isEditorTabsWithScrollBar());
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintChildren(g);
        this.drawBorder(g);
    }

    public boolean shouldPaintBottomBorder() {
        TabInfo tabInfo = this.getSelectedInfo();
        if (tabInfo == null) {
            return true;
        }
        TabInfo tab = tabInfo;
        JComponent jComponent = tab.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.EditorCompositePanel");
        if (((EditorCompositePanel)jComponent).composite.getSelfBorder$intellij_platform_ide_impl()) {
            return false;
        }
        InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
        return internalUICustomization != null ? internalUICustomization.shouldPaintEditorTabsBottomBorder(tab.getComponent()) : true;
    }

    @NotNull
    protected DefaultActionGroup getEntryPointActionGroup() {
        return this._entryPointActionGroup;
    }

    @NotNull
    public final JBInsets getTabLabelInsets() {
        Insets insets = this.isHorizontalTabs() ? JBUI.CurrentTheme.EditorTabs.tabInsets() : JBUI.CurrentTheme.EditorTabs.verticalTabInsets();
        JBInsets jBInsets = insets instanceof JBInsets ? (JBInsets)insets : null;
        if (jBInsets == null) {
            throw new IllegalStateException(("JBInsets expected, but was: " + insets).toString());
        }
        return jBInsets;
    }

    @NotNull
    protected TabLabel createTabLabel(@NotNull TabInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return new EditorTabLabel(info, (JBTabsImpl)this);
    }

    @Nullable
    protected Icon getTabActionIcon(@NotNull TabInfo info, boolean isHovered) {
        CloseTab closeTabAction;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!this.getTabs().contains(info)) {
            return null;
        }
        ActionGroup actionGroup = info.getTabLabelActions();
        if (actionGroup == null) {
            return null;
        }
        ActionGroup group2 = actionGroup;
        if (group2 instanceof DefaultActionGroup) {
            var5_4 = ((DefaultActionGroup)group2).getChildren(ActionManager.getInstance());
            Intrinsics.checkNotNull((Object)var5_4);
            objectArray = var5_4;
        } else if (group2 instanceof CustomisedActionGroup && ((CustomisedActionGroup)group2).getDelegate() instanceof DefaultActionGroup) {
            ActionGroup actionGroup2 = ((CustomisedActionGroup)group2).getDelegate();
            Intrinsics.checkNotNull((Object)actionGroup2, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            var5_4 = ((DefaultActionGroup)actionGroup2).getChildren(ActionManager.getInstance());
            Intrinsics.checkNotNull((Object)var5_4);
            objectArray = var5_4;
        } else {
            var5_4 = group2.getChildren(null);
            Intrinsics.checkNotNull((Object)var5_4);
            objectArray = var5_4;
        }
        Object[] actions = objectArray;
        Object object = ArraysKt.lastOrNull((Object[])actions);
        CloseTab closeTab = closeTabAction = object instanceof CloseTab ? (CloseTab)((Object)object) : null;
        return closeTab != null ? closeTab.getIcon(isHovered) : null;
    }

    @NotNull
    protected TabPainterAdapter createTabPainterAdapter() {
        InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
        if (internalUICustomization == null || (internalUICustomization = internalUICustomization.getEditorTabPainterAdapter()) == null) {
            internalUICustomization = new EditorTabPainterAdapter();
        }
        return internalUICustomization;
    }

    @NotNull
    protected JBTabsBorder createTabBorder() {
        return (JBTabsBorder)new JBEditorTabsBorder((JBTabsImpl)this);
    }

    @NotNull
    public ActionCallback select(@NotNull TabInfo info, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.isActive = true;
        return super.select(info, requestFocus);
    }

    public final void updateActive() {
        this.checkActive();
        SwingUtilities.invokeLater(() -> EditorTabs.updateActive$lambda$0(this));
    }

    private final void checkActive() {
        boolean newActive = UIUtil.isFocusAncestor((Component)((Component)((Object)this)));
        if (newActive != this.isActive) {
            this.isActive = newActive;
            this.resetScrollBarActivity();
            this.revalidateAndRepaint();
        }
    }

    public boolean isActiveTabs(@Nullable TabInfo info) {
        return this.isActive;
    }

    @Nullable
    public TabInfo getToSelectOnRemoveOf(@NotNull TabInfo tab) {
        VirtualFile file2;
        int indexToSelect;
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        if (this.window.isDisposed()) {
            return null;
        }
        int index = this.getIndexOf(tab);
        if (index != -1 && (indexToSelect = this.window.computeIndexToSelect$intellij_platform_ide_impl(file2 = EditorWindowKt.getComposite(tab).getFile(), index)) >= 0 && indexToSelect < this.getTabs().size()) {
            return this.getTabAt(indexToSelect);
        }
        return super.getToSelectOnRemoveOf(tab);
    }

    public void revalidateAndRepaint(boolean layoutNow) {
        if (this.window != null && !this.window.getOwner().isInsideChange$intellij_platform_ide_impl()) {
            super.revalidateAndRepaint(layoutNow);
        }
    }

    private static final void _init_$lambda$0(EditorTabs this$0, AWTEvent it) {
        this$0.updateActive();
    }

    private static final Unit _init_$lambda$1(AWTEventListener $listener, Throwable it) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
        return Unit.INSTANCE;
    }

    private static final void updateActive$lambda$0(EditorTabs this$0) {
        this$0.checkActive();
    }
}

