/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi.impl;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.syntax.psi.impl.CompositeNode;
import com.intellij.platform.syntax.psi.impl.ErrorNode;
import com.intellij.platform.syntax.psi.impl.LazyParseableToken;
import com.intellij.platform.syntax.psi.impl.NodeBase;
import com.intellij.platform.syntax.psi.impl.NodeData;
import com.intellij.platform.syntax.psi.impl.SingleLexemeNode;
import com.intellij.platform.syntax.psi.impl.Token;
import com.intellij.platform.syntax.psi.impl.TokenRangeNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0002H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00022\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u0018H\u0016J'\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dJ&\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004J6\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/intellij/platform/syntax/psi/impl/MyTreeStructure;", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "root", "Lcom/intellij/platform/syntax/psi/impl/CompositeNode;", "parentTree", "<init>", "(Lcom/intellij/platform/syntax/psi/impl/CompositeNode;Lcom/intellij/platform/syntax/psi/impl/MyTreeStructure;)V", "rangePool", "Lcom/intellij/util/containers/LimitedPool;", "Lcom/intellij/platform/syntax/psi/impl/TokenRangeNode;", "lexemePool", "Lcom/intellij/platform/syntax/psi/impl/SingleLexemeNode;", "count", "", "nodes", "", "[Lcom/intellij/lang/LighterASTNode;", "getRoot", "getParent", "node", "getChildren", "item", "into", "Lcom/intellij/openapi/util/Ref;", "disposeChildren", "", "([Lcom/intellij/lang/LighterASTNode;I)V", "ensureNodesCapacity", "()[Lcom/intellij/lang/LighterASTNode;", "insertLeaves", "curToken", "lastIdx", "data", "Lcom/intellij/platform/syntax/psi/impl/NodeData;", "parent", "insertLeaf", "type", "Lcom/intellij/psi/tree/IElementType;", "startLexemeIndex", "endLexemeIndex", "forceInsertion", "", "toString", "", "getStartOffset", "getEndOffset", "intellij.platform.syntax.psi"})
public final class MyTreeStructure
implements FlyweightCapableTreeStructure<LighterASTNode> {
    @NotNull
    private final CompositeNode root;
    @NotNull
    private final LimitedPool<TokenRangeNode> rangePool;
    @NotNull
    private final LimitedPool<SingleLexemeNode> lexemePool;
    private int count;
    @Nullable
    private LighterASTNode[] nodes;

    public MyTreeStructure(@NotNull CompositeNode root, @Nullable MyTreeStructure parentTree) {
        LimitedPool limitedPool;
        this.root = root;
        LimitedPool limitedPool2 = parentTree;
        if (limitedPool2 == null || (limitedPool2 = limitedPool2.rangePool) == null) {
            limitedPool2 = this.rangePool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<TokenRangeNode>(){

                public TokenRangeNode create() {
                    return new TokenRangeNode();
                }
            });
        }
        if ((limitedPool = parentTree) == null || (limitedPool = limitedPool.lexemePool) == null) {
            limitedPool = new LimitedPool(1000, (LimitedPool.ObjectFactory)new LimitedPool.ObjectFactory<SingleLexemeNode>(){

                public SingleLexemeNode create() {
                    return new SingleLexemeNode();
                }
            });
        }
        this.lexemePool = limitedPool;
    }

    @NotNull
    public LighterASTNode getRoot() {
        return this.root;
    }

    @Nullable
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        if (node instanceof NodeBase) {
            return ((NodeBase)node).getParent();
        }
        if (node instanceof Token) {
            return ((Token)node).getParentNode();
        }
        throw new UnsupportedOperationException("Unknown node type: " + node);
    }

    public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
        if (item instanceof LazyParseableToken) {
            FlyweightCapableTreeStructure<LighterASTNode> tree2 = ((LazyParseableToken)item).parseContents();
            LighterASTNode root = (LighterASTNode)tree2.getRoot();
            if (root instanceof NodeBase) {
                ((NodeBase)root).setParent(((LazyParseableToken)item).getParentNode());
            }
            return tree2.getChildren((Object)root, into);
        }
        if (item instanceof Token || item instanceof ErrorNode) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.psi.impl.CompositeNode");
        CompositeNode marker = (CompositeNode)item;
        this.count = 0;
        int lexIndex = marker._getIndex();
        for (NodeBase child = marker.getMyFirstChild(); child != null; child = child.getNext()) {
            lexIndex = this.insertLeaves(lexIndex, child._getIndex(), marker.getNodeData(), marker);
            if (child instanceof CompositeNode && ((CompositeNode)child).isCollapsed()) {
                int lastIndex = ((CompositeNode)child).getEndIndex();
                IElementType iElementType = ((CompositeNode)child).getTokenType();
                Intrinsics.checkNotNull((Object)iElementType);
                this.insertLeaf(iElementType, marker.getNodeData(), ((CompositeNode)child)._getIndex(), lastIndex, true, marker);
            } else {
                LighterASTNode[] nodes = this.ensureNodesCapacity();
                int n = this.count;
                this.count = n + 1;
                nodes[n] = child;
            }
            if (!(child instanceof CompositeNode)) continue;
            lexIndex = ((CompositeNode)child).getEndIndex();
        }
        this.insertLeaves(lexIndex, marker.getEndIndex(), marker.getNodeData(), marker);
        into.set((Object)(this.nodes == null ? LighterASTNode.EMPTY_ARRAY : this.nodes));
        this.nodes = null;
        return this.count;
    }

    public void disposeChildren(@Nullable LighterASTNode[] nodes, int count) {
        if (nodes == null) {
            return;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            LighterASTNode node = nodes[i2];
            if (node instanceof TokenRangeNode) {
                this.rangePool.recycle((Object)node);
                continue;
            }
            if (!(node instanceof SingleLexemeNode)) continue;
            this.lexemePool.recycle((Object)node);
        }
    }

    private final LighterASTNode[] ensureNodesCapacity() {
        LighterASTNode[] old = this.nodes;
        if (old == null) {
            LighterASTNode[] lighterASTNodeArray = new LighterASTNode[10];
            this.nodes = lighterASTNodeArray;
            return lighterASTNodeArray;
        }
        if (this.count >= old.length) {
            LighterASTNode[] lighterASTNodeArray = Arrays.copyOf(old, this.count * 3 / 2);
            Intrinsics.checkNotNullExpressionValue((Object)lighterASTNodeArray, (String)"copyOf(...)");
            LighterASTNode[] lighterASTNodeArray2 = lighterASTNodeArray;
            this.nodes = lighterASTNodeArray2;
            return lighterASTNodeArray2;
        }
        return old;
    }

    public final int insertLeaves(int curToken, int lastIdx, @NotNull NodeData data2, @NotNull CompositeNode parent) {
        int curToken2;
        int lastIdx2 = lastIdx;
        lastIdx2 = Math.min(lastIdx2, data2.getLexemeCount());
        for (curToken2 = curToken; curToken2 < lastIdx2; ++curToken2) {
            this.insertLeaf(data2.getLexemeType(curToken2), data2, curToken2, curToken2 + 1, false, parent);
        }
        return curToken2;
    }

    public final void insertLeaf(@NotNull IElementType type, @NotNull NodeData data2, int startLexemeIndex, int endLexemeIndex, boolean forceInsertion, @NotNull CompositeNode parent) {
        int end;
        int start2 = data2.getLexStarts()[startLexemeIndex];
        if (start2 > (end = data2.getLexStarts()[endLexemeIndex]) || !forceInsertion && start2 == end && !(type instanceof ILeafElementType)) {
            return;
        }
        Token lexeme = null;
        if (type instanceof ILightLazyParseableElementType) {
            int startInFile = start2 + data2.getOffset();
            LazyParseableToken token = (LazyParseableToken)data2.getChameleonCache().get(startInFile);
            if (token == null) {
                token = new LazyParseableToken(this, startLexemeIndex, endLexemeIndex);
                token.initToken(type, parent, start2, end);
                data2.getChameleonCache().put(startInFile, (Object)token);
            } else if (token.getNodeData() != data2 || token.getStartIndex() != startLexemeIndex || token.getEndIndex() != endLexemeIndex) {
                throw new AssertionError((Object)"Wrong chameleon cached");
            }
            lexeme = token;
        } else if (startLexemeIndex == endLexemeIndex - 1 && type == data2.getLexemeType(startLexemeIndex)) {
            SingleLexemeNode single = (SingleLexemeNode)this.lexemePool.alloc();
            single.setParentNode(parent);
            single.setLexemeIndex(startLexemeIndex);
            lexeme = single;
        } else {
            TokenRangeNode collapsed = (TokenRangeNode)this.rangePool.alloc();
            collapsed.initToken(type, parent, start2, end);
            lexeme = collapsed;
        }
        LighterASTNode[] nodes = this.ensureNodesCapacity();
        int n = this.count;
        this.count = n + 1;
        nodes[n] = lexeme;
    }

    @NotNull
    public CharSequence toString(@NotNull LighterASTNode node) {
        return this.root.getNodeData().getText().subSequence(node.getStartOffset(), node.getEndOffset());
    }

    public int getStartOffset(@NotNull LighterASTNode node) {
        return node.getStartOffset();
    }

    public int getEndOffset(@NotNull LighterASTNode node) {
        return node.getEndOffset();
    }
}

