/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Stripe
extends AbstractDroppableStripe
implements UISettingsListener {
    static final Key<Rectangle> VIRTUAL_BOUNDS = Key.create((String)"Virtual stripe bounds");
    private final int anchor;

    Stripe(@NotNull String paneId, int anchor) {
        if (paneId == null) {
            Stripe.$$$reportNull$$$0(0);
        }
        super(paneId, new GridBagLayout());
        this.setOpaque(true);
        this.anchor = anchor;
        this.setBorder(new AdaptiveBorder());
    }

    @Override
    public boolean isNewStripes() {
        return false;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        if (this.computedPreferredSize == null) {
            this.computedPreferredSize = this.getButtons().isEmpty() ? JBUI.emptySize() : this.recomputeBounds((boolean)false, null, (boolean)false).size;
        }
        Dimension dimension = this.computedPreferredSize;
        if (dimension == null) {
            Stripe.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        Dimension size2 = this.getSize();
        if (size2.width == 0 && size2.height == 0) {
            Rectangle virtualBounds = (Rectangle)this.getClientProperty(VIRTUAL_BOUNDS);
            size2 = virtualBounds.getSize();
        }
        this.doLayout(size2);
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            Stripe.$$$reportNull$$$0(2);
        }
        this.updatePresentation();
    }

    @Override
    @NotNull
    public ToolWindowAnchor getAnchor() {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.get((int)this.anchor);
        if (toolWindowAnchor == null) {
            Stripe.$$$reportNull$$$0(3);
        }
        return toolWindowAnchor;
    }

    public void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public void stopDrag() {
        this.revalidate();
        this.repaint();
    }

    @Override
    @Nullable
    public StripeButtonManager getButtonFor(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            Stripe.$$$reportNull$$$0(4);
        }
        for (StripeButtonManager it : this.getButtons()) {
            if (!it.getId().equals(toolWindowId)) continue;
            return it;
        }
        return null;
    }

    public void setOverlaid(boolean overlaid) {
        Color bg = JBColor.PanelBackground;
        if (overlaid) {
            this.setBackground(ColorUtil.toAlpha((Color)bg, (int)190));
        } else {
            this.setBackground(bg);
        }
    }

    @Override
    public boolean isHorizontal() {
        return this.anchor == 1 || this.anchor == 3;
    }

    @Override
    public boolean containsPoint(@NotNull Point screenPoint) {
        Rectangle bounds;
        if (screenPoint == null) {
            Stripe.$$$reportNull$$$0(5);
        }
        Point point = screenPoint.getLocation();
        SwingUtilities.convertPointFromScreen(point, (Component)(this.isVisible() ? this : this.getParent()));
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.isVisible() && (bounds = (Rectangle)ClientProperty.get((Component)((Object)this), VIRTUAL_BOUNDS)) != null) {
            point.x -= bounds.x;
            point.y -= bounds.y;
            width = bounds.width;
            height = bounds.height;
        }
        int areaSize = Math.min(Math.min(this.getParent().getWidth() / 2, this.getParent().getHeight() / 2), JBUI.scale((int)200));
        Point[] points = new Point[]{new Point(0, 0), new Point(width, 0), new Point(width, height), new Point(0, height)};
        switch (this.anchor) {
            case 1: {
                Stripe.updateLocation(points, 1, 2, 0, 0, areaSize);
                Stripe.updateLocation(points, 0, 3, 0, 0, areaSize);
                break;
            }
            case 2: {
                Stripe.updateLocation(points, 0, 1, 1, 0, areaSize);
                Stripe.updateLocation(points, 3, 2, 1, -1, areaSize);
                break;
            }
            case 3: {
                Stripe.updateLocation(points, 3, 0, 1, -1, areaSize);
                Stripe.updateLocation(points, 2, 1, -1, -1, areaSize);
                break;
            }
            case 4: {
                Stripe.updateLocation(points, 1, 0, -1, 0, areaSize);
                Stripe.updateLocation(points, 2, 3, -1, 1, areaSize);
            }
        }
        return new Polygon(new int[]{points[0].x, points[1].x, points[2].x, points[3].x}, new int[]{points[0].y, points[1].y, points[2].y, points[3].y}, 4).contains(point);
    }

    private static void updateLocation(Point[] points, int indexBase, int indexDest, int xSign, int ySign, int areaSize) {
        points[indexDest].setLocation(points[indexBase].x + xSign * areaSize, points[indexBase].y + ySign * areaSize);
    }

    public String toString() {
        @NonNls String anchor = switch (this.anchor) {
            case 1 -> "TOP";
            case 3 -> "BOTTOM";
            case 2 -> "LEFT";
            case 4 -> "RIGHT";
            default -> null;
        };
        return ((Object)((Object)this)).getClass().getName() + " " + anchor;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            Stripe.$$$reportNull$$$0(6);
        }
        super.paintComponent(g);
        if (!StartupUiUtil.isUnderDarcula()) {
            ToolWindowAnchor anchor = this.getAnchor();
            g.setColor(Gray._255.withAlpha(40));
            Rectangle r = this.getBounds();
            if (anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.RIGHT) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)r.height);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(r.width - 2), (double)0.0, (double)(r.width - 2), (double)r.height);
            } else {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)1.0, (double)r.width, (double)1.0);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)(r.height - 1), (double)r.width, (double)(r.height - 1));
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStripe();
        }
        this.accessibleContext.setAccessibleName(this.getAccessibleStripeName());
        return this.accessibleContext;
    }

    @NlsSafe
    private String getAccessibleStripeName() {
        if (this.getButtons().isEmpty()) {
            return "";
        }
        return switch (this.anchor) {
            case 1 -> UIBundle.message((String)"stripe.top.accessible.group.name", (Object[])new Object[0]);
            case 3 -> UIBundle.message((String)"stripe.bottom.accessible.group.name", (Object[])new Object[0]);
            case 2 -> UIBundle.message((String)"stripe.left.accessible.group.name", (Object[])new Object[0]);
            case 4 -> UIBundle.message((String)"stripe.right.accessible.group.name", (Object[])new Object[0]);
            default -> "";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paneId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/toolWindow/Stripe";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/toolWindow/Stripe";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getButtonFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsPoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static final class AdaptiveBorder
    implements Border {
        private AdaptiveBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                AdaptiveBorder.$$$reportNull$$$0(0);
            }
            Insets insets = ((JComponent)c).getInsets();
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            AdaptiveBorder.drawBorder((Graphics2D)g, x, y, width, height, insets);
        }

        private static void drawBorder(Graphics2D g, int x, int y, int width, int height, Insets insets) {
            if (insets.top == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
            }
            if (insets.right == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
            }
            if (insets.left == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
            if (insets.bottom == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + height - 1), (double)(x + width), (double)(y + height - 1));
            }
            if (!StartupUiUtil.isUnderDarcula()) {
                return;
            }
            Color c = g.getColor();
            if (insets.top == 2) {
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + 1), (double)(x + width), (double)(y + 1));
            }
            if (insets.right == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 2), (double)y, (double)(x + width - 2), (double)(y + height));
            }
            if (insets.left == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + 1), (double)y, (double)(x + 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            Stripe stripe;
            ToolWindowAnchor anchor;
            if (c == null) {
                AdaptiveBorder.$$$reportNull$$$0(1);
            }
            if ((anchor = (stripe = (Stripe)((Object)c)).getAnchor()) == ToolWindowAnchor.LEFT) {
                return new Insets(1, 0, 0, 1);
            }
            if (anchor == ToolWindowAnchor.RIGHT) {
                return new Insets(1, 1, 0, 0);
            }
            if (anchor == ToolWindowAnchor.TOP) {
                return new Insets(1, 0, 0, 0);
            }
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "c";
            objectArray2[1] = "com/intellij/toolWindow/Stripe$AdaptiveBorder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBorder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBorderInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AccessibleStripe
    extends JPanel.AccessibleJPanel {
        private AccessibleStripe() {
            super((JPanel)((Object)Stripe.this));
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibilityUtils.GROUPED_ELEMENTS;
        }
    }
}

