/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.lang.reflect.Field;

public class TempFieldAccessor<E, T> {
    private MyRef<Field> myFieldRef;
    private final Class<E> myClass;
    private final String myName;

    public TempFieldAccessor(String clsFQN, String name2) {
        Class<?> c = null;
        try {
            c = Class.forName(clsFQN);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.myClass = c;
        this.myName = name2;
    }

    public boolean isAvailable() {
        if (this.myFieldRef == null) {
            try {
                this.myFieldRef = new MyRef();
                this.myFieldRef.set(this.myClass == null ? null : this.myClass.getDeclaredField(this.myName));
                this.myFieldRef.get().setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return this.myFieldRef.get() != null;
    }

    public T get(E object) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            Object value = this.myFieldRef.get().get(object);
            return (T)value;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public void set(E object, T value) {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.myFieldRef.get().set(object, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static class MyRef<T> {
        T myValue;

        public MyRef() {
        }

        public MyRef(T value) {
            this.myValue = value;
        }

        public void set(T value) {
            this.myValue = value;
        }

        public T get() {
            return this.myValue;
        }
    }
}

