/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.dictionary;

import ai.grazie.nlp.langs.alphabet.Alphabet;
import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.spell.lists.WordList;
import com.intellij.codeWithMe.ClientId;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.spellcheck.GrazieCheckers;
import com.intellij.grazie.spellcheck.dictionary.EditableWordListAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.spellchecker.dictionary.Dictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J \u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000fj\b\u0012\u0004\u0012\u00020\b`\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/spellcheck/dictionary/WordListAdapter;", "Lai/grazie/spell/lists/WordList;", "Lcom/intellij/grazie/spellcheck/dictionary/EditableWordListAdapter;", "<init>", "()V", "isAlien", "", "word", "", "contains", "caseSensitive", "hunspell", "", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nWordListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/grazie/spellcheck/dictionary/WordListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,57:1\n777#2:58\n873#2,2:59\n1807#2,3:64\n1807#2,3:67\n42#3,3:61\n*S KotlinDebug\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/grazie/spellcheck/dictionary/WordListAdapter\n*L\n20#1:58\n20#1:59,2\n29#1:64,3\n35#1:67,3\n21#1:61,3\n*E\n"})
public final class WordListAdapter
extends EditableWordListAdapter
implements WordList {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAlien(@NotNull String word) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (Alphabet.Companion.getENGLISH().matchAny((CharSequence)word)) {
            return false;
        }
        Iterable $this$filter$iv = GrazieConfig.Companion.get().getAvailableLanguages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl = false;
            if (!ExtensionsKt.toLanguage(it).getAlphabet().matchEntire((CharSequence)word)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List matchedLanguages = (List)destination$iv$iv;
        if (!matchedLanguages.isEmpty()) {
            boolean $i$f$service = false;
            Class<GrazieCheckers> serviceClass$iv = GrazieCheckers.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            if (((GrazieCheckers)object).hasSpellerTool(matchedLanguages)) return false;
        }
        if (WordList.contains$default((WordList)this.getAggregator(), (String)word, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean contains(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.contains(word, caseSensitive, GrazieConfig.Companion.get().getDictionaries()) || this.getAggregator().contains(word, caseSensitive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean contains(String word, boolean caseSensitive, List<? extends Dictionary> hunspell) {
        Object element$iv3;
        boolean bl;
        if (caseSensitive) {
            boolean bl2;
            Dictionary it;
            boolean bl3;
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl3 = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it = (Dictionary)element$iv2;
                    boolean bl4 = false;
                    if (it.lookup(word) == Dictionary.LookupStatus.Present) {
                        return true;
                    }
                    boolean bl5 = false;
                    if (!bl5) continue;
                    return true;
                }
                bl3 = false;
            }
            if (bl3) return true;
            $this$any$iv = hunspell;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                Object element$iv2;
                if (!iterator.hasNext()) return false;
                element$iv2 = iterator.next();
                it = (Dictionary)element$iv2;
                boolean bl6 = false;
                if (it.lookup(word) == Dictionary.LookupStatus.Present) {
                    return true;
                }
                bl2 = false;
            } while (!bl2);
            return true;
        }
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowered = string;
        Function1 isPresent = arg_0 -> WordListAdapter.contains$lambda$2(lowered, word, arg_0);
        Collection<Dictionary> collection = this.getDictionaries().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$any$iv = collection;
        boolean $i$f$any = false;
        if (((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv3 : $this$any$iv) {
                if (!((Boolean)isPresent.invoke(element$iv3)).booleanValue()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = hunspell;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!((Boolean)isPresent.invoke(element$iv3 = iterator.next())).booleanValue());
        return true;
    }

    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<Dictionary> iterator = this.getDictionaries().values().iterator();
        while (iterator.hasNext()) {
            Dictionary dictionary;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            dictionary.consumeSuggestions(word, arg_0 -> WordListAdapter.suggest$lambda$0(word, result, arg_0));
        }
        result.addAll((Collection)this.getAggregator().suggest(word));
        result.remove("");
        return result;
    }

    private static final boolean contains$lambda$2(String $lowered, String $word, Dictionary it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.lookup($lowered) == Dictionary.LookupStatus.Present || it.lookup($word) == Dictionary.LookupStatus.Present;
    }

    private static final void suggest$lambda$0(String $word, LinkedHashSet $result, String it) {
        Intrinsics.checkNotNull((Object)it);
        if (((CharSequence)it).length() == 0) {
            return;
        }
        int distance = Levenshtein.distance$default((String)$word, (String)it, (int)4, (boolean)false, (int)8, null);
        if (distance <= 3) {
            $result.add(it);
        }
    }
}

