/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.EventuallyConsistentTextExtractor;
import com.intellij.grazie.text.StrategyTextExtractor;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentModificationTrackerProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class TextExtractor {
    private static final Logger LOG = Logger.getInstance(TextExtractor.class);
    @VisibleForTesting
    @ApiStatus.Internal
    public static final LanguageExtension<TextExtractor> EP = new LanguageExtension("com.intellij.grazie.textExtractor");
    private static final Key<CachedValue<Cache>> COMMON_PARENT_CACHE = Key.create((String)"TextExtractor common parent cache");
    private static final Key<CachedValue<AtomicReference<List<TextContent>>>> QUERY_CACHE = Key.create((String)"TextExtractor query cache");
    private static final Key<Boolean> IGNORED = Key.create((String)"TextExtractor ignored");
    private static final Key<CachedValue<Map<TextContent, TextContent>>> CONTENT_INTERNER = Key.create((String)"TextExtractor interner");
    private static final Pattern NOINSPECTION_SUPPRESSION = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");
    private static final Pattern PROPERTY_SUPPRESSION = Pattern.compile("\\s*suppress inspection \"[a-zA-Z_0-9.-]+\"");
    private static final Pattern LICENSE_PATTERN = Pattern.compile("(?i)License.*?(as is|MIT|GNU|GPL|Apache|BSD)", 32);

    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("Please implement either buildTextContent or buildTextContents");
    }

    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(2);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.buildTextContent(element, allowedDomains));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static TextContent findTextAt(@NotNull PsiFile file, int offset, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        PsiElement leaf;
        TextContent result;
        if (file == null) {
            TextExtractor.$$$reportNull$$$0(5);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(6);
        }
        TextContent textContent = result = (leaf = file.findElementAt(offset)) == null ? null : (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        if (result != null) {
            return result;
        }
        if ((leaf == null || offset == leaf.getTextRange().getStartOffset()) && (leaf = file.findElementAt(offset - 1)) != null) {
            return (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static List<TextContent> findTextsExactlyAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(7);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(8);
        }
        PsiFile file = psi.getContainingFile();
        List list = ContainerUtil.filter(TextExtractor.obtainContents(file, psi), c -> Boolean.FALSE.equals(c.getUserData(IGNORED)) && allowedDomains.contains((Object)c.getDomain()));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static @Unmodifiable @NotNull List<TextContent> findTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        PsiElement each;
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(10);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(11);
        }
        TextRange psiRange = psi.getTextRange();
        PsiFile file = null;
        for (each = psi; each != null; each = each.getParent()) {
            List textsInRange;
            CachedValue cache = (CachedValue)each.getUserData(COMMON_PARENT_CACHE);
            if (cache != null && !(textsInRange = ContainerUtil.filter(((Cache)cache.getValue()).getCached(), c -> c.intersectsRange(psiRange))).isEmpty()) {
                List list = ContainerUtil.filter((Collection)textsInRange, c -> allowedDomains.contains((Object)c.getDomain()) && Boolean.FALSE.equals(c.getUserData(IGNORED)));
                if (list == null) {
                    TextExtractor.$$$reportNull$$$0(12);
                }
                return list;
            }
            if (!(each instanceof PsiFile)) continue;
            file = (PsiFile)each;
            break;
        }
        for (each = psi; each != null && each != file; each = each.getParent()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            List<TextContent> contents = TextExtractor.obtainContents(file != null ? file : psi.getContainingFile(), each);
            if (stamp.mayCacheNow() && !contents.isEmpty()) {
                StreamEx.of(contents).groupingBy(TextContent::getCommonParent).forEach((commonParent, group) -> TextExtractor.obtainCommonParentCache(commonParent).register((List<TextContent>)group));
            }
            if (contents.isEmpty()) continue;
            List list = ContainerUtil.filter(contents, c -> Boolean.FALSE.equals(c.getUserData(IGNORED)) && allowedDomains.contains((Object)c.getDomain()) && c.intersectsRange(psiRange));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static AtomicReference<List<TextContent>> obtainQueryCache(PsiElement psi) {
        return TextExtractor.obtainCache(psi, QUERY_CACHE, () -> new AtomicReference<Object>(null));
    }

    private static Cache obtainCommonParentCache(PsiElement psi) {
        return TextExtractor.obtainCache(psi, COMMON_PARENT_CACHE, () -> new Cache());
    }

    private static <T> T obtainCache(PsiElement psi, Key<CachedValue<T>> key, Supplier<T> supplier) {
        TextContentModificationTrackerProvider provider = (TextContentModificationTrackerProvider)TextContentModificationTrackerProvider.EP_NAME.forLanguage(psi.getLanguage());
        ModificationTracker providedTracker = provider != null ? provider.getModificationTracker(psi) : null;
        ModificationTracker tracker = providedTracker != null ? providedTracker : PsiModificationTracker.MODIFICATION_COUNT;
        CachedValue cache = CachedValuesManager.getManager((Project)psi.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(supplier.get(), (Object[])new Object[]{tracker}));
        cache = (CachedValue)((UserDataHolderEx)psi).putUserDataIfAbsent(key, (Object)cache);
        return (T)cache.getValue();
    }

    private static Map<TextContent, TextContent> obtainInterner(PsiFile file) {
        CachedValue cache = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentWeakKeyWeakValueMap(), (Object[])new Object[]{file}));
        cache = (CachedValue)((UserDataHolderEx)file).putUserDataIfAbsent(CONTENT_INTERNER, (Object)cache);
        return (Map)cache.getValue();
    }

    private static List<TextContent> obtainContents(PsiFile file, PsiElement psi) {
        List cachedContent;
        CachedValue cv = (CachedValue)psi.getUserData(QUERY_CACHE);
        List list = cachedContent = cv != null ? (List)((AtomicReference)cv.getValue()).get() : null;
        if (cachedContent != null) {
            return cachedContent;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Language psiLanguage = psi.getLanguage();
        List contents = TextExtractor.doExtract(psi, psiLanguage);
        Language fileLanguage = file.getLanguage();
        if (contents.isEmpty() && fileLanguage != psiLanguage) {
            contents = TextExtractor.doExtract(psi, fileLanguage);
        }
        if (contents.isEmpty()) {
            return List.of();
        }
        Map<TextContent, TextContent> interner = TextExtractor.obtainInterner(file);
        contents = ContainerUtil.map(contents, content -> interner.computeIfAbsent((TextContent)content, __ -> content));
        for (TextContent content2 : contents) {
            if (content2.getUserData(IGNORED) != null) continue;
            content2.putUserData(IGNORED, TextExtractor.shouldIgnore(content2));
        }
        if (stamp.mayCacheNow()) {
            TextExtractor.obtainQueryCache(psi).compareAndSet(null, contents);
            TextExtractor.cacheOnSiblings(psi, contents);
        }
        return contents;
    }

    private static void cacheOnSiblings(PsiElement psi, List<TextContent> contents) {
        contents.forEach(content -> {
            int startOffset = content.textOffsetToFile(0);
            int endOffset = content.textOffsetToFile(content.length());
            TextRange psiRangeInFile = psi.getTextRange();
            if (psiRangeInFile.getStartOffset() > startOffset || psiRangeInFile.getEndOffset() < endOffset) {
                for (ASTNode child : psi.getParent().getNode().getChildren(null)) {
                    PsiElement sibling = child.getPsi();
                    List<TextContent> intersectingContents = contents.stream().filter(it -> it.intersectsRange(sibling.getTextRange())).toList();
                    if (intersectingContents.isEmpty()) continue;
                    TextExtractor.obtainQueryCache(sibling).compareAndSet(null, intersectingContents);
                }
            }
        });
    }

    private static boolean shouldIgnore(TextContent content) {
        return TextExtractor.isSuppressionComment(content) || TextExtractor.isCopyrightComment(content) || TextExtractor.hasIntersectingInjection(content, content.getContainingFile());
    }

    private static boolean isCopyrightComment(TextContent content) {
        return !(content.getDomain() != TextContent.TextDomain.COMMENTS && content.getDomain() != TextContent.TextDomain.DOCUMENTATION || !StringUtil.containsIgnoreCase((String)content.toString(), (String)"Copyright") || !TextExtractor.isAtFileStart(content) && !TextExtractor.looksLikeLicense(content));
    }

    private static boolean looksLikeLicense(TextContent content) {
        return LICENSE_PATTERN.matcher(content).find();
    }

    private static boolean isAtFileStart(TextContent content) {
        PsiFile file = content.getContainingFile();
        int textStart = content.textOffsetToFile(0);
        return file.getViewProvider().getContents().subSequence(0, textStart).chars().noneMatch(Character::isLetterOrDigit);
    }

    private static boolean isSuppressionComment(TextContent content) {
        return content.getDomain() == TextContent.TextDomain.COMMENTS && (NOINSPECTION_SUPPRESSION.matcher(content).lookingAt() || PROPERTY_SUPPRESSION.matcher(content).lookingAt());
    }

    public static @Unmodifiable @NotNull List<TextContent> findUniqueTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(15);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(16);
        }
        if (psi.getFirstChild() != null) {
            List<TextContent> list = Collections.emptyList();
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(17);
            }
            return list;
        }
        TextRange psiRange = psi.getTextRange();
        List list = ContainerUtil.filter(TextExtractor.findTextsAt(psi, allowedDomains), c -> psiRange.contains(c.textOffsetToFile(0)));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(18);
        }
        return list;
    }

    public static Set<TextContent> findAllTextContents(FileViewProvider vp, Set<TextContent.TextDomain> domains) {
        HashSet<TextContent> allContents = new HashSet<TextContent>();
        for (PsiFile root : vp.getAllFiles()) {
            for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)root)) {
                if (element instanceof PsiWhiteSpace) continue;
                allContents.addAll(TextExtractor.findTextsAt(element, domains));
            }
        }
        return allContents;
    }

    private static boolean hasIntersectingInjection(TextContent content, PsiFile file) {
        return InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, content.textOffsetToFile(0)) != null;
    }

    @NotNull
    private static List<TextContent> doExtract(@NotNull PsiElement anyRoot, @NotNull Language language) {
        TextExtractor extractor;
        if (anyRoot == null) {
            TextExtractor.$$$reportNull$$$0(19);
        }
        if (language == null) {
            TextExtractor.$$$reportNull$$$0(20);
        }
        if ((extractor = (TextExtractor)EP.forLanguage(language)) != null) {
            List<TextContent> contents = extractor.buildTextContents(anyRoot, TextContent.TextDomain.ALL);
            for (TextContent content : contents) {
                if (content.getCommonParent().getTextRange().contains(content.textRangeToFile(TextRange.from((int)0, (int)content.length())))) continue;
                if (!(extractor instanceof EventuallyConsistentTextExtractor)) {
                    PluginException.logPluginError((Logger)LOG, (String)"Inconsistent text content", null, extractor.getClass());
                }
                List<TextContent> list = List.of();
                if (list == null) {
                    TextExtractor.$$$reportNull$$$0(21);
                }
                return list;
            }
            List<TextContent> list = contents;
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(22);
            }
            return list;
        }
        for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(language)) {
            GrammarCheckingStrategy.TextDomain oldDomain;
            TextContent.TextDomain domain;
            if (!strategy.isMyContextRoot(anyRoot) || (domain = StrategyTextExtractor.convertDomain(oldDomain = strategy.getContextRootTextDomain(anyRoot))) == null) continue;
            List list = ContainerUtil.createMaybeSingletonList((Object)new StrategyTextExtractor(strategy).extractText(strategy.getRootsChain(anyRoot)));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(24);
        }
        return list;
    }

    public static Set<Language> getSupportedLanguages() {
        HashSet<Language> result = new HashSet<Language>();
        ExtensionPoint ep = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(EP.getName());
        for (LanguageExtensionPoint point : ep.getExtensionList()) {
            ContainerUtil.addIfNotNull(result, (Object)Language.findLanguageByID((String)point.language));
        }
        for (LanguageExtensionPoint point : LanguageGrammarChecking.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result, (Object)Language.findLanguageByID((String)point.language));
        }
        return result;
    }

    @TestOnly
    @NotNull
    public List<TextContent> buildTextContentsTestAccessor(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(25);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(26);
        }
        List<TextContent> list = this.buildTextContents(element, allowedDomains);
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(27);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 12, 13, 14, 17, 18, 21, 22, 23, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyRoot";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTextsExactlyAt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findTextsAt";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findUniqueTextsAt";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContentsTestAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTextAt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTextsExactlyAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTextsAt";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueTextsAt";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doExtract";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContentsTestAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 12, 13, 14, 17, 18, 21, 22, 23, 24, 27 -> new IllegalStateException(string);
        };
    }

    private static class Cache {
        private final Set<TextContent> foundContents = new LinkedHashSet<TextContent>();

        private Cache() {
        }

        synchronized void register(List<TextContent> contents) {
            this.foundContents.addAll(contents);
        }

        synchronized List<TextContent> getCached() {
            return new ArrayList<TextContent>(this.foundContents);
        }
    }
}

