/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class ProblemHighlightFilter {
    public static final ExtensionPointName<ProblemHighlightFilter> EP_NAME = new ExtensionPointName("com.intellij.problemHighlightFilter");
    private static final Logger LOG = Logger.getInstance(ProblemHighlightFilter.class);

    public abstract boolean shouldHighlight(@NotNull PsiFile var1);

    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ProblemHighlightFilter.$$$reportNull$$$0(0);
        }
        return this.shouldHighlight(psiFile);
    }

    public static boolean shouldHighlightFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ProblemHighlightFilter.$$$reportNull$$$0(1);
        }
        return ProblemHighlightFilter.shouldProcess(psiFile, true);
    }

    public static boolean shouldProcessFileInBatch(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ProblemHighlightFilter.$$$reportNull$$$0(2);
        }
        return ProblemHighlightFilter.shouldProcess(psiFile, false);
    }

    private static boolean shouldProcess(@NotNull PsiFile psiFile, boolean onTheFly) {
        if (psiFile == null) {
            ProblemHighlightFilter.$$$reportNull$$$0(3);
        }
        boolean isDebugEnabled = LOG.isDebugEnabled();
        for (ProblemHighlightFilter filter : EP_NAME.getExtensionList()) {
            boolean shouldHighlight;
            boolean bl = shouldHighlight = onTheFly ? filter.shouldHighlight(psiFile) : filter.shouldProcessInBatch(psiFile);
            if (isDebugEnabled && !shouldHighlight) {
                LOG.debug("shouldProcess shouldHighlight(" + psiFile.getName() + ") = " + shouldHighlight + "; filter type: " + String.valueOf(filter.getClass()) + "; onTheFly=" + onTheFly);
            }
            if (shouldHighlight) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiFile";
        objectArray2[1] = "com/intellij/codeInsight/daemon/ProblemHighlightFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcessInBatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcessFileInBatch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

