/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.modcompletion;

import com.intellij.codeInsight.completion.BaseCompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.modcompletion.ModCompletionItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public interface ModCompletionItemProvider {
    public static final LanguageExtension<ModCompletionItemProvider> EP_NAME = new LanguageExtension("com.intellij.modcompletion.completionItemProvider");

    public void provideItems(CompletionContext var1, Consumer<ModCompletionItem> var2);

    public static List<ModCompletionItemProvider> forLanguage(Language language) {
        return EP_NAME.forKey((Object)language);
    }

    @ApiStatus.Internal
    public static boolean modCommandCompletionEnabled() {
        return Registry.is((String)"ide.completion.modcommand", (boolean)false);
    }

    public record CompletionContext(PsiFile originalFile, int offset, @Nullable PsiElement original, PsiElement element, PrefixMatcher matcher, int invocationCount, CompletionType type) implements BaseCompletionParameters
    {
        public String prefix() {
            return this.matcher.getPrefix();
        }

        public boolean isSmart() {
            return this.type == CompletionType.SMART;
        }

        public boolean isBasic() {
            return this.type == CompletionType.BASIC;
        }

        @Override
        public PsiFile getOriginalFile() {
            return this.originalFile;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public PsiElement getPosition() {
            return this.element;
        }

        @Override
        public CompletionType getCompletionType() {
            return this.type;
        }

        @Override
        @Nullable
        public PsiElement getOriginalPosition() {
            return this.original;
        }

        public Project getProject() {
            return this.originalFile.getProject();
        }
    }
}

