/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.branchConfig.UrlDescriptor;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0004*\u0001\u0016\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0086\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\r\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myLock", "myState", "Lorg/jetbrains/idea/svn/SmallMapSerializer;", "", "", "Lorg/jetbrains/idea/svn/api/Url;", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "myFile", "Ljava/io/File;", "get", "url", "activate", "", "deactivate", "createExternalizer", "org/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1", "()Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1;", "Companion", "intellij.vcs.svn"})
public final class SvnLoadedBranchesStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object myLock;
    @Nullable
    private SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> myState;
    @NotNull
    private final File myFile;

    public SvnLoadedBranchesStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myLock = new Object();
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFile, "svn_branches");
        file.mkdirs();
        this.myFile = new File(file, this.project.getLocationHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Collection<SvnBranchItem> get(@NotNull Url url) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            collection = smallMapSerializer != null && (smallMapSerializer = smallMapSerializer.get("")) != null ? (Collection)smallMapSerializer.get(url) : null;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate() {
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            this.myState = new SmallMapSerializer(this.myFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, this.createExternalizer());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate() {
        Map branchLocations = new LinkedHashMap();
        Map<VirtualFile, SvnBranchConfigurationNew> branchConfigurations = SvnBranchConfigurationManager.Companion.getInstance(this.project).getSvnBranchConfigManager().getMapCopy();
        for (SvnBranchConfigurationNew configuration : branchConfigurations.values()) {
            for (Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> entry : configuration.getBranchMap().entrySet()) {
                Url branchLocation = entry.getKey();
                InfoStorage<List<SvnBranchItem>> branches = entry.getValue();
                branchLocations.put(branchLocation, branches.getValue());
            }
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            Intrinsics.checkNotNull(smallMapSerializer);
            smallMapSerializer.put("", branchLocations);
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer2 = this.myState;
            Intrinsics.checkNotNull(smallMapSerializer2);
            smallMapSerializer2.force();
            this.myState = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final createExternalizer.1 createExternalizer() {
        return new DataExternalizer<Map<Url, ? extends Collection<? extends SvnBranchItem>>>(){

            public void save(DataOutput out, Map<Url, ? extends Collection<SvnBranchItem>> branchLocations) throws IOException {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter(branchLocations, (String)"branchLocations");
                DataOutput $this$save_u24lambda_u240 = out;
                boolean bl = false;
                $this$save_u24lambda_u240.writeInt(branchLocations.size());
                Iterable $this$sortedBy$iv = branchLocations.entrySet();
                boolean $i$f$sortedBy = false;
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((Url)it.getKey()).toDecodedString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Url)it.getKey()).toDecodedString())));
                    }
                })) {
                    Comparator comparator;
                    Url branchLocation = (Url)entry.getKey();
                    Collection branches = (Collection)entry.getValue();
                    UrlDescriptor.ENCODED_URL_DESCRIPTOR.save($this$save_u24lambda_u240, branchLocation);
                    $this$save_u24lambda_u240.writeInt(branches.size());
                    Iterable iterable = branches;
                    Intrinsics.checkNotNullExpressionValue((Object)String.CASE_INSENSITIVE_ORDER, (String)"CASE_INSENSITIVE_ORDER");
                    for (SvnBranchItem item : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(comparator){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = $comparator;
                        }

                        public final int compare(T a, T b) {
                            SvnBranchItem svnBranchItem = (SvnBranchItem)a;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            SvnBranchItem it = (SvnBranchItem)b;
                            String string = it.getUrl().toDecodedString();
                            bl = false;
                            String string2 = it.getUrl().toDecodedString();
                            return comparator.compare(string, string2);
                        }
                    })) {
                        UrlDescriptor.DECODED_URL_DESCRIPTOR.save($this$save_u24lambda_u240, item.getUrl());
                        $this$save_u24lambda_u240.writeLong(item.getCreationDateMillis());
                        $this$save_u24lambda_u240.writeLong(item.getRevision());
                    }
                }
            }

            public Map<Url, Collection<SvnBranchItem>> read(DataInput in) throws IOException {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                DataInput $this$read_u24lambda_u241 = in;
                boolean bl = false;
                Map branchLocations = new LinkedHashMap<K, V>();
                int branchLocationsSize = $this$read_u24lambda_u241.readInt();
                for (int i = 0; i < branchLocationsSize; ++i) {
                    int it = i;
                    boolean bl2 = false;
                    Url branchLocation = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read($this$read_u24lambda_u241);
                    int branchesSize = $this$read_u24lambda_u241.readInt();
                    List branches = new ArrayList<E>();
                    int n = 0;
                    while (n < branchesSize) {
                        int it2 = n++;
                        boolean bl3 = false;
                        Url url = UrlDescriptor.DECODED_URL_DESCRIPTOR.read($this$read_u24lambda_u241);
                        long creationDateMillis = $this$read_u24lambda_u241.readLong();
                        long revision = $this$read_u24lambda_u241.readLong();
                        branches.add(new SvnBranchItem(url, creationDateMillis, revision));
                    }
                    branchLocations.put(branchLocation, branches);
                }
                return branchLocations;
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final SvnLoadedBranchesStorage getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.svn"})
    @SourceDebugExtension(value={"SMAP\nSvnLoadedBranchesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnLoadedBranchesStorage.kt\norg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,104:1\n30#2,2:105\n*S KotlinDebug\n*F\n+ 1 SvnLoadedBranchesStorage.kt\norg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$Companion\n*L\n28#1:105,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SvnLoadedBranchesStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SvnLoadedBranchesStorage> serviceClass$iv = SvnLoadedBranchesStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SvnLoadedBranchesStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

