/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.diff.util.Enumerator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.diff.BitSet;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.MyersLCS;
import com.intellij.util.diff.PatienceIntLCS;
import com.intellij.util.diff.Reindexer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003345B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\rJ1\u0010\u0004\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\nH\u0007\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J0\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002J/\u0010!\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u000e0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u000e0\nH\u0002\u00a2\u0006\u0002\u0010$J7\u0010%\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u000e0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u000e0\n2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0002J \u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J(\u0010'\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0007J!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010-J$\u0010'\u001a\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020\u00182\b\b\u0002\u0010)\u001a\u00020*H\u0007J+\u0010/\u001a\u0004\u0018\u00010\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0007\u00a2\u0006\u0002\u00102\u00a8\u00066"}, d2={"Lcom/intellij/util/diff/Diff;", "", "<init>", "()V", "buildChanges", "Lcom/intellij/util/diff/Diff$Change;", "before", "", "after", "splitLines", "", "", "s", "(Ljava/lang/CharSequence;)[Ljava/lang/String;", "T", "objects1", "objects2", "([Ljava/lang/Object;[Ljava/lang/Object;)Lcom/intellij/util/diff/Diff$Change;", "array1", "", "array2", "doBuildChangesFast", "Lcom/intellij/util/diff/Diff$Ref;", "length1", "", "length2", "startShift", "endCut", "doBuildChanges", "ints1", "ints2", "builder", "Lcom/intellij/util/diff/Diff$ChangeBuilder;", "getStartShift", "o1", "o2", "([Ljava/lang/Object;[Ljava/lang/Object;)I", "getEndCut", "([Ljava/lang/Object;[Ljava/lang/Object;I)I", "translateLine", "line", "approximate", "", "trim", "lines", "([Ljava/lang/String;)[Ljava/lang/String;", "change", "linesDiff", "lines1", "lines2", "([Ljava/lang/CharSequence;[Ljava/lang/CharSequence;)Ljava/lang/CharSequence;", "Ref", "Change", "ChangeBuilder", "intellij.platform.util.diff"})
@SourceDebugExtension(value={"SMAP\nDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Diff.kt\ncom/intellij/util/diff/Diff\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,290:1\n106#2:291\n78#2,22:292\n*S KotlinDebug\n*F\n+ 1 Diff.kt\ncom/intellij/util/diff/Diff\n*L\n161#1:291\n161#1:292,22\n*E\n"})
public final class Diff {
    @NotNull
    public static final Diff INSTANCE = new Diff();

    private Diff() {
    }

    @JvmStatic
    @Nullable
    public static final Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return Diff.buildChanges(Diff.splitLines(before), Diff.splitLines(after));
    }

    @JvmStatic
    @NotNull
    public static final String[] splitLines(@NotNull CharSequence s) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (s.length() == 0) {
            String[] stringArray2 = new String[]{""};
            stringArray = stringArray2;
        } else {
            stringArray = LineTokenizer.Companion.tokenize(s, false, false);
        }
        return stringArray;
    }

    @JvmStatic
    @Nullable
    public static final <T> Change buildChanges(@NotNull T[] objects1, @NotNull T[] objects2) throws FilesTooBigForDiffException {
        Intrinsics.checkNotNullParameter(objects1, (String)"objects1");
        Intrinsics.checkNotNullParameter(objects2, (String)"objects2");
        int startShift = INSTANCE.getStartShift(objects1, objects2);
        int endCut = INSTANCE.getEndCut(objects1, objects2, startShift);
        Ref<Change> changeRef = INSTANCE.doBuildChangesFast(objects1.length, objects2.length, startShift, endCut);
        if (changeRef != null) {
            return changeRef.getValue();
        }
        int trimmedLength = objects1.length + objects2.length - 2 * startShift - 2 * endCut;
        Enumerator<T> enumerator = new Enumerator<T>(trimmedLength);
        int[] ints1 = enumerator.enumerate(objects1, startShift, endCut);
        int[] ints2 = enumerator.enumerate(objects2, startShift, endCut);
        return INSTANCE.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    @JvmStatic
    @Nullable
    public static final Change buildChanges(@NotNull int[] array1, @NotNull int[] array2) throws FilesTooBigForDiffException {
        Ref<Change> changeRef;
        Intrinsics.checkNotNullParameter((Object)array1, (String)"array1");
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array2");
        int startShift = INSTANCE.getStartShift(array1, array2);
        int endCut = INSTANCE.getEndCut(array1, array2, startShift);
        Ref<Change> ref = changeRef = INSTANCE.doBuildChangesFast(array1.length, array2.length, startShift, endCut);
        if (ref != null) {
            return ref.getValue();
        }
        boolean copyArray = startShift != 0 || endCut != 0;
        int[] ints1 = copyArray ? ArraysKt.copyOfRange((int[])array1, (int)startShift, (int)(array1.length - endCut)) : array1;
        int[] ints2 = copyArray ? ArraysKt.copyOfRange((int[])array2, (int)startShift, (int)(array2.length - endCut)) : array2;
        return INSTANCE.doBuildChanges(ints1, ints2, new ChangeBuilder(startShift));
    }

    private final Ref<Change> doBuildChangesFast(int length1, int length2, int startShift, int endCut) {
        int trimmedLength1 = length1 - startShift - endCut;
        int trimmedLength2 = length2 - startShift - endCut;
        if (trimmedLength1 != 0 && trimmedLength2 != 0) {
            return null;
        }
        Change change = trimmedLength1 != 0 || trimmedLength2 != 0 ? new Change(startShift, startShift, trimmedLength1, trimmedLength2, null) : null;
        return new Ref<Change>(change);
    }

    private final Change doBuildChanges(int[] ints1, int[] ints2, ChangeBuilder builder) throws FilesTooBigForDiffException {
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        if (discarded[0].length == 0 && discarded[1].length == 0) {
            builder.addChange(ints1.length, ints2.length);
            return builder.getFirstChange();
        }
        BitSet[] changes = null;
        try {
            MyersLCS intLCS = new MyersLCS(discarded[0], discarded[1]);
            intLCS.executeWithThreshold();
            changes = intLCS.getChanges();
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            PatienceIntLCS patienceIntLCS = new PatienceIntLCS(discarded[0], discarded[1]);
            patienceIntLCS.execute(true);
            changes = patienceIntLCS.getChanges();
        }
        reindexer.reindex(changes, builder);
        return builder.getFirstChange();
    }

    private final <T> int getStartShift(T[] o1, T[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && Intrinsics.areEqual(o1[i], o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private final <T> int getEndCut(T[] o1, T[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && Intrinsics.areEqual(o1[o1.length - i - 1], o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    private final int getStartShift(int[] o1, int[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i] == o2[i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private final int getEndCut(int[] o1, int[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1] == o2[o2.length - i - 1]; ++i) {
            ++idx;
        }
        return idx;
    }

    @JvmStatic
    public static final int translateLine(@NotNull CharSequence before, @NotNull CharSequence after, int line, boolean approximate) throws FilesTooBigForDiffException {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        String[] strings1 = LineTokenizer.Companion.tokenize$default((LineTokenizer.Companion)LineTokenizer.Companion, (CharSequence)before, (boolean)false, (boolean)false, (int)4, null);
        String[] strings2 = LineTokenizer.Companion.tokenize$default((LineTokenizer.Companion)LineTokenizer.Companion, (CharSequence)after, (boolean)false, (boolean)false, (int)4, null);
        if (approximate) {
            strings1 = INSTANCE.trim(strings1);
            strings2 = INSTANCE.trim(strings2);
        }
        Change change = Diff.buildChanges(strings1, strings2);
        return Diff.translateLine(change, line, approximate);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] trim(String[] lines) {
        int n = lines.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            void $this$trim$iv;
            int n2 = i;
            String string2 = lines[n2];
            int n3 = n2;
            String[] stringArray2 = stringArray;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            stringArray2[n3] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        return stringArray;
    }

    @JvmStatic
    @JvmOverloads
    public static final int translateLine(@Nullable Change change, int line, boolean approximate) {
        int result = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result += currentChange.inserted - currentChange.deleted;
            } else {
                return approximate ? currentChange.line1 : -1;
            }
            currentChange = currentChange.link;
        }
        return result;
    }

    public static /* synthetic */ int translateLine$default(Change change, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return Diff.translateLine(change, n, bl);
    }

    @JvmStatic
    @Nullable
    public static final CharSequence linesDiff(@NotNull CharSequence[] lines1, @NotNull CharSequence[] lines2) throws FilesTooBigForDiffException {
        Intrinsics.checkNotNullParameter((Object)lines1, (String)"lines1");
        Intrinsics.checkNotNullParameter((Object)lines2, (String)"lines2");
        Change ch = Diff.buildChanges(lines1, lines2);
        if (ch == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (ch != null) {
            int i;
            if (((CharSequence)sb).length() > 0) {
                sb.append("====================").append("\n");
            }
            int n = ch.line0 + ch.deleted;
            for (i = ch.line0; i < n; ++i) {
                sb.append('-').append(lines1[i]).append('\n');
            }
            n = ch.line1 + ch.inserted;
            for (i = ch.line1; i < n; ++i) {
                sb.append('+').append(lines2[i]).append('\n');
            }
            ch = ch.link;
        }
        return sb.toString();
    }

    @JvmStatic
    @JvmOverloads
    public static final int translateLine(@Nullable Change change, int line) {
        return Diff.translateLine$default(change, line, false, 4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0096\u0080\u0004J\u0018\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u000ej\b\u0012\u0004\u0012\u00020\u0000`\u000fH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/diff/Diff$Change;", "", "line0", "", "line1", "deleted", "inserted", "link", "<init>", "(IIIILcom/intellij/util/diff/Diff$Change;)V", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "toList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "intellij.platform.util.diff"})
    public static class Change {
        @JvmField
        public final int line0;
        @JvmField
        public final int line1;
        @JvmField
        public final int deleted;
        @JvmField
        public final int inserted;
        @JvmField
        @Nullable
        public Change link;

        public Change(int line0, int line1, int deleted, int inserted, @Nullable Change link) {
            this.line0 = line0;
            this.line1 = line1;
            this.deleted = deleted;
            this.inserted = inserted;
            this.link = link;
        }

        @NotNull
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + ']';
        }

        @NotNull
        public ArrayList<Change> toList() {
            ArrayList<Change> result = new ArrayList<Change>();
            Change current = this;
            while (current != null) {
                result.add(current);
                current = current.link;
            }
            return result;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/diff/Diff$ChangeBuilder;", "Lcom/intellij/util/diff/LCSBuilder;", "startShift", "", "<init>", "(I)V", "myIndex1", "myIndex2", "_firstChange", "Lcom/intellij/util/diff/Diff$Change;", "firstChange", "getFirstChange", "()Lcom/intellij/util/diff/Diff$Change;", "myLastChange", "addChange", "", "first", "second", "skip", "addEqual", "length", "intellij.platform.util.diff"})
    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1;
        private int myIndex2;
        @Nullable
        private Change _firstChange;
        @Nullable
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Nullable
        public Change getFirstChange() {
            return this._firstChange;
        }

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            Change change2 = this.myLastChange;
            if (change2 != null) {
                Change it = change2;
                boolean bl = false;
                it.link = change;
            } else {
                ChangeBuilder $this$addChange_u24lambda_u241 = this;
                boolean bl = false;
                $this$addChange_u24lambda_u241._firstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private final void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/diff/Diff$Ref;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "copy", "(Ljava/lang/Object;)Lcom/intellij/util/diff/Diff$Ref;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.util.diff"})
    private static final class Ref<T> {
        @Nullable
        private final T value;

        public Ref(@Nullable T value) {
            this.value = value;
        }

        @Nullable
        public final T getValue() {
            return this.value;
        }

        @Nullable
        public final T component1() {
            return this.value;
        }

        @NotNull
        public final Ref<T> copy(@Nullable T value) {
            return new Ref<T>(value);
        }

        public static /* synthetic */ Ref copy$default(Ref ref, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = ref.value;
            }
            return ref.copy(object);
        }

        @NotNull
        public String toString() {
            return "Ref(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)other;
            return Intrinsics.areEqual(this.value, ref.value);
        }
    }
}

