/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.impl.ide;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.run.actions.GridEditAction;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/grid/impl/ide/CsvDataModeEditUsageListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "beforeActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isActionInCsvFileTableMode", "", "intellij.grid.impl.ide"})
public final class CsvDataModeEditUsageListener
implements AnActionListener {
    public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isActionInCsvFileTableMode(event) && (action instanceof GridEditAction || action instanceof EditorAction)) {
            Project project = event.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            DataGrid dataGrid = (DataGrid)event.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (dataGrid == null) {
                return;
            }
            DataGrid grid = dataGrid;
            GridDataHookUp gridDataHookUp = grid.getDataHookup();
            CsvDocumentDataHookUp csvDocumentDataHookUp = gridDataHookUp instanceof CsvDocumentDataHookUp ? (CsvDocumentDataHookUp)gridDataHookUp : null;
            if (csvDocumentDataHookUp == null) {
                return;
            }
            CsvDocumentDataHookUp hookup = csvDocumentDataHookUp;
            Document document = hookup.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            FileTypeUsageCounterCollector.triggerEdit((Project)project2, (VirtualFile)file);
        }
    }

    private final boolean isActionInCsvFileTableMode(AnActionEvent event) {
        DataGrid dataGrid = (DataGrid)event.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        return grid.getDataHookup() instanceof CsvDocumentDataHookUp;
    }
}

