/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LearningDsl;
import training.dsl.LearningDslBase;
import training.dsl.LessonSample;
import training.dsl.LessonSamplePosition;
import training.dsl.PreviousTaskInfo;
import training.dsl.impl.LessonExecutor;
import training.learn.ActionsRecorder;

@LearningDsl
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\u000eJ \u00100\u001a\u00020\b2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u00104\u001a\u00020\b2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0018\u00105\u001a\u00020\b2\u0006\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u00020\u0018J&\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020;J\u0018\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u00109\u001a\u00020\u0018J\u0016\u0010?\u001a\u00020\b2\u0006\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020;J\u000e\u0010?\u001a\u00020\b2\u0006\u0010D\u001a\u00020;J\u000e\u0010?\u001a\u00020\b2\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020\bJ\u0010\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020AH\u0002J\u0010\u0010J\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010K\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u0010E\u001a\u00020FH\u0002J\u0017\u0010L\u001a\u0004\u0018\u00010;2\u0006\u0010@\u001a\u00020AH\u0002\u00a2\u0006\u0002\u0010MR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0013\u0010%\u001a\u0004\u0018\u00010&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006N"}, d2={"Ltraining/dsl/TaskRuntimeContext;", "Ltraining/dsl/LearningDslBase;", "lessonExecutor", "Ltraining/dsl/impl/LessonExecutor;", "actionsRecorder", "Ltraining/learn/ActionsRecorder;", "restorePreviousTaskCallback", "Lkotlin/Function0;", "", "previousGetter", "Ltraining/dsl/PreviousTaskInfo;", "<init>", "(Ltraining/dsl/impl/LessonExecutor;Ltraining/learn/ActionsRecorder;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "base", "(Ltraining/dsl/TaskRuntimeContext;)V", "getActionsRecorder$intellij_featuresTrainer", "()Ltraining/learn/ActionsRecorder;", "getRestorePreviousTaskCallback", "()Lkotlin/jvm/functions/Function0;", "taskDisposable", "Lcom/intellij/openapi/Disposable;", "getTaskDisposable", "()Lcom/intellij/openapi/Disposable;", "disposed", "", "getDisposed", "()Z", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "lessonDisposable", "getLessonDisposable", "focusOwner", "Ljava/awt/Component;", "getFocusOwner", "()Ljava/awt/Component;", "previous", "getPrevious", "()Ltraining/dsl/PreviousTaskInfo;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "taskInvokeLater", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "runnable", "invokeInBackground", "setSample", "sample", "Ltraining/dsl/LessonSample;", "setCaret", "select", "startLine", "", "startColumn", "endLine", "endColumn", "caret", "text", "", "line", "column", "offset", "position", "Ltraining/dsl/LessonSamplePosition;", "requestEditorFocus", "setDocumentCode", "code", "doUndoableAction", "updateGutter", "getStartOffsetForText", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nTaskRuntimeContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRuntimeContext.kt\ntraining/dsl/TaskRuntimeContext\n+ 2 LessonExecutor.kt\ntraining/dsl/impl/LessonExecutor\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n195#2,11:158\n184#2,9:169\n1#3:178\n*S KotlinDebug\n*F\n+ 1 TaskRuntimeContext.kt\ntraining/dsl/TaskRuntimeContext\n*L\n53#1:158,11\n57#1:169,9\n*E\n"})
public class TaskRuntimeContext
implements LearningDslBase {
    @NotNull
    private final LessonExecutor lessonExecutor;
    @NotNull
    private final ActionsRecorder actionsRecorder;
    @NotNull
    private final Function0<Unit> restorePreviousTaskCallback;
    @NotNull
    private final Function0<PreviousTaskInfo> previousGetter;
    @NotNull
    private final Disposable taskDisposable;

    public TaskRuntimeContext(@NotNull LessonExecutor lessonExecutor, @NotNull ActionsRecorder actionsRecorder, @NotNull Function0<Unit> restorePreviousTaskCallback, @NotNull Function0<? extends PreviousTaskInfo> previousGetter) {
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        Intrinsics.checkNotNullParameter((Object)actionsRecorder, (String)"actionsRecorder");
        Intrinsics.checkNotNullParameter(restorePreviousTaskCallback, (String)"restorePreviousTaskCallback");
        Intrinsics.checkNotNullParameter(previousGetter, (String)"previousGetter");
        this.lessonExecutor = lessonExecutor;
        this.actionsRecorder = actionsRecorder;
        this.restorePreviousTaskCallback = restorePreviousTaskCallback;
        this.previousGetter = previousGetter;
        this.taskDisposable = this.actionsRecorder;
    }

    @NotNull
    public final ActionsRecorder getActionsRecorder$intellij_featuresTrainer() {
        return this.actionsRecorder;
    }

    @NotNull
    public final Function0<Unit> getRestorePreviousTaskCallback() {
        return this.restorePreviousTaskCallback;
    }

    public TaskRuntimeContext(@NotNull TaskRuntimeContext base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this(base.lessonExecutor, base.actionsRecorder, base.restorePreviousTaskCallback, base.previousGetter);
    }

    @NotNull
    public final Disposable getTaskDisposable() {
        return this.taskDisposable;
    }

    public final boolean getDisposed() {
        return this.actionsRecorder.getDisposed();
    }

    @NotNull
    public final Editor getEditor() {
        return this.lessonExecutor.getEditor();
    }

    @NotNull
    public final Project getProject() {
        return this.lessonExecutor.getProject();
    }

    @NotNull
    public final Disposable getLessonDisposable() {
        return this.lessonExecutor;
    }

    @Nullable
    public final Component getFocusOwner() {
        return IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner();
    }

    @NotNull
    public final PreviousTaskInfo getPrevious() {
        return (PreviousTaskInfo)this.previousGetter.invoke();
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        if (virtualFile == null) {
            throw new IllegalStateException(("No virtual file for " + this.getEditor().getDocument()).toString());
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    public final void taskInvokeLater(@Nullable ModalityState modalityState, @NotNull Function0<Unit> runnable) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        LessonExecutor lessonExecutor = this.lessonExecutor;
        ModalityState modalityState$iv = modalityState;
        boolean $i$f$taskInvokeLater = false;
        ActionsKt.invokeLater((ModalityState)modalityState$iv, (Function0)((Function0)new Function0<Unit>((LessonExecutor)this_$iv, runnable){
            final /* synthetic */ LessonExecutor this$0;
            final /* synthetic */ Function0<Unit> $runnable;
            {
                this.this$0 = $receiver;
                this.$runnable = $runnable;
            }

            public final void invoke() {
                try {
                    if (!this.this$0.getHasBeenStopped()) {
                        this.$runnable.invoke();
                    }
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        }));
    }

    public static /* synthetic */ void taskInvokeLater$default(TaskRuntimeContext taskRuntimeContext, ModalityState modalityState, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: taskInvokeLater");
        }
        if ((n & 1) != 0) {
            modalityState = null;
        }
        taskRuntimeContext.taskInvokeLater(modalityState, (Function0<Unit>)function0);
    }

    public final void invokeInBackground(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        LessonExecutor this_$iv = this.lessonExecutor;
        boolean $i$f$invokeInBackground = false;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(runnable, this_$iv){
            final /* synthetic */ Function0<Unit> $runnable;
            final /* synthetic */ LessonExecutor this$0;
            {
                this.$runnable = $runnable;
                this.this$0 = $receiver;
            }

            public final void run() {
                try {
                    this.$runnable.invoke();
                }
                catch (Throwable e) {
                    LessonExecutor $this$thisLogger$iv = this.this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LessonExecutor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error(this.this$0.getLessonInfoString(), e);
                }
            }
        });
    }

    public final void setSample(@NotNull LessonSample sample, boolean setCaret) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.taskInvokeLater(ModalityState.nonModal(), (Function0<Unit>)((Function0)() -> TaskRuntimeContext.setSample$lambda$0(this, sample, setCaret)));
    }

    public static /* synthetic */ void setSample$default(TaskRuntimeContext taskRuntimeContext, LessonSample lessonSample, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setSample");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        taskRuntimeContext.setSample(lessonSample, bl);
    }

    public final void select(int startLine, int startColumn, int endLine, int endColumn) {
        this.lessonExecutor.getLesson().beforeCaretApplied(this.getEditor());
        LogicalPosition blockStart = new LogicalPosition(startLine - 1, startColumn - 1);
        LogicalPosition blockEnd = new LogicalPosition(endLine - 1, endColumn - 1);
        int startPosition = this.getEditor().logicalPositionToOffset(blockStart);
        int endPosition = this.getEditor().logicalPositionToOffset(blockEnd);
        this.getEditor().getCaretModel().moveToOffset(startPosition);
        this.getEditor().getSelectionModel().setSelection(startPosition, endPosition);
        this.requestEditorFocus();
    }

    public final void caret(@NotNull String text, boolean select) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.lessonExecutor.getLesson().beforeCaretApplied(this.getEditor());
        Integer n = this.getStartOffsetForText(text);
        if (n == null) {
            return;
        }
        int start = n;
        this.getEditor().getCaretModel().moveToOffset(start);
        if (select) {
            this.getEditor().getSelectionModel().setSelection(start, start + text.length());
        }
        this.requestEditorFocus();
    }

    public static /* synthetic */ void caret$default(TaskRuntimeContext taskRuntimeContext, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: caret");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        taskRuntimeContext.caret(string, bl);
    }

    public final void caret(int line, int column) {
        this.lessonExecutor.getLesson().beforeCaretApplied(this.getEditor());
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), line - 1, column - 1).navigateIn(this.getEditor());
        this.requestEditorFocus();
    }

    public final void caret(int offset) {
        this.lessonExecutor.getLesson().beforeCaretApplied(this.getEditor());
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), offset).navigateIn(this.getEditor());
        this.requestEditorFocus();
    }

    public final void caret(@NotNull LessonSamplePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.setCaret(position);
    }

    public final void requestEditorFocus() {
        FocusManagerImpl.getInstance((Project)this.getProject()).requestFocus((Component)this.getEditor().getContentComponent(), false);
    }

    private final void setDocumentCode(String code) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        DocumentUtil.writeInRunUndoTransparentAction(() -> TaskRuntimeContext.setDocumentCode$lambda$0(document2, this, code));
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document2);
        this.doUndoableAction(this.getProject());
        this.updateGutter(this.getEditor());
    }

    private final void doUndoableAction(Project project) {
        CommandProcessor.getInstance().executeCommand(project, () -> TaskRuntimeContext.doUndoableAction$lambda$0(project), null, null);
    }

    private final void updateGutter(Editor editor) {
        EditorGutter editorGutter = editor.getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editorGutter;
        editorGutterComponentEx.revalidateMarkup();
    }

    private final void setCaret(LessonSamplePosition position) {
        this.lessonExecutor.getLesson().beforeCaretApplied(this.getEditor());
        Pair<Integer, Integer> pair = position.getSelection();
        if (pair != null) {
            Pair<Integer, Integer> it = pair;
            boolean bl = false;
            this.getEditor().getSelectionModel().setSelection(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
        this.getEditor().getCaretModel().moveToOffset(position.getStartOffset());
        this.requestEditorFocus();
    }

    private final Integer getStartOffsetForText(String text) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        int indexOf = StringsKt.indexOf$default((CharSequence)charSequence, (String)text, (int)0, (boolean)false, (int)6, null);
        if (indexOf != -1) {
            return indexOf;
        }
        return null;
    }

    private static final Unit setSample$lambda$0(TaskRuntimeContext this$0, LessonSample $sample, boolean $setCaret) {
        this$0.lessonExecutor.getLesson().beforeCaretApplied(this$0.getEditor());
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this$0.getEditor());
        if (templateState != null) {
            templateState.gotoEnd();
        }
        Editor editor = this$0.getEditor();
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx != null) {
            editorEx.setViewer(false);
        }
        this$0.getEditor().getCaretModel().removeSecondaryCarets();
        this$0.getEditor().getSelectionModel().removeSelection(true);
        this$0.setDocumentCode($sample.getText());
        if ($setCaret) {
            this$0.setCaret($sample.getPosition(0));
        }
        return Unit.INSTANCE;
    }

    private static final void setDocumentCode$lambda$0(Document $document, TaskRuntimeContext this$0, String $code) {
        DocumentReference documentReference = DocumentReferenceManager.getInstance().create($document);
        Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"create(...)");
        DocumentReference documentReference2 = documentReference;
        UndoManager.getInstance((Project)this$0.getProject()).nonundoableActionPerformed(documentReference2, false);
        $document.replaceString(0, $document.getTextLength(), (CharSequence)$code);
    }

    private static final void doUndoableAction$lambda$0(Project $project) {
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
            }

            public void redo() {
            }
        });
    }
}

