/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.parameterInfo.ParameterFlag;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.DeleteParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.parameterInfo.ParameterHints;
import com.jetbrains.python.codeInsight.parameterInfo.PyParameterInfoUtils;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.types.PyCallableType;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyParameterInfoHandler
implements ParameterInfoHandler<PyArgumentList, PyParameterInfoUtils.CallInfo> {
    private static final int MY_PARAM_LENGTH_LIMIT = 50;
    private static final int MAX_PARAMETER_INFO_TO_SHOW = 20;
    private boolean hideOverloads = true;
    private boolean isDisposed = false;
    private int myRealOffset = -1;
    private int numOfSignatures = 0;
    private CreateParameterInfoContext myCreateContext;
    private static final EnumMap<ParameterFlag, ParameterInfoUIContextEx.Flag> PARAM_FLAG_TO_UI_FLAG = new EnumMap<ParameterFlag, ParameterInfoUIContextEx.Flag>(Map.of(ParameterFlag.HIGHLIGHT, ParameterInfoUIContextEx.Flag.HIGHLIGHT, ParameterFlag.DISABLE, ParameterInfoUIContextEx.Flag.DISABLE, ParameterFlag.STRIKEOUT, ParameterInfoUIContextEx.Flag.STRIKEOUT));

    @Nullable
    public PyArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int offset;
        PsiFile file;
        PyArgumentList argumentList;
        List parameterInfos;
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((parameterInfos = PyParameterInfoUtils.findCallCandidates((PyArgumentList)(argumentList = PyParameterInfoUtils.findArgumentList((PsiFile)(file = context.getFile()), (int)(offset = context.getOffset()), (int)-1)))) != null) {
            if (parameterInfos.size() > 20) {
                parameterInfos = parameterInfos.subList(0, 20);
            }
            ArrayList<PyParameterInfoUtils.CallInfo> infos = new ArrayList<PyParameterInfoUtils.CallInfo>();
            boolean isFirst = true;
            for (Pair paramInfo : parameterInfos) {
                infos.add(new PyParameterInfoUtils.CallInfo((PyCallExpression)paramInfo.first, (PyCallableType)paramInfo.second, isFirst || this.hideOverloads));
                isFirst = false;
            }
            Object[] infoArr = infos.toArray();
            PyParameterInfoHandler.setDisplayAllOverloadsState(infoArr, this.hideOverloads);
            context.setItemsToShow(infoArr);
            this.numOfSignatures = PyParameterInfoHandler.getNumOfSignatures(infoArr);
            return argumentList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull PyArgumentList element2, @NotNull CreateParameterInfoContext context) {
        if (element2 == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        this.myCreateContext = context;
        this.isDisposed = false;
        int actualOffset = PyParameterInfoHandler.getRealCaretOffset(context.getEditor());
        if (actualOffset == this.myRealOffset) {
            this.hideOverloads = !this.hideOverloads;
        }
        context.showHint((PsiElement)element2, element2.getTextOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public PyArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        this.myRealOffset = PyParameterInfoHandler.getRealCaretOffset(context.getEditor());
        return PyParameterInfoUtils.findArgumentList((PsiFile)context.getFile(), (int)context.getOffset(), (int)context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PyArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int allegedCursorOffset = context.getOffset();
        if (!argumentList.getTextRange().contains(allegedCursorOffset) && argumentList.getText().endsWith(")")) {
            context.removeHint();
            return;
        }
        PsiFile file = context.getFile();
        int offset = PyParameterInfoUtils.findCurrentParameter((PyArgumentList)argumentList, (int)allegedCursorOffset, (PsiFile)file);
        PyParameterInfoHandler.setDisplayAllOverloadsState(context.getObjectsToView(), this.hideOverloads);
        context.setCurrentParameter(offset);
    }

    public void updateUI(@NotNull PyParameterInfoUtils.CallInfo description, @NotNull ParameterInfoUIContext context) {
        if (description == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        context.setUIComponentVisible(description.isVisible());
        int currentParamOffset = context.getCurrentParameterIndex();
        ParameterHints parameterHints = PyParameterInfoUtils.buildParameterHints((Pair)description.getCallandCalleePair(), (int)currentParamOffset);
        if (parameterHints == null) {
            return;
        }
        boolean showAllHints = Registry.is((String)"python.parameter.info.show.all.hints");
        List parameterDescriptions = parameterHints.getParameterDescriptors();
        String[] hintsToShow = new String[parameterDescriptions.size()];
        EnumSet[] flags = new EnumSet[parameterHints.getFlags().size()];
        for (int i = 0; i < flags.length; ++i) {
            EnumSet curFlags = (EnumSet)parameterHints.getFlags().get(i);
            PyParameterInfoUtils.ParameterDescription representation = (PyParameterInfoUtils.ParameterDescription)parameterDescriptions.get(i);
            hintsToShow[i] = PyParameterInfoHandler.getRepresentationToShow(representation, curFlags.contains(ParameterFlag.HIGHLIGHT), showAllHints);
            flags[i] = (EnumSet)StreamEx.of((Collection)((Collection)parameterHints.getFlags().get(i))).map(PARAM_FLAG_TO_UI_FLAG::get).collect(MoreCollectors.toEnumSet(ParameterInfoUIContextEx.Flag.class));
        }
        if (context instanceof ParameterInfoUIContextEx) {
            if (parameterDescriptions.isEmpty()) {
                hintsToShow = new String[]{PyParameterInfoHandler.getNoParamsMsg()};
                flags = new EnumSet[]{EnumSet.of(ParameterInfoUIContextEx.Flag.DISABLE)};
            }
            ((ParameterInfoUIContextEx)context).setupUIComponentPresentation(hintsToShow, flags, context.getDefaultParameterColor());
        } else {
            StringBuilder signatureBuilder = new StringBuilder();
            if (hintsToShow.length == 0) {
                signatureBuilder.append(PyParameterInfoHandler.getNoParamsMsg());
            } else {
                for (String s : hintsToShow) {
                    signatureBuilder.append(s);
                }
            }
            context.setupUIComponentPresentation(signatureBuilder.toString(), -1, 0, false, false, false, context.getDefaultParameterColor());
        }
    }

    public JComponent createBottomComponent() {
        int numOfOverloads = this.numOfSignatures - 1;
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)5));
        panel2.setOpaque(false);
        String showMoreShortCut = KeymapUtil.getFirstKeyboardShortcutText((String)"ParameterInfo");
        JLabel shortCut = new JLabel(showMoreShortCut);
        ActionLink actionLink = new ActionLink(this.getActionLinkText(numOfOverloads), event -> {
            if (this.myCreateContext != null) {
                ReadAction.nonBlocking(() -> this.findElementForParameterInfo(this.myCreateContext)).finishOnUiThread(ModalityState.defaultModalityState(), argumentList -> {
                    if (argumentList != null) {
                        this.showParameterInfo((PyArgumentList)argumentList, this.myCreateContext);
                    }
                }).coalesceBy(new Object[]{this.myCreateContext, this}).expireWhen(() -> this.isDisposed).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        });
        actionLink.setBorder((Border)JBUI.Borders.emptyLeft((int)(ExperimentalUI.isNewUI() ? 19 : 3)));
        panel2.add((Component)actionLink);
        panel2.add(shortCut);
        if (numOfOverloads < 1) {
            panel2.setVisible(false);
        }
        return panel2;
    }

    public void updateBottomComponent(@NotNull JComponent component) {
        Component comp;
        int numOfOverloads;
        if (component == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if ((numOfOverloads = this.numOfSignatures - 1) >= 1 && (comp = component.getComponent(0)) instanceof ActionLink) {
            ActionLink actionLink = (ActionLink)comp;
            actionLink.setText(this.getActionLinkText(numOfOverloads));
            component.setVisible(true);
        }
    }

    @Nls
    private String getActionLinkText(int numOfOverloads) {
        return this.hideOverloads ? PyBundle.message("param.info.show.more.n.overloads", numOfOverloads, numOfOverloads > 1 ? 0 : 1) : PyBundle.message("param.info.show.less", new Object[0]);
    }

    private static int getNumOfSignatures(Object[] objectsToShow) {
        if (objectsToShow != null) {
            return objectsToShow.length;
        }
        return 0;
    }

    public void dispose(@NotNull DeleteParameterInfoContext context) {
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(9);
        }
        this.resetDisplayState();
        this.myCreateContext = null;
        this.isDisposed = true;
        super.dispose(context);
    }

    private void resetDisplayState() {
        this.myRealOffset = -1;
        this.numOfSignatures = 0;
        this.hideOverloads = true;
    }

    private static String getRepresentationToShow(PyParameterInfoUtils.ParameterDescription description, boolean isHighlighted, boolean showHints) {
        String annotation;
        String fullRepresentation = description.getFullRepresentation(isHighlighted || showHints);
        if (fullRepresentation.length() > 50 && !isHighlighted && !(annotation = description.getAnnotation()).isEmpty() && annotation.length() < fullRepresentation.length()) {
            return annotation;
        }
        return fullRepresentation;
    }

    private static String getNoParamsMsg() {
        return CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
    }

    private static int getRealCaretOffset(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return editor2.getCaretModel().getCurrentCaret().getOffset();
    }

    private static void setDisplayAllOverloadsState(Object[] hintsToShow, boolean hideOverloads) {
        if (hintsToShow != null && hintsToShow.length != 0) {
            ((PyParameterInfoUtils.CallInfo)hintsToShow[0]).setVisible(true);
            for (int i = 1; i < hintsToShow.length; ++i) {
                ((PyParameterInfoUtils.CallInfo)hintsToShow[i]).setVisible(!hideOverloads);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PyParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBottomComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "dispose";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRealCaretOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

