/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.EditorTextField;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.DataViewerCommandSource;
import com.jetbrains.python.debugger.containerview.PyDataViewerModel;
import com.jetbrains.python.debugger.statistics.PyDataViewerCollector;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0002JKB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010&\u001a\u00020'2\u000b\u0010(\u001a\u00070\r\u00a2\u0006\u0002\b)2\u0006\u0010*\u001a\u00020\u0006H$J\b\u0010+\u001a\u00020'H$J(\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020\u0006H$J \u00103\u001a\u0002042\n\b\u0002\u0010/\u001a\u0004\u0018\u0001002\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H&J\b\u00105\u001a\u00020'H&J\u0010\u00106\u001a\u00020'2\u0006\u00107\u001a\u000208H\u0004J\u000e\u00109\u001a\u00020'2\u0006\u00107\u001a\u000208J$\u00109\u001a\u00020'2\b\u0010:\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u00062\n\b\u0002\u00107\u001a\u0004\u0018\u000108J\"\u00109\u001a\u00020'2\u0006\u0010;\u001a\u0002002\u0006\u0010*\u001a\u00020\u00062\n\b\u0002\u00107\u001a\u0004\u0018\u000108J\u0018\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=2\u0006\u0010;\u001a\u000200H\u0002J\u0018\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020A2\u0006\u00101\u001a\u000202H\u0004J\"\u0010B\u001a\u00020'2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020\u0006H\u0004J!\u0010C\u001a\u0004\u0018\u0001002\r\u0010D\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\bE2\u0006\u0010*\u001a\u00020\u0006H\u0004J\u000e\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020#J\"\u0010H\u001a\u00070\r\u00a2\u0006\u0002\bI2\u000b\u0010(\u001a\u00070\r\u00a2\u0006\u0002\bE2\u0006\u0010*\u001a\u00020\u0006H\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000bR\u0018\u0010\f\u001a\u00020\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\rX\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u0018\u0010\u0015\u001a\u00020\u0006X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u0001X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006L"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable$Default;", "dataViewerModel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;", "isPanelFromFactory", "", "<init>", "(Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;Z)V", "getDataViewerModel", "()Lcom/jetbrains/python/debugger/containerview/PyDataViewerModel;", "()Z", "formatValueFromUI", "", "getFormatValueFromUI", "()Ljava/lang/String;", "setFormatValueFromUI", "(Ljava/lang/String;)V", "slicingValueFromUI", "getSlicingValueFromUI", "setSlicingValueFromUI", "isColoredValueFromUI", "setColoredValueFromUI", "(Z)V", "slicingTextField", "Lcom/intellij/ui/EditorTextField;", "getSlicingTextField", "()Lcom/intellij/ui/EditorTextField;", "topToolbar", "getTopToolbar", "()Ljavax/swing/JPanel;", "setTopToolbar", "(Ljavax/swing/JPanel;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel$OnNameChangedListener;", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "setError", "", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "modifier", "setupDataProvider", "updateUI", "chunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "originalDebugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "strategy", "Lcom/jetbrains/python/debugger/containerview/DataViewStrategy;", "createTable", "Ljavax/swing/JComponent;", "recreateTable", "onEnterPressed", "commandSource", "Lcom/jetbrains/python/debugger/containerview/DataViewerCommandSource;", "apply", "name", "debugValue", "getValueDimensions", "", "", "doStrategyInitExecution", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "updateTabNameSlicingFieldAndFormatField", "getDebugValue", "expression", "Lcom/intellij/openapi/util/NlsSafe;", "addNameChangedListener", "listener", "composeErrorMessage", "Lorg/jetbrains/annotations/Nls;", "OnNameChangedListener", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyDataViewerAbstractPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerAbstractPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n1#2:218\n1#2:233\n777#3:219\n873#3,2:220\n1642#3,10:222\n1915#3:232\n1916#3:234\n1652#3:235\n1123#4,3:236\n23#5:239\n23#5:240\n*S KotlinDebug\n*F\n+ 1 PyDataViewerAbstractPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel\n*L\n140#1:233\n139#1:219\n139#1:220,2\n140#1:222,10\n140#1:232\n140#1:234\n140#1:235\n141#1:236,3\n119#1:239\n125#1:240\n*E\n"})
public abstract class PyDataViewerAbstractPanel
extends JPanel
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PyDataViewerModel dataViewerModel;
    private final boolean isPanelFromFactory;
    @NotNull
    private final CopyOnWriteArrayList<OnNameChangedListener> listeners;
    @NotNull
    private static final String MODIFIED_VARIABLE_FORMAT = "%s*";

    public PyDataViewerAbstractPanel(@NotNull PyDataViewerModel dataViewerModel, boolean isPanelFromFactory) {
        Intrinsics.checkNotNullParameter((Object)dataViewerModel, (String)"dataViewerModel");
        super(new BorderLayout());
        this.dataViewerModel = dataViewerModel;
        this.isPanelFromFactory = isPanelFromFactory;
        this.listeners = new CopyOnWriteArrayList();
    }

    public /* synthetic */ PyDataViewerAbstractPanel(PyDataViewerModel pyDataViewerModel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(pyDataViewerModel, bl);
    }

    @NotNull
    public final PyDataViewerModel getDataViewerModel() {
        return this.dataViewerModel;
    }

    public final boolean isPanelFromFactory() {
        return this.isPanelFromFactory;
    }

    @NotNull
    public abstract String getFormatValueFromUI();

    public abstract void setFormatValueFromUI(@NotNull String var1);

    @NotNull
    protected abstract String getSlicingValueFromUI();

    protected abstract void setSlicingValueFromUI(@NotNull String var1);

    public abstract boolean isColoredValueFromUI();

    public abstract void setColoredValueFromUI(boolean var1);

    @NotNull
    public abstract EditorTextField getSlicingTextField();

    @Nullable
    public abstract JPanel getTopToolbar();

    public abstract void setTopToolbar(@Nullable JPanel var1);

    @NotNull
    protected final CopyOnWriteArrayList<OnNameChangedListener> getListeners() {
        return this.listeners;
    }

    protected abstract void setError(@NotNull String var1, boolean var2);

    protected abstract void setupDataProvider();

    protected abstract void updateUI(@NotNull ArrayChunk var1, @NotNull PyDebugValue var2, @NotNull DataViewStrategy var3, boolean var4);

    @NotNull
    public abstract JComponent createTable(@Nullable PyDebugValue var1, @Nullable ArrayChunk var2);

    public static /* synthetic */ JComponent createTable$default(PyDataViewerAbstractPanel pyDataViewerAbstractPanel, PyDebugValue pyDebugValue, ArrayChunk arrayChunk, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTable");
        }
        if ((n & 1) != 0) {
            pyDebugValue = null;
        }
        if ((n & 2) != 0) {
            arrayChunk = null;
        }
        return pyDataViewerAbstractPanel.createTable(pyDebugValue, arrayChunk);
    }

    public abstract void recreateTable();

    protected final void onEnterPressed(@NotNull DataViewerCommandSource commandSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandSource), (String)"commandSource");
        this.apply(commandSource);
    }

    public final void apply(@NotNull DataViewerCommandSource commandSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandSource), (String)"commandSource");
        this.dataViewerModel.setFormat(this.getFormatValueFromUI());
        this.dataViewerModel.setSlicing(this.getSlicingValueFromUI());
        this.dataViewerModel.setColored(this.isColoredValueFromUI());
        this.apply(this.dataViewerModel.getSlicing(), false, commandSource);
    }

    public final void apply(@Nullable String name2, boolean modifier, @Nullable DataViewerCommandSource commandSource) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerAbstractPanel.apply$lambda$0(this, name2, modifier, commandSource));
    }

    public static /* synthetic */ void apply$default(PyDataViewerAbstractPanel pyDataViewerAbstractPanel, String string, boolean bl, DataViewerCommandSource dataViewerCommandSource, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            dataViewerCommandSource = null;
        }
        pyDataViewerAbstractPanel.apply(string, bl, dataViewerCommandSource);
    }

    public final void apply(@NotNull PyDebugValue debugValue, boolean modifier, @Nullable DataViewerCommandSource commandSource) {
        String type2;
        DataViewStrategy strategy;
        int dimensionsSize;
        List<Integer> dimensions;
        Intrinsics.checkNotNullParameter((Object)debugValue, (String)"debugValue");
        List<Integer> list = dimensions = this.getValueDimensions(debugValue);
        int n = dimensionsSize = list != null ? list.size() : 0;
        if (!modifier) {
            Object object;
            Object object2;
            DataViewerCommandSource dataViewerCommandSource = commandSource;
            switch (dataViewerCommandSource == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dataViewerCommandSource.ordinal()]) {
                case 1: {
                    PyDataViewerCollector.INSTANCE.logDataSlicingApplied(this.isPanelFromFactory);
                    break;
                }
                case 2: {
                    PyDataViewerCollector.INSTANCE.logDataFormattingApplied(this.isPanelFromFactory);
                    break;
                }
                case 3: {
                    PyDataViewerCollector.INSTANCE.logDataReloadApplied(this.isPanelFromFactory);
                    break;
                }
            }
            PyDataViewerCollector.INSTANCE.logDataOpened(this.dataViewerModel.getProject(), debugValue.getType(), dimensionsSize, (object2 = dimensions) != null && (object2 = (Integer)CollectionsKt.getOrNull(object2, (int)0)) != null ? (Integer)object2 : 0, (object = dimensions) != null && (object = (Integer)CollectionsKt.getOrNull(object, (int)1)) != null ? (Integer)object : 0, this.isPanelFromFactory);
        }
        if ((strategy = DataViewStrategy.getStrategy(type2 = debugValue.getType())) == null) {
            Object[] objectArray = new Object[]{type2};
            String string = PyBundle.message("debugger.data.view.type.is.not.supported", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.setError(string, modifier);
            return;
        }
        String format = dimensionsSize > 2 ? "%" : this.getFormatValueFromUI();
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerAbstractPanel.apply$lambda$1(this, debugValue, strategy, format, type2, modifier));
    }

    public static /* synthetic */ void apply$default(PyDataViewerAbstractPanel pyDataViewerAbstractPanel, PyDebugValue pyDebugValue, boolean bl, DataViewerCommandSource dataViewerCommandSource, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: apply");
        }
        if ((n & 4) != 0) {
            dataViewerCommandSource = null;
        }
        pyDataViewerAbstractPanel.apply(pyDebugValue, bl, dataViewerCommandSource);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getValueDimensions(PyDebugValue debugValue) {
        void $this$count$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Object object2;
        block7: {
            block6: {
                object2 = debugValue.getShape();
                if (object2 == null) break block6;
                object = object2;
                String it = object;
                boolean bl = false;
                object2 = StringsKt.startsWith$default((String)it, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null) ? object : null;
                if (object2 != null) break block7;
            }
            return null;
        }
        String shape = object2;
        Object object3 = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)shape, (CharSequence)"(", (CharSequence)")"), (String[])object3, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)it)).toString()) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Object it = object3 = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = shape;
        int n = it.size();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$count$iv.charAt(i);
            boolean bl5 = false;
            if (!(ch == ',')) continue;
            ++count$iv;
        }
        int n2 = count$iv;
        return n == n2 + 1 ? object3 : null;
    }

    protected final void doStrategyInitExecution(@NotNull PyFrameAccessor frameAccessor, @NotNull DataViewStrategy strategy) throws PyDebuggerException {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        String string = strategy.getInitExecuteString();
        if (string == null) {
            return;
        }
        String execString = string;
        frameAccessor.evaluate(execString, true, false);
    }

    protected final void updateTabNameSlicingFieldAndFormatField(@Nullable ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, boolean modifier) {
        Object object;
        String realName;
        Intrinsics.checkNotNullParameter((Object)originalDebugValue, (String)"originalDebugValue");
        ArrayChunk arrayChunk = chunk;
        PyDebugValue debugValue = arrayChunk != null ? arrayChunk.getValue() : null;
        String shownName = realName = debugValue == null || Intrinsics.areEqual((Object)debugValue.getName(), (Object)originalDebugValue.getTempName()) ? originalDebugValue.getName() : chunk.getSlicePresentation();
        if (modifier && !Intrinsics.areEqual((Object)this.dataViewerModel.getOriginalVarName(), (Object)shownName)) {
            String string = MODIFIED_VARIABLE_FORMAT;
            object = new Object[]{this.dataViewerModel.getOriginalVarName()};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            shownName = string2;
        } else {
            this.dataViewerModel.setOriginalVarName(realName);
        }
        String string = this.dataViewerModel.getOriginalVarName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.setSlicingValueFromUI(it);
        }
        this.dataViewerModel.setModifiedVarName(realName);
        Iterator<OnNameChangedListener> iterator = this.listeners.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<OnNameChangedListener> iterator2 = iterator;
        while (iterator2.hasNext()) {
            OnNameChangedListener listener2 = iterator2.next();
            object = shownName;
            Intrinsics.checkNotNull((Object)object);
            listener2.onNameChanged((String)object);
        }
        if (chunk != null) {
            String string3 = chunk.getFormat();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFormat(...)");
            this.setFormatValueFromUI(string3);
        }
    }

    @Nullable
    protected final PyDebugValue getDebugValue(@Nullable String expression, boolean modifier) {
        Object var3_3;
        try {
            Object v0;
            PyDebugValue debugValue = this.dataViewerModel.getFrameAccessor().evaluate(expression, false, true);
            if (debugValue == null || debugValue.isErrorOnEval()) {
                ApplicationManager.getApplication().invokeLater(() -> PyDataViewerAbstractPanel.getDebugValue$lambda$0(debugValue, expression, this, modifier));
                v0 = null;
            } else {
                v0 = var3_3;
            }
            var3_3 = v0;
        }
        catch (PyDebuggerException e) {
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerAbstractPanel.getDebugValue$lambda$1(this, e, modifier));
            var3_3 = null;
        }
        return var3_3;
    }

    public final void addNameChangedListener(@NotNull OnNameChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @NotNull
    protected final String composeErrorMessage(@NotNull String text, boolean modifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (modifier) {
            Object[] objectArray = new Object[]{text};
            String string2 = PyBundle.message("debugger.dataViewer.modifier.error", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = text;
        }
        return string;
    }

    private static final void apply$lambda$0$0(PyDebugValue $debugValue, PyDataViewerAbstractPanel this$0, boolean $modifier, DataViewerCommandSource $commandSource) {
        block0: {
            PyDebugValue pyDebugValue = $debugValue;
            if (pyDebugValue == null) break block0;
            PyDebugValue it = pyDebugValue;
            boolean bl = false;
            this$0.apply(it, $modifier, $commandSource);
        }
    }

    private static final void apply$lambda$0(PyDataViewerAbstractPanel this$0, String $name, boolean $modifier, DataViewerCommandSource $commandSource) {
        PyDebugValue debugValue = this$0.getDebugValue($name, $modifier);
        ApplicationManager.getApplication().invokeLater(() -> PyDataViewerAbstractPanel.apply$lambda$0$0(debugValue, this$0, $modifier, $commandSource));
    }

    private static final void apply$lambda$1$0(PyDataViewerAbstractPanel this$0, ArrayChunk $arrayChunk, PyDebugValue $debugValue, DataViewStrategy $strategy, boolean $modifier) {
        Intrinsics.checkNotNull((Object)$arrayChunk);
        this$0.updateUI($arrayChunk, $debugValue, $strategy, $modifier);
        this$0.dataViewerModel.setModified($modifier);
        this$0.dataViewerModel.setDebugValue($debugValue);
    }

    private static final void apply$lambda$1$1(PyDataViewerAbstractPanel this$0, IllegalArgumentException $e, boolean $modifier) {
        String string = $e.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
        this$0.setError(string, $modifier);
    }

    private static final void apply$lambda$1(PyDataViewerAbstractPanel this$0, PyDebugValue $debugValue, DataViewStrategy $strategy, String $format, String $type, boolean $modifier) {
        try {
            PyFrameAccessor pyFrameAccessor = $debugValue.getFrameAccessor();
            Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"<get-frameAccessor>(...)");
            this$0.doStrategyInitExecution(pyFrameAccessor, $strategy);
            ArrayChunk arrayChunk = $debugValue.getFrameAccessor().getArrayItems($debugValue, 0, 0, 0, 0, $format);
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerAbstractPanel.apply$lambda$1$0(this$0, arrayChunk, $debugValue, $strategy, $modifier));
        }
        catch (IllegalArgumentException e) {
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerAbstractPanel.apply$lambda$1$1(this$0, e, $modifier));
        }
        catch (PyDebuggerException e) {
            PyDataViewerAbstractPanel $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyDataViewerAbstractPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Numpy is not available", (boolean)false, (int)2, null) : false;
            if (bl) {
                Object[] $i$f$thisLogger = new Object[]{$type};
                String string2 = PyBundle.message("debugger.data.view.numpy.is.not.available", $i$f$thisLogger);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this$0.setError(string2, $modifier);
            }
            PyDataViewerAbstractPanel $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyDataViewerAbstractPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("PyDataViewer.apply: Numpy is not available", (Throwable)e);
        }
    }

    private static final void getDebugValue$lambda$0(PyDebugValue $debugValue, String $expression, PyDataViewerAbstractPanel this$0, boolean $modifier) {
        String string;
        String debugValueExpression = $debugValue.getValue();
        if ($debugValue != null && debugValueExpression != null) {
            string = debugValueExpression;
        } else {
            Object[] objectArray = new Object[]{$expression};
            String string2 = PyBundle.message("debugger.data.view.failed.to.evaluate.expression", objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        String errorText = string;
        this$0.setError(errorText, $modifier);
    }

    private static final void getDebugValue$lambda$1(PyDataViewerAbstractPanel this$0, PyDebuggerException $e, boolean $modifier) {
        String string = $e.getTracebackError();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTracebackError(...)");
        this$0.setError(string, $modifier);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel$Companion;", "", "<init>", "()V", "MODIFIED_VARIABLE_FORMAT", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerAbstractPanel$OnNameChangedListener;", "", "onNameChanged", "", "name", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "intellij.python.community.impl"})
    public static interface OnNameChangedListener {
        public void onNameChanged(@NotNull String var1);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataViewerCommandSource.values().length];
            try {
                nArray[DataViewerCommandSource.SLICING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataViewerCommandSource.FORMATTING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataViewerCommandSource.RELOAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

