/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.PyRequirementsAnalysisResult;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0002J&\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002J\u001c\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00180\f2\u0006\u0010\"\u001a\u00020\u0004H\u0002J \u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020$H\u0002J$\u0010'\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor;", "", "importedPackages", "", "", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "settings", "Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;", "<init>", "(Ljava/util/Map;Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;)V", "collectedOutput", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "unmatchedLines", "unchangedInBaseFiles", "visitRequirementsFile", "Lcom/jetbrains/python/packaging/PyRequirementsAnalysisResult;", "requirementsFile", "Lcom/intellij/psi/PsiFile;", "doVisitFile", "", "visitedFiles", "", "formatRequirement", "", "requirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "pkg", "lines", "visitBaseFile", "filename", "directory", "Lcom/intellij/psi/PsiDirectory;", "splitByRequirementsEntries", "requirementsText", "compatibleVersion", "", "version", "specifyVersion", "convertToRequirementsEntry", "isSkipableInstallOption", "line", "isFileReference", "isEditableSelf", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyRequirementsFileVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementsFileVisitor.kt\ncom/jetbrains/python/packaging/PyRequirementsFileVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1342#2,2:160\n1807#3,3:162\n1915#3,2:165\n1786#3,3:167\n*S KotlinDebug\n*F\n+ 1 PyRequirementsFileVisitor.kt\ncom/jetbrains/python/packaging/PyRequirementsFileVisitor\n*L\n72#1:160,2\n98#1:162,3\n118#1:165,2\n131#1:167,3\n*E\n"})
public final class PyRequirementsFileVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PythonPackage> importedPackages;
    @NotNull
    private final PyPackageRequirementsSettings settings;
    @NotNull
    private final Map<VirtualFile, List<String>> collectedOutput;
    @NotNull
    private final List<String> unmatchedLines;
    @NotNull
    private final List<String> unchangedInBaseFiles;
    @NotNull
    private static final List<String> vcsPrefixes;

    public PyRequirementsFileVisitor(@NotNull Map<String, PythonPackage> importedPackages2, @NotNull PyPackageRequirementsSettings settings) {
        Intrinsics.checkNotNullParameter(importedPackages2, (String)"importedPackages");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.importedPackages = importedPackages2;
        this.settings = settings;
        this.collectedOutput = new LinkedHashMap();
        this.unmatchedLines = new ArrayList();
        this.unchangedInBaseFiles = new ArrayList();
    }

    @NotNull
    public final PyRequirementsAnalysisResult visitRequirementsFile(@NotNull PsiFile requirementsFile) {
        Intrinsics.checkNotNullParameter((Object)requirementsFile, (String)"requirementsFile");
        Object[] objectArray = new VirtualFile[1];
        Intrinsics.checkNotNullExpressionValue((Object)requirementsFile.getVirtualFile(), (String)"getVirtualFile(...)");
        this.doVisitFile(requirementsFile, SetsKt.mutableSetOf((Object[])objectArray));
        List<String> list = this.collectedOutput.remove(requirementsFile.getVirtualFile());
        Intrinsics.checkNotNull(list);
        List<String> currentFileOutput = list;
        return new PyRequirementsAnalysisResult(currentFileOutput, this.collectedOutput, this.unmatchedLines, this.unchangedInBaseFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final void doVisitFile(PsiFile requirementsFile, Set<VirtualFile> visitedFiles) {
        List outputLines = new ArrayList();
        String string = requirementsFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List<List<String>> entries = this.splitByRequirementsEntries(string);
        for (List<String> lines : entries) {
            String name2;
            List parsed;
            String[] stringArray;
            String firstLine;
            if (lines.size() == 1 && (StringsKt.startsWith$default((String)(firstLine = (String)CollectionsKt.first(lines)), (String)"#", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)firstLine))) {
                outputLines.add(firstLine);
                continue;
            }
            String line = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), PyRequirementsFileVisitor::doVisitFile$lambda$0), PyRequirementsFileVisitor::doVisitFile$lambda$1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            if (this.isSkipableInstallOption(line)) {
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (this.settings.getModifyBaseFiles() && this.isFileReference(line)) {
                stringArray = new String[]{" "};
                String filename = (String)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                PsiDirectory psiDirectory = requirementsFile.getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getContainingDirectory(...)");
                this.visitBaseFile(filename, psiDirectory, visitedFiles);
                outputLines.addAll((Collection)lines);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)PyRequirementParser.fromText((String)line, (VirtualFile)requirementsFile.getVirtualFile(), (Set)new LinkedHashSet()), (String)"fromText(...)");
            if (this.isFileReference(line)) {
                void $this$forEach$iv;
                if (parsed.isEmpty()) {
                    if (this.settings.getRemoveUnused()) continue;
                    outputLines.addAll((Collection)lines);
                    continue;
                }
                stringArray = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)parsed), arg_0 -> PyRequirementsFileVisitor.doVisitFile$lambda$2(this, arg_0)), arg_0 -> PyRequirementsFileVisitor.doVisitFile$lambda$3(this, arg_0)), arg_0 -> PyRequirementsFileVisitor.doVisitFile$lambda$4(this, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    String string2 = ((PyRequirement)it.getFirst()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    this.unchangedInBaseFiles.add(string2);
                }
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (parsed.isEmpty()) {
                boolean bl = this.settings.getRemoveUnused() ? this.unmatchedLines.add(line) : outputLines.addAll((Collection)lines);
                continue;
            }
            PyRequirement requirement = (PyRequirement)CollectionsKt.first((List)parsed);
            Intrinsics.checkNotNullExpressionValue((Object)requirement.getName(), (String)"getName(...)");
            if (this.importedPackages.containsKey(name2)) {
                PythonPackage pkg;
                Intrinsics.checkNotNull((Object)this.importedPackages.remove(name2));
                Intrinsics.checkNotNull((Object)requirement);
                List<String> formatted = this.formatRequirement(requirement, pkg, lines);
                outputLines.addAll((Collection)formatted);
                continue;
            }
            if (this.settings.getRemoveUnused()) continue;
            outputLines.addAll((Collection)lines);
        }
        this.collectedOutput.put(requirementsFile.getVirtualFile(), outputLines);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<String> formatRequirement(PyRequirement requirement, PythonPackage pkg, List<String> lines) {
        List list;
        block10: {
            block9: {
                boolean bl;
                block8: {
                    if (requirement.isEditable()) break block9;
                    Iterable $this$any$iv = vcsPrefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)lines)), (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block10;
            }
            list = lines;
            return list;
        }
        if (this.settings.getKeepMatchingSpecifier() && this.compatibleVersion(requirement, pkg.getVersion(), this.settings.getSpecifyVersion())) {
            list = lines;
            return list;
        }
        list = CollectionsKt.listOf((Object)this.convertToRequirementsEntry(requirement, this.settings, pkg.getVersion()));
        return list;
    }

    private final void visitBaseFile(String filename, PsiDirectory directory, Set<VirtualFile> visitedFiles) {
        VirtualFile referencedFile = directory.getVirtualFile().findFileByRelativePath(filename);
        if (referencedFile != null && visitedFiles.add(referencedFile)) {
            PsiFile psiFile = directory.getManager().findFile(referencedFile);
            Intrinsics.checkNotNull((Object)psiFile);
            PsiFile baseRequirementsFile = psiFile;
            this.doVisitFile(baseRequirementsFile, visitedFiles);
            visitedFiles.remove(referencedFile);
        }
    }

    private final List<List<String>> splitByRequirementsEntries(String requirementsText) {
        List splitList = null;
        splitList = new ArrayList();
        List resultList = new ArrayList();
        if (!StringsKt.isBlank((CharSequence)requirementsText)) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)requirementsText);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                splitList.add(it);
                if (StringsKt.endsWith$default((String)it, (String)"\\", (boolean)false, (int)2, null)) continue;
                resultList.add(splitList);
                splitList = new ArrayList();
            }
        }
        if (!((Collection)splitList).isEmpty()) {
            String string = PyBundle.message("python.requirements.error.ends.with.slash", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean compatibleVersion(PyRequirement requirement, String version2, boolean specifyVersion) {
        if (specifyVersion) {
            PyRequirementVersionSpec it;
            List list = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVersionSpecs(...)");
            if (((Collection)list).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            List list2 = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getVersionSpecs(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (PyRequirementVersionSpec)element$iv;
                boolean bl2 = false;
            } while (it.matches(version2));
            return false;
        }
        boolean bl = requirement.getVersionSpecs().isEmpty();
        return bl;
    }

    private final String convertToRequirementsEntry(PyRequirement requirement, PyPackageRequirementsSettings settings, String version2) {
        Object packageName;
        if (settings.getSpecifyVersion()) {
            if (version2 != null) {
                v0 = requirement.getPresentableTextWithoutVersion() + requirement.getExtras() + settings.getVersionSpecifier().getSeparator() + version2;
            } else {
                String string = requirement.getPresentableTextWithoutVersion();
                v0 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableTextWithoutVersion(...)");
            }
        } else {
            v0 = packageName = requirement.getPresentableTextWithoutVersion() + requirement.getExtras();
        }
        if (requirement.getInstallOptions().size() == 1) {
            return packageName;
        }
        String offset = StringsKt.repeat((CharSequence)" ", (int)(((String)packageName).length() + 1));
        List list = requirement.getInstallOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstallOptions(...)");
        String installOptions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)list, (int)1), (CharSequence)("\\\n" + offset), null, null, (int)0, null, null, (int)62, null);
        return (String)packageName + " " + installOptions;
    }

    static /* synthetic */ String convertToRequirementsEntry$default(PyRequirementsFileVisitor pyRequirementsFileVisitor, PyRequirement pyRequirement, PyPackageRequirementsSettings pyPackageRequirementsSettings, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return pyRequirementsFileVisitor.convertToRequirementsEntry(pyRequirement, pyPackageRequirementsSettings, string);
    }

    private final boolean isSkipableInstallOption(String line) {
        return this.isEditableSelf(line) || StringsKt.startsWith$default((String)line, (String)"--", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)line, (String)"--editable", (boolean)false, (int)2, null) && !this.isFileReference(line);
    }

    private final boolean isFileReference(String line) {
        return StringsKt.startsWith$default((String)line, (String)"-r ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"--requirement ", (boolean)false, (int)2, null);
    }

    private final boolean isEditableSelf(String line) {
        return StringsKt.startsWith$default((String)line, (String)"--editable .", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"-e .", (boolean)false, (int)2, null);
    }

    private static final String doVisitFile$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final String doVisitFile$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.removeSuffix((String)it, (CharSequence)"\\");
    }

    private static final boolean doVisitFile$lambda$2(PyRequirementsFileVisitor this$0, PyRequirement it) {
        Map<String, PythonPackage> map2 = this$0.importedPackages;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        string2 = string3;
        return map2.containsKey(string2);
    }

    private static final Pair doVisitFile$lambda$3(PyRequirementsFileVisitor this$0, PyRequirement it) {
        Map<String, PythonPackage> map2 = this$0.importedPackages;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return TuplesKt.to((Object)it, (Object)map2.remove(string3));
    }

    private static final boolean doVisitFile$lambda$4(PyRequirementsFileVisitor this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
        PyRequirement pyRequirement = (PyRequirement)object;
        Object object2 = it.getSecond();
        Intrinsics.checkNotNull((Object)object2);
        return this$0.compatibleVersion(pyRequirement, ((PythonPackage)object2).getVersion(), this$0.settings.getSpecifyVersion());
    }

    static {
        Object[] objectArray = new String[]{"git:", "git+", "svn+", "hg+", "bzr+"};
        vcsPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor$Companion;", "", "<init>", "()V", "vcsPrefixes", "", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

