/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.python.Result;
import com.jetbrains.python.errorProcessing.MessageError;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.common.PythonSimplePackageDetails;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryUtil;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a*\u0010\u0002\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"GSON", "Lcom/google/gson/Gson;", "buildPackageDetailsBySimpleDetailsProtocol", "Lcom/jetbrains/python/Result;", "Lcom/jetbrains/python/packaging/common/PythonSimplePackageDetails;", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "packageName", "", "intellij.python.community.impl"})
public final class PyPackageRepositoryKt {
    @NotNull
    private static final Gson GSON = new Gson();

    @NotNull
    public static final Result<PythonSimplePackageDetails, PyError> buildPackageDetailsBySimpleDetailsProtocol(@NotNull PyPackageRepository $this$buildPackageDetailsBySimpleDetailsProtocol, @NotNull String packageName) {
        Object $this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)$this$buildPackageDetailsBySimpleDetailsProtocol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String string = $this$buildPackageDetailsBySimpleDetailsProtocol.getRepositoryUrl();
        if (string == null) {
            return (Result)Result.Companion.failure((Object)new MessageError("There is no repository url for " + $this$buildPackageDetailsBySimpleDetailsProtocol.getName()));
        }
        String repositoryUrl = string;
        Object object = $this$buildPackageDetailsBySimpleDetailsProtocol;
        try {
            $this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240 = object;
            boolean bl = false;
            String string2 = PyPIPackageUtil.buildDetailsUrl(repositoryUrl, packageName);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"buildDetailsUrl(...)");
            String packageDetailsUrl = string2;
            RequestBuilder requestBuilder = HttpRequests.request((String)packageDetailsUrl);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
            String string3 = PyPackageRepositoryUtil.withBasicAuthorization(requestBuilder, (PyPackageRepository)$this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240).readTimeout(3000).readString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
            String rawInfo = string3;
            $this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240 = kotlin.Result.constructor-impl((Object)((PyPIPackageUtil.PackageDetails)GSON.fromJson(rawInfo, PyPIPackageUtil.PackageDetails.class)));
        }
        catch (Throwable bl) {
            $this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240 = kotlin.Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$buildPackageDetailsBySimpleDetailsProtocol_u24lambda_u240;
        Throwable throwable = kotlin.Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            Throwable throwable3 = throwable2;
            if (throwable3 instanceof JsonSyntaxException || throwable3 instanceof PyPIPackageUtil.NotSimpleRepositoryApiUrlException || throwable3 instanceof IOException) {
                String string4 = ((Exception)throwable2).getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getLocalizedMessage(...)");
                return (Result)Result.Companion.localizedError(string4);
            }
            throw throwable2;
        }
        PyPIPackageUtil.PackageDetails packageDetails = (PyPIPackageUtil.PackageDetails)object;
        List<String> list = packageDetails.getReleases();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReleases(...)");
        Iterable iterable = list;
        Comparator comparator = PyPackageVersionComparator.getSTR_COMPARATOR().reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        PythonSimplePackageDetails pythonSimplePackageDetails = new PythonSimplePackageDetails(packageName, CollectionsKt.sortedWith((Iterable)iterable, comparator), $this$buildPackageDetailsBySimpleDetailsProtocol, packageDetails.getInfo().getSummary(), packageDetails.getInfo().getDescription(), packageDetails.getInfo().getDescriptionContentType(), packageDetails.getInfo().getProjectUrls().get("Documentation"), packageDetails.getInfo().getAuthor(), packageDetails.getInfo().getAuthorEmail(), packageDetails.getInfo().getHomePage());
        return (Result)Result.Companion.success((Object)pythonSimplePackageDetails);
    }
}

