/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ShellEnvironmentReader;
import com.jetbrains.python.sdk.PySdkCoreToolsKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.conda.PyCondaFlavorData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u001d\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u000f\u0010\b\u001a\u000b0\tj\u0002`\u000b\u00a2\u0006\u0002\b\nH\u0007\u001a1\u0010\u0010\u001a\u00020\u0004*\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00122\u000f\u0010\b\u001a\u000b0\tj\u0002`\u000b\u00a2\u0006\u0002\b\nH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fixCondaPathEnvIfNeeded", "", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "condaPathOnTarget", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/execution/target/FullPathOnTarget;", "localOnWindows", "", "getLocalOnWindows", "(Lcom/intellij/execution/target/TargetedCommandLineBuilder;)Z", "addEnvVars", "envs", "", "intellij.python.community.impl"})
public final class CondaPathFixKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public static final void fixCondaPathEnvIfNeeded(@NotNull TargetedCommandLineBuilder $this$fixCondaPathEnvIfNeeded, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)$this$fixCondaPathEnvIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!CondaPathFixKt.getLocalOnWindows($this$fixCondaPathEnvIfNeeded)) {
            return;
        }
        PyFlavorData pyFlavorData = PySdkCoreToolsKt.getOrCreateAdditionalData((Sdk)sdk2).getFlavorAndData().getData();
        PyCondaFlavorData pyCondaFlavorData = pyFlavorData instanceof PyCondaFlavorData ? (PyCondaFlavorData)pyFlavorData : null;
        if (pyCondaFlavorData == null) {
            return;
        }
        PyCondaFlavorData condaData = pyCondaFlavorData;
        String pythonHomePath = sdk2.getHomePath();
        if (pythonHomePath == null) {
            LOG.warn("No home path for " + $this$fixCondaPathEnvIfNeeded + ", will skip 'venv activation'");
            return;
        }
        Map map2 = PySdkUtil.activateVirtualEnv((Sdk)sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"activateVirtualEnv(...)");
        CondaPathFixKt.addEnvVars($this$fixCondaPathEnvIfNeeded, map2, condaData.getEnv().getFullCondaPathOnTarget());
    }

    @ApiStatus.Internal
    public static final void fixCondaPathEnvIfNeeded(@NotNull TargetedCommandLineBuilder $this$fixCondaPathEnvIfNeeded, @NotNull String condaPathOnTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$fixCondaPathEnvIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)condaPathOnTarget, (String)"condaPathOnTarget");
        if (!CondaPathFixKt.getLocalOnWindows($this$fixCondaPathEnvIfNeeded)) {
            return;
        }
        Path condaPath = Path.of(condaPathOnTarget, new String[0]);
        Intrinsics.checkNotNull((Object)condaPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(condaPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.warn(condaPath + " doesn't exist");
            return;
        }
        Path activateBat = condaPath.resolveSibling("activate.bat");
        Intrinsics.checkNotNull((Object)activateBat);
        if (!Files.isExecutable(activateBat)) {
            LOG.warn(activateBat + " doesn't exist or can't be read");
            return;
        }
        try {
            ProcessBuilder processBuilder = ShellEnvironmentReader.winShellCommand((Path)activateBat, null);
            Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"winShellCommand(...)");
            ProcessBuilder command = processBuilder;
            Object object = ShellEnvironmentReader.readEnvironment((ProcessBuilder)command, (long)0L).first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            Map envs = (Map)object;
            CondaPathFixKt.addEnvVars($this$fixCondaPathEnvIfNeeded, envs, condaPathOnTarget);
        }
        catch (IOException e) {
            LOG.warn("Can't read env vars", (Throwable)e);
        }
    }

    private static final boolean getLocalOnWindows(TargetedCommandLineBuilder $this$localOnWindows) {
        TargetEnvironmentRequest it = $this$localOnWindows.getRequest();
        boolean bl = false;
        return it.getTargetPlatform().getPlatform() == Platform.WINDOWS && it.getConfiguration() == null;
    }

    private static final void addEnvVars(TargetedCommandLineBuilder $this$addEnvVars, Map<String, String> envs, String condaPathOnTarget) {
        Path extraPath;
        block4: {
            block3: {
                Path path2 = Path.of(condaPathOnTarget, new String[0]).getParent();
                Path path3 = path2 != null && (path2 = path2.getParent()) != null && (path2 = path2.resolve("Library")) != null ? path2.resolve("Bin") : (extraPath = null);
                if (extraPath == null) break block3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(extraPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block3;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(extraPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block4;
            }
            LOG.warn(extraPath + " doesn't exist");
        }
        LOG.info("Patching envs");
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            String fixedVal = StringsKt.equals((String)k, (String)"Path", (boolean)true) && extraPath != null ? v + $this$addEnvVars.getRequest().getTargetPlatform().getPlatform().pathSeparator + extraPath : v;
            $this$addEnvVars.addEnvironmentVariable(k, fixedVal);
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"CondaLogger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

