/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.prefixTree.set;

import com.intellij.util.containers.prefixTree.PrefixTreeFactory;
import com.intellij.util.containers.prefixTree.map.MutablePrefixTreeMap;
import com.intellij.util.containers.prefixTree.set.MutablePrefixTreeSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.AbstractSet;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0096\u0082\u0004R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u00020\r8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/containers/prefixTree/set/PrefixTreeSetImpl;", "Key", "KeyElement", "Lkotlin/collections/AbstractSet;", "Lcom/intellij/util/containers/prefixTree/set/MutablePrefixTreeSet;", "convertor", "Lcom/intellij/util/containers/prefixTree/PrefixTreeFactory;", "<init>", "(Lcom/intellij/util/containers/prefixTree/PrefixTreeFactory;)V", "map", "Lcom/intellij/util/containers/prefixTree/map/MutablePrefixTreeMap;", "", "size", "", "getSize", "()I", "contains", "", "element", "(Ljava/lang/Object;)Z", "getDescendants", "", "(Ljava/lang/Object;)Ljava/util/Set;", "getAncestors", "getRoots", "add", "", "(Ljava/lang/Object;)V", "remove", "iterator", "", "intellij.platform.util.base"})
@ApiStatus.Internal
public final class PrefixTreeSetImpl<Key, KeyElement>
extends AbstractSet<Key>
implements MutablePrefixTreeSet<Key> {
    @NotNull
    private final MutablePrefixTreeMap map;

    public PrefixTreeSetImpl(@NotNull PrefixTreeFactory<Key, KeyElement> convertor) {
        Intrinsics.checkNotNullParameter(convertor, "convertor");
        this.map = convertor.createMap();
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object element) {
        return ((Map)this.map).containsKey(element);
    }

    @Override
    @NotNull
    public Set<Key> getDescendants(Key element) {
        return this.map.getDescendantKeys(element);
    }

    @Override
    @NotNull
    public Set<Key> getAncestors(Key element) {
        return this.map.getAncestorKeys(element);
    }

    @Override
    @NotNull
    public Set<Key> getRoots() {
        return this.map.getRootKeys();
    }

    @Override
    public void add(Key element) {
        this.map.set(element, null);
    }

    @Override
    public void remove(Key element) {
        this.map.remove(element);
    }

    @Override
    @NotNull
    public Iterator<Key> iterator() {
        return this.map.keySet().iterator();
    }
}

