/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.platform.execution.dashboard.actions.AddRunConfigurationActionKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/execution/dashboard/actions/AddRunConfigurationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "performAdding", "selectedTypes", "", "Lcom/intellij/execution/configurations/ConfigurationType;", "project", "Lcom/intellij/openapi/project/Project;", "showAddPopup", "onAddCallback", "Ljava/util/function/Consumer;", "popupOpener", "Lcom/intellij/openapi/ui/popup/JBPopup;", "showApplicableTypesOnly", "", "intellij.platform.execution.dashboard"})
@SourceDebugExtension(value={"SMAP\nAddRunConfigurationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddRunConfigurationAction.kt\ncom/intellij/platform/execution/dashboard/actions/AddRunConfigurationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n2792#2,3:153\n812#2,12:156\n*S KotlinDebug\n*F\n+ 1 AddRunConfigurationAction.kt\ncom/intellij/platform/execution/dashboard/actions/AddRunConfigurationAction\n*L\n62#1:153,3\n100#1:156,12\n*E\n"})
public final class AddRunConfigurationAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.BackendOnly {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.showAddPopup(project2, arg_0 -> AddRunConfigurationAction.actionPerformed$lambda$0(this, project2, arg_0), arg_0 -> AddRunConfigurationAction.actionPerformed$lambda$1(e, arg_0), true);
    }

    private final void performAdding(List<? extends ConfigurationType> selectedTypes, Project project) {
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        Set set = runDashboardManager.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
        Set currentTypes = set;
        HashSet<String> updatedTypes = new HashSet<String>(currentTypes);
        ArrayList<ConfigurationType> addedTypes = new ArrayList<ConfigurationType>();
        for (ConfigurationType configurationType : selectedTypes) {
            if (!updatedTypes.add(configurationType.getId())) continue;
            addedTypes.add(configurationType);
        }
        RunConfiguration configuration = null;
        if (!addedTypes.isEmpty()) {
            boolean bl;
            block11: {
                Iterable iterable = RunManager.Companion.getInstance(project).getAllSettings();
                boolean $i$f$none = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : iterable) {
                        RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                        boolean bl2 = false;
                        if (!addedTypes.contains(it.getType())) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                ConfigurationType configurationType = (ConfigurationType)CollectionsKt.minWithOrNull((Iterable)addedTypes, (Comparator)AddRunConfigurationActionKt.access$getIGNORE_CASE_DISPLAY_NAME_COMPARATOR$p());
                if (configurationType == null) {
                    return;
                }
                ConfigurationType configurationType2 = configurationType;
                RunConfiguration runConfiguration = AddRunConfigurationActionKt.access$addRunConfiguration(configurationType2, project);
                if (runConfiguration == null) {
                    return;
                }
                configuration = runConfiguration;
            }
            runDashboardManager.setTypes((Set)updatedTypes);
        } else {
            ConfigurationType configurationType = (ConfigurationType)CollectionsKt.minWithOrNull((Iterable)selectedTypes, (Comparator)AddRunConfigurationActionKt.access$getIGNORE_CASE_DISPLAY_NAME_COMPARATOR$p());
            if (configurationType == null) {
                return;
            }
            ConfigurationType configurationType3 = configurationType;
            configuration = AddRunConfigurationActionKt.access$addRunConfiguration(configurationType3, project);
        }
        if (configuration != null && !runDashboardManager.isShowInDashboard(configuration)) {
            runDashboardManager.restoreConfigurations((Collection)CollectionsKt.listOf((Object)configuration));
        }
    }

    private final void showAddPopup(Project project, Consumer<List<ConfigurationType>> onAddCallback, Consumer<JBPopup> popupOpener, boolean showApplicableTypesOnly) {
        List allTypes = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        ArrayList popupList = AddRunConfigurationActionKt.access$getTypesPopupList(project, showApplicableTypesOnly, allTypes);
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder((List)popupList).setTitle(ExecutionBundle.message((String)"run.dashboard.configurable.add.configuration", (Object[])new Object[0])).setSelectionMode(2).setRenderer(AddRunConfigurationActionKt.access$getTypesPopupRenderer()).setMovable(true).setResizable(true).setNamerForFiltering(AddRunConfigurationAction::showAddPopup$lambda$0).setAdText(ExecutionBundle.message((String)"run.dashboard.configurable.types.panel.hint", (Object[])new Object[0])).setItemsChosenCallback(arg_0 -> AddRunConfigurationAction.showAddPopup$lambda$2(arg_0 -> AddRunConfigurationAction.showAddPopup$lambda$1(this, project, onAddCallback, popupOpener, arg_0), arg_0));
        popupOpener.accept(builder.createPopup());
    }

    private static final void actionPerformed$lambda$0(AddRunConfigurationAction this$0, Project $project, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.performAdding(it, $project);
    }

    private static final void actionPerformed$lambda$1(AnActionEvent $e, JBPopup popup) {
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        popup.showInBestPositionFor($e.getDataContext());
    }

    private static final String showAddPopup$lambda$0(Object it) {
        return it instanceof ConfigurationType ? ((ConfigurationType)it).getDisplayName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showAddPopup$lambda$1(AddRunConfigurationAction this$0, Project $project, Consumer $onAddCallback, Consumer $popupOpener, Set selectedValues) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Object value = ContainerUtil.getOnlyItem((Collection)selectedValues);
        if (value instanceof String) {
            this$0.showAddPopup($project, $onAddCallback, $popupOpener, false);
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)selectedValues);
        Iterable iterable = selectedValues;
        Consumer consumer = $onAddCallback;
        boolean $i$f$filterIsInstance = false;
        void var8_9 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConfigurationType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        consumer.accept((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final void showAddPopup$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

