/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.value.TargetValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DeferredTargetValue<T>
implements TargetValue<T> {
    private final AsyncPromise<T> myTargetPromise = new AsyncPromise();
    private final Promise<T> myLocalPromise;

    public DeferredTargetValue(T localValue) {
        this.myLocalPromise = Promises.resolvedPromise(localValue);
    }

    public void resolve(T valueToResolve) {
        if (this.myTargetPromise.isDone()) {
            throw new IllegalStateException("Target value is already resolved to '" + String.valueOf(this.myTargetPromise.get()) + "'");
        }
        this.myTargetPromise.setResult(valueToResolve);
    }

    public void resolveFailure(@NotNull Throwable t) {
        if (t == null) {
            DeferredTargetValue.$$$reportNull$$$0(0);
        }
        if (this.myTargetPromise.isDone()) {
            throw new IllegalStateException("Target value is already resolved to '" + String.valueOf(this.myTargetPromise.get()) + "'");
        }
        this.myTargetPromise.setError(ExecutionBundle.message("message.error.happened.0", t.getMessage()));
    }

    public void stopProceeding() {
        if (this.myTargetPromise.isDone()) {
            throw new IllegalStateException("Target value is already resolved to '" + String.valueOf(this.myTargetPromise.get()) + "'");
        }
        this.myTargetPromise.setError(ExecutionBundle.message("error.message.should.not.proceed.further", new Object[0]));
    }

    @Override
    public Promise<T> getLocalValue() {
        return this.myLocalPromise;
    }

    @Override
    public Promise<T> getTargetValue() {
        return this.myTargetPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/execution/target/value/DeferredTargetValue", "resolveFailure"));
    }
}

