/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.google.common.base.MoreObjects;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.internal.inspector.UiInspectorActionUtil;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.toolWindow.StripeButton;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.dsl.builder.impl.DslComponentPropertyInternal;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ComponentPropertiesCollector {
    private static final Logger LOG = Logger.getInstance(ComponentPropertiesCollector.class);
    private static final List<String> PROPERTIES = Arrays.asList("ui", "getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getCellRenderer", "getCellEditor", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getPreferredScrollableViewportSize", "getText", "toString", "isEditable", "getIcon", "getVisibleRect", "getLayout", "getAlignmentX", "getAlignmentY", "getTooltipText", "getToolTipText", "cursor", "isShowing", "isEnabled", "isVisible", "isDoubleBuffered", "isFocusable", "isFocusCycleRoot", "isFocusOwner", "isValid", "isDisplayable", "isLightweight", "getClientProperties", "getMouseListeners", "getFocusListeners");
    private static final List<String> CHECKERS = Arrays.asList("isForegroundSet", "isBackgroundSet", "isFontSet", "isMinimumSizeSet", "isMaximumSizeSet", "isPreferredSizeSet");
    private static final List<String> ACCESSIBLE_CONTEXT_PROPERTIES = Arrays.asList("getAccessibleRole", "getAccessibleName", "getAccessibleDescription", "getAccessibleAction", "getAccessibleParent", "getAccessibleChildrenCount", "getAccessibleIndexInParent", "getAccessibleRelationSet", "getAccessibleStateSet", "getAccessibleEditableText", "getAccessibleTable", "getAccessibleText", "getAccessibleValue", "accessibleChangeSupport");
    private final List<PropertyBean> myProperties = new ArrayList<PropertyBean>();
    private static final LazyInitializer.LazyValue<Map<Integer, String>> MIG_LAYOUT_UNIT_MAP = new LazyInitializer.LazyValue(() -> {
        HashMap<Integer, String> result2 = new HashMap<Integer, String>();
        try {
            Field mapField = UnitValue.class.getDeclaredField("UNIT_MAP");
            mapField.setAccessible(true);
            Map map = (Map)mapField.get(null);
            for (Map.Entry entry : map.entrySet()) {
                result2.put((Integer)entry.getValue(), (String)entry.getKey());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return result2;
    });

    @NotNull
    public static List<PropertyBean> collect(@NotNull Component component) {
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(0);
        }
        ComponentPropertiesCollector collector = new ComponentPropertiesCollector();
        collector.collectProperties(component);
        List<PropertyBean> list2 = collector.myProperties;
        if (list2 == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<PropertyBean> collect(@NotNull Object propertiesHolder, @NotNull @NotNull List<@NotNull String> methodList) {
        if (propertiesHolder == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(2);
        }
        if (methodList == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(3);
        }
        ComponentPropertiesCollector collector = new ComponentPropertiesCollector();
        collector.addProperties("", propertiesHolder, methodList);
        List<PropertyBean> list2 = collector.myProperties;
        if (list2 == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<PropertyBean> collect(@NotNull Accessible a) {
        if (a == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(5);
        }
        ComponentPropertiesCollector collector = new ComponentPropertiesCollector();
        collector.collectAccessibleProperties(a);
        List<PropertyBean> list2 = collector.myProperties;
        if (list2 == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private ComponentPropertiesCollector() {
    }

    private void collectProperties(@NotNull Component component) {
        EditorComponentImpl editorComponent;
        CharSequence placeholder;
        String emptyText;
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(7);
        }
        this.addProperties("", component, PROPERTIES);
        this.myProperties.add(new PropertyBean("baseline", (Object)component.getBaseline(component.getWidth(), component.getHeight())));
        Pair<String, String> addedAt = ComponentPropertiesCollector.getAddedAtStacktrace(component);
        this.myProperties.add(new PropertyBean((String)addedAt.first, addedAt.second, addedAt.second != null));
        boolean isAccessible = component instanceof Accessible;
        this.myProperties.add(new PropertyBean("accessible", (Object)isAccessible));
        AccessibleContext context = component.getAccessibleContext();
        this.myProperties.add(new PropertyBean("accessibleContext", (Object)context));
        if (isAccessible) {
            this.addProperties("  ", component.getAccessibleContext(), ACCESSIBLE_CONTEXT_PROPERTIES);
        }
        if (component instanceof Container) {
            this.addLayoutProperties((Container)component);
        }
        if (component instanceof TextPanel.WithIconAndArrows) {
            this.myProperties.add(new PropertyBean("icon", (Object)((TextPanel.WithIconAndArrows)component).getIcon()));
        }
        if (component.getParent() != null) {
            LayoutManager layout = component.getParent().getLayout();
            if (layout instanceof com.intellij.ui.layout.migLayout.patched.MigLayout) {
                CC cc = (CC)((com.intellij.ui.layout.migLayout.patched.MigLayout)layout).getComponentConstraints().get(component);
                if (cc != null) {
                    this.addMigLayoutComponentConstraints(cc);
                }
            } else if (layout instanceof GridLayout && component instanceof JComponent) {
                this.addGridLayoutComponentConstraints(Objects.requireNonNull(((GridLayout)layout).getConstraints((JComponent)component)));
            }
        }
        if (component instanceof ComponentWithEmptyText && !(emptyText = ((ComponentWithEmptyText)component).getEmptyText().toString()).isEmpty()) {
            this.myProperties.add(new PropertyBean("EmptyText", (Object)emptyText));
        }
        if (component instanceof EditorComponentImpl && (placeholder = (editorComponent = (EditorComponentImpl)component).getEditor().getPlaceholder()) != null && !placeholder.isEmpty()) {
            this.myProperties.add(new PropertyBean("Editor Placeholder", (Object)placeholder));
        }
    }

    private void collectAccessibleProperties(@NotNull Accessible a) {
        if (a == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(8);
        }
        this.myProperties.add(new PropertyBean("accessible", (Object)true));
        AccessibleContext context = a.getAccessibleContext();
        this.myProperties.add(new PropertyBean("accessibleContext", (Object)context));
        this.addProperties("  ", a.getAccessibleContext(), ACCESSIBLE_CONTEXT_PROPERTIES);
    }

    private void addProperties(@NotNull String prefix, @NotNull Object component, @NotNull List<String> methodNames) {
        DialogWrapper dialog2;
        TreeModel model2;
        Class<?> declaringClass;
        Class<?> superClass;
        if (prefix == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(9);
        }
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(10);
        }
        if (methodNames == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(11);
        }
        Class<?> clazz = component.getClass();
        this.myProperties.add(new PropertyBean(prefix + "class", (Object)(clazz.getName() + "@" + System.identityHashCode(component))));
        if (clazz.isAnonymousClass() && (superClass = clazz.getSuperclass()) != null) {
            this.myProperties.add(new PropertyBean(prefix + "superclass", (Object)superClass.getName(), true));
        }
        if ((declaringClass = clazz.getDeclaringClass()) != null) {
            this.myProperties.add(new PropertyBean(prefix + "declaringClass", (Object)declaringClass.getName()));
        }
        if (component instanceof Tree && (model2 = ((Tree)component).getModel()) != null) {
            this.myProperties.add(new PropertyBean(prefix + "treeModelClass", (Object)model2.getClass().getName(), true));
        }
        this.addActionInfo(component);
        this.addToolbarInfo(component);
        this.addToolWindowInfo(component);
        this.addGutterInfo(component);
        UiInspectorContextProvider contextProvider = UiInspectorUtil.getProvider((Object)component);
        if (contextProvider != null) {
            try {
                this.myProperties.addAll(contextProvider.getUiInspectorContext());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        StringBuilder classHierarchy = new StringBuilder();
        for (Class<?> cl = clazz.getSuperclass(); cl != null; cl = cl.getSuperclass()) {
            if (!classHierarchy.isEmpty()) {
                classHierarchy.append(" ").append(UIUtil.rightArrow()).append(" ");
            }
            classHierarchy.append(cl.getName());
            if (JComponent.class.getName().equals(cl.getName())) break;
        }
        this.myProperties.add(new PropertyBean(prefix + "hierarchy", (Object)classHierarchy.toString()));
        if (component instanceof Component && (dialog2 = DialogWrapper.findInstance((Component)((Component)component))) != null) {
            this.myProperties.add(new PropertyBean(prefix + "dialogWrapperClass", (Object)dialog2.getClass().getName(), true));
        }
        this.addPropertiesFromMethodNames(prefix, component, methodNames);
    }

    private static List<Method> collectAllMethodsRecursively(Class<?> clazz) {
        ArrayList<Method> list2 = new ArrayList<Method>();
        for (Class<?> cl = clazz; cl != null; cl = cl.getSuperclass()) {
            list2.addAll(Arrays.asList(cl.getDeclaredMethods()));
        }
        return list2;
    }

    private void addPropertiesFromMethodNames(@NotNull String prefix, @NotNull Object component, @NotNull List<String> methodNames) {
        Class<?> clazz0;
        if (prefix == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(12);
        }
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(13);
        }
        if (methodNames == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(14);
        }
        Class<?> clazz = (clazz0 = component.getClass()).isAnonymousClass() ? clazz0.getSuperclass() : clazz0;
        for (String name : methodNames) {
            String propertyName = (String)ObjectUtils.notNull((Object)StringUtil.getPropertyName((String)name), (Object)name);
            try {
                Object propertyValue;
                try {
                    propertyValue = ReflectionUtil.findMethod(ComponentPropertiesCollector.collectAllMethodsRecursively(clazz), (String)name, (Class[])new Class[0]).invoke(component, new Object[0]);
                }
                catch (Exception e) {
                    propertyValue = ReflectionUtil.findField(clazz, null, (String)name).get(component);
                }
                boolean changed = false;
                try {
                    Object value;
                    String checkerMethodName = "is" + StringUtil.capitalize((String)propertyName) + "Set";
                    if (CHECKERS.contains(checkerMethodName) && (value = ReflectionUtil.findMethod(Arrays.asList(clazz.getMethods()), (String)checkerMethodName, (Class[])new Class[0]).invoke(component, new Object[0])) instanceof Boolean) {
                        changed = (Boolean)value;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myProperties.add(new PropertyBean(prefix + propertyName, propertyValue, changed));
            }
            catch (Exception exception) {}
        }
    }

    private void addGutterInfo(Object component) {
        GutterMark renderer;
        Point clickPoint;
        Point point = clickPoint = component instanceof EditorGutterComponentEx ? (Point)ClientProperty.get((Component)((EditorGutterComponentEx)component), UiInspectorAction.CLICK_INFO_POINT) : null;
        if (clickPoint != null && (renderer = ((EditorGutterComponentEx)component).getGutterRenderer(clickPoint)) != null) {
            this.myProperties.add(new PropertyBean("gutter renderer", (Object)renderer.getClass().getName(), true));
        }
    }

    private void addActionInfo(Object component) {
        AnAction action = null;
        if (component instanceof ActionButton) {
            action = ((ActionButton)component).getAction();
        } else if (component instanceof JComponent) {
            action = component instanceof ActionMenuItem ? ((ActionMenuItem)component).getAnAction() : (component instanceof ActionMenu ? ((ActionMenu)component).getAnAction() : ComponentPropertiesCollector.getAction(ComponentUtil.findParentByCondition((Component)((Component)component), c -> ComponentPropertiesCollector.getAction(c) != null)));
        }
        if (action != null) {
            this.myProperties.addAll(UiInspectorActionUtil.INSTANCE.collectAnActionInfo(action));
        }
    }

    private void addToolbarInfo(Object component) {
        if (component instanceof ActionToolbarImpl) {
            ActionToolbarImpl toolbar2 = (ActionToolbarImpl)component;
            JComponent targetComponent = toolbar2.getTargetComponent();
            this.myProperties.add(new PropertyBean("Target component", (Object)String.valueOf(targetComponent), true));
        }
    }

    private void addToolWindowInfo(Object component) {
        ToolWindowImpl window;
        if (component instanceof StripeButton) {
            StripeButton stripeButton = (StripeButton)component;
            window = stripeButton.toolWindow;
        } else if (component instanceof SquareStripeButton) {
            SquareStripeButton stripeButton = (SquareStripeButton)component;
            window = stripeButton.getToolWindow();
            this.myProperties.add(new PropertyBean("Stripe Button Icon", (Object)stripeButton.getIcon()));
        } else {
            return;
        }
        this.myProperties.add(new PropertyBean("Tool Window ID", (Object)window.getId(), true));
        this.myProperties.add(new PropertyBean("Tool Window Icon", (Object)window.getIcon()));
        ToolWindowFactory contentFactory = (ToolWindowFactory)ReflectionUtil.getField(ToolWindowImpl.class, (Object)window, ToolWindowFactory.class, (String)"contentFactory");
        if (contentFactory != null) {
            this.myProperties.add(new PropertyBean("Tool Window Factory", (Object)contentFactory));
        } else {
            ToolWindowEP ep = (ToolWindowEP)ToolWindowEP.EP_NAME.findFirstSafe(it -> Objects.equals(it.id, window.getId()));
            if (ep != null && ep.factoryClass != null) {
                this.myProperties.add(new PropertyBean("Tool Window Factory", (Object)ep.factoryClass));
            }
        }
    }

    private void addLayoutProperties(@NotNull Container component) {
        LayoutManager layout;
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(15);
        }
        if ((layout = component.getLayout()) instanceof GridBagLayout) {
            GridBagLayout bagLayout = (GridBagLayout)layout;
            GridBagConstraints defaultConstraints = (GridBagConstraints)ReflectionUtil.getField(GridBagLayout.class, (Object)bagLayout, GridBagConstraints.class, (String)"defaultConstraints");
            this.myProperties.add(new PropertyBean("GridBagLayout constraints", (Object)String.format("defaultConstraints - %s", ComponentPropertiesCollector.toString(defaultConstraints))));
            if (bagLayout.columnWidths != null) {
                this.addSubValue("columnWidths", Arrays.toString(bagLayout.columnWidths));
            }
            if (bagLayout.rowHeights != null) {
                this.addSubValue("rowHeights", Arrays.toString(bagLayout.rowHeights));
            }
            if (bagLayout.columnWeights != null) {
                this.addSubValue("columnWeights", Arrays.toString(bagLayout.columnWeights));
            }
            if (bagLayout.rowWeights != null) {
                this.addSubValue("rowWeights", Arrays.toString(bagLayout.rowWeights));
            }
            for (Component child : component.getComponents()) {
                this.addSubValue(UiInspectorUtil.getComponentName((Component)child), ComponentPropertiesCollector.toString(bagLayout.getConstraints(child)));
            }
        } else if (layout instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layout;
            this.myProperties.add(new PropertyBean("BorderLayout constraints", (Object)String.format("hgap - %s, vgap - %s", borderLayout.getHgap(), borderLayout.getVgap())));
            for (Component child : component.getComponents()) {
                this.addSubValue(UiInspectorUtil.getComponentName((Component)child), borderLayout.getConstraints(child));
            }
        } else if (layout instanceof CardLayout) {
            CardLayout cardLayout = (CardLayout)layout;
            Integer currentCard = (Integer)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, null, (String)"currentCard");
            Vector vector = (Vector)ReflectionUtil.getField(CardLayout.class, (Object)cardLayout, Vector.class, (String)"vector");
            String cardDescription = "???";
            if (vector != null && currentCard != null) {
                Object card = vector.get(currentCard);
                cardDescription = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
            }
            this.myProperties.add(new PropertyBean("CardLayout constraints", (Object)String.format("card - %s, hgap - %s, vgap - %s", cardDescription, cardLayout.getHgap(), cardLayout.getVgap())));
            if (vector != null) {
                for (Object card : vector) {
                    String cardName = (String)ReflectionUtil.getField(card.getClass(), card, String.class, (String)"name");
                    Component child = (Component)ReflectionUtil.getField(card.getClass(), card, Component.class, (String)"comp");
                    if (child == null) continue;
                    this.addSubValue(UiInspectorUtil.getComponentName((Component)child), cardName);
                }
            }
        } else if (layout instanceof MigLayout) {
            MigLayout migLayout = (MigLayout)layout;
            Object constraints = migLayout.getLayoutConstraints();
            if (constraints instanceof LC) {
                this.addMigLayoutLayoutConstraints((LC)constraints);
            } else {
                this.myProperties.add(new PropertyBean("MigLayout layout constraints", constraints));
            }
            constraints = migLayout.getColumnConstraints();
            if (constraints instanceof AC) {
                this.addMigLayoutAxisConstraints("MigLayout column constraints", (AC)constraints);
            } else {
                this.myProperties.add(new PropertyBean("MigLayout column constraints", constraints));
            }
            constraints = migLayout.getRowConstraints();
            if (constraints instanceof AC) {
                this.addMigLayoutAxisConstraints("MigLayout row constraints", (AC)constraints);
            } else {
                this.myProperties.add(new PropertyBean("MigLayout row constraints", constraints));
            }
            for (Component child : component.getComponents()) {
                this.addSubValue(UiInspectorUtil.getComponentName((Component)child), migLayout.getComponentConstraints(child));
            }
        } else if (layout instanceof com.intellij.ui.layout.migLayout.patched.MigLayout) {
            com.intellij.ui.layout.migLayout.patched.MigLayout migLayout = (com.intellij.ui.layout.migLayout.patched.MigLayout)layout;
            this.addMigLayoutLayoutConstraints(migLayout.getLayoutConstraints());
            this.addMigLayoutAxisConstraints("MigLayout column constraints", migLayout.getColumnConstraints());
            this.addMigLayoutAxisConstraints("MigLayout row constraints", migLayout.getRowConstraints());
        } else if (layout instanceof GridLayout) {
            Grid grid = ((GridLayout)layout).getRootGrid();
            this.myProperties.add(new PropertyBean("GridLayout", null));
            this.addSubValue("resizableColumns", grid.getResizableColumns());
            this.addSubValue("columnsGaps", grid.getColumnsGaps());
            this.addSubValue("resizableRows", grid.getResizableRows());
            this.addSubValue("rowsGaps", grid.getRowsGaps());
        }
    }

    private void addMigLayoutLayoutConstraints(LC lc) {
        this.myProperties.add(new PropertyBean("MigLayout layout constraints", (Object)ComponentPropertiesCollector.lcConstraintToString(lc)));
        Object[] insets = lc.getInsets();
        if (insets != null) {
            List insetsText = ContainerUtil.map((Object[])insets, i -> ComponentPropertiesCollector.unitValueToString(i));
            this.myProperties.add(new PropertyBean("  lc.insets", (Object)("[" + StringUtil.join((Collection)insetsText, (String)", ") + "]")));
        }
        UnitValue alignX = lc.getAlignX();
        UnitValue alignY = lc.getAlignY();
        if (alignX != null || alignY != null) {
            this.myProperties.add(new PropertyBean("  lc.align", (Object)("x: " + ComponentPropertiesCollector.unitValueToString(alignX) + "; y: " + ComponentPropertiesCollector.unitValueToString(alignY))));
        }
        BoundSize width = lc.getWidth();
        BoundSize height = lc.getHeight();
        if (width != BoundSize.NULL_SIZE || height != BoundSize.NULL_SIZE) {
            this.myProperties.add(new PropertyBean("  lc.size", (Object)("width: " + ComponentPropertiesCollector.boundSizeToString(width) + "; height: " + ComponentPropertiesCollector.boundSizeToString(height))));
        }
        BoundSize gridX = lc.getGridGapX();
        BoundSize gridY = lc.getGridGapY();
        if (gridX != null || gridY != null) {
            this.myProperties.add(new PropertyBean("  lc.gridGap", (Object)("x: " + ComponentPropertiesCollector.boundSizeToString(gridX) + "; y: " + ComponentPropertiesCollector.boundSizeToString(gridY))));
        }
        boolean fillX = lc.isFillX();
        boolean fillY = lc.isFillY();
        if (fillX || fillY) {
            this.myProperties.add(new PropertyBean("  lc.fill", (Object)("x: " + fillX + "; y: " + fillY)));
        }
        BoundSize packWidth = lc.getPackWidth();
        BoundSize packHeight = lc.getPackHeight();
        if (packWidth != BoundSize.NULL_SIZE || packHeight != BoundSize.NULL_SIZE) {
            this.myProperties.add(new PropertyBean("  lc.pack", (Object)("width: " + String.valueOf(packWidth) + "; height: " + String.valueOf(packHeight) + "; widthAlign: " + lc.getPackWidthAlign() + "; heightAlign: " + lc.getPackHeightAlign())));
        }
    }

    private static String lcConstraintToString(LC constraint) {
        return "isFlowX=" + constraint.isFlowX() + " leftToRight=" + constraint.getLeftToRight() + " noGrid=" + constraint.isNoGrid() + " hideMode=" + constraint.getHideMode() + " visualPadding=" + constraint.isVisualPadding() + " topToBottom=" + constraint.isTopToBottom() + " noCache=" + constraint.isNoCache();
    }

    private void addMigLayoutAxisConstraints(String title, AC ac) {
        this.myProperties.add(new PropertyBean(title, (Object)ac));
        DimConstraint[] constraints = ac.getConstaints();
        for (int i = 0; i < constraints.length; ++i) {
            this.addDimConstraintProperties("  [" + i + "]", constraints[i]);
        }
    }

    private void addMigLayoutComponentConstraints(CC cc) {
        this.myProperties.add(new PropertyBean("MigLayout component constraints", (Object)ComponentPropertiesCollector.componentConstraintsToString(cc)));
        DimConstraint horizontal = cc.getHorizontal();
        this.addDimConstraintProperties("  cc.horizontal", horizontal);
        DimConstraint vertical = cc.getVertical();
        this.addDimConstraintProperties("  cc.vertical", vertical);
    }

    private void addDimConstraintProperties(String name, DimConstraint constraint) {
        BoundSize gapAfter;
        BoundSize gapBefore;
        UnitValue align;
        this.myProperties.add(new PropertyBean(name, (Object)ComponentPropertiesCollector.dimConstraintToString(constraint)));
        BoundSize size = constraint.getSize();
        if (size != null) {
            this.addSubValue(name + ".size", ComponentPropertiesCollector.boundSizeToString(size));
        }
        if ((align = constraint.getAlign()) != null) {
            this.addSubValue(name + ".align", ComponentPropertiesCollector.unitValueToString(align));
        }
        if ((gapBefore = constraint.getGapBefore()) != null && !gapBefore.isUnset()) {
            this.addSubValue(name + ".gapBefore", ComponentPropertiesCollector.boundSizeToString(gapBefore));
        }
        if ((gapAfter = constraint.getGapAfter()) != null && !gapAfter.isUnset()) {
            this.addSubValue(name + ".gapAfter", ComponentPropertiesCollector.boundSizeToString(gapAfter));
        }
    }

    private void addGridLayoutComponentConstraints(Constraints constraints) {
        Grid grid = constraints.getGrid();
        this.myProperties.add(new PropertyBean("GridLayout component constraints", null));
        this.addSubValue("grid", grid.getClass().getSimpleName() + "@" + System.identityHashCode(grid));
        this.addSubValue("Cell coordinate", new Point(constraints.getX(), constraints.getY()));
        this.addSubValue("Cell size", new Dimension(constraints.getWidth(), constraints.getHeight()));
        this.addSubValue("gaps", constraints.getGaps());
        this.addSubValue("visualPaddings", constraints.getVisualPaddings());
        this.addSubValue("horizontalAlign", constraints.getHorizontalAlign().name());
        this.addSubValue("verticalAlign", constraints.getVerticalAlign().name());
        this.addSubValue("baselineAlign", constraints.getBaselineAlign());
    }

    private void addSubValue(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(16);
        }
        this.myProperties.add(new PropertyBean("  " + name, value));
    }

    private static String componentConstraintsToString(CC cc) {
        CC newCC = new CC();
        StringBuilder stringBuilder = new StringBuilder();
        if (cc.getSkip() != newCC.getSkip()) {
            stringBuilder.append(" skip=").append(cc.getSkip());
        }
        if (cc.getSpanX() != newCC.getSpanX()) {
            stringBuilder.append(" spanX=").append(cc.getSpanX() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanX()));
        }
        if (cc.getSpanY() != newCC.getSpanY()) {
            stringBuilder.append(" spanY=").append(cc.getSpanY() == 2097051 ? "INF" : Integer.valueOf(cc.getSpanY()));
        }
        if (cc.getPushX() != null) {
            stringBuilder.append(" pushX=").append(cc.getPushX());
        }
        if (cc.getPushY() != null) {
            stringBuilder.append(" pushY=").append(cc.getPushY());
        }
        if (cc.getSplit() != newCC.getSplit()) {
            stringBuilder.append(" split=").append(cc.getSplit());
        }
        if (cc.isWrap()) {
            stringBuilder.append(" wrap=");
            if (cc.getWrapGapSize() != null) {
                stringBuilder.append(cc.getWrapGapSize());
            } else {
                stringBuilder.append("true");
            }
        }
        if (cc.isNewline()) {
            stringBuilder.append(" newline=");
            if (cc.getNewlineGapSize() != null) {
                stringBuilder.append(cc.getNewlineGapSize());
            } else {
                stringBuilder.append("true");
            }
        }
        if (cc.getHideMode() != newCC.getHideMode()) {
            stringBuilder.append(" hidemode=").append(cc.getHideMode());
        }
        return stringBuilder.toString().trim();
    }

    private static String dimConstraintToString(DimConstraint constraint) {
        StringBuilder stringBuilder = new StringBuilder();
        DimConstraint newConstraint = new DimConstraint();
        if (!Comparing.equal((Object)constraint.getGrow(), (Object)newConstraint.getGrow())) {
            stringBuilder.append(" grow=").append(constraint.getGrow());
        }
        if (constraint.getGrowPriority() != newConstraint.getGrowPriority()) {
            stringBuilder.append(" growPrio=").append(constraint.getGrowPriority());
        }
        if (!Comparing.equal((Object)constraint.getShrink(), (Object)newConstraint.getShrink())) {
            stringBuilder.append(" shrink=").append(constraint.getShrink());
        }
        if (constraint.getShrinkPriority() != newConstraint.getShrinkPriority()) {
            stringBuilder.append(" shrinkPrio=").append(constraint.getShrinkPriority());
        }
        if (constraint.isFill() != newConstraint.isFill()) {
            stringBuilder.append(" fill=").append(constraint.isFill());
        }
        if (constraint.isNoGrid() != newConstraint.isNoGrid()) {
            stringBuilder.append(" noGrid=").append(constraint.isNoGrid());
        }
        if (!Objects.equals(constraint.getSizeGroup(), newConstraint.getSizeGroup())) {
            stringBuilder.append(" sizeGroup=").append(constraint.getSizeGroup());
        }
        if (!Objects.equals(constraint.getEndGroup(), newConstraint.getEndGroup())) {
            stringBuilder.append(" endGroup=").append(constraint.getEndGroup());
        }
        return stringBuilder.toString();
    }

    private static String unitValueToString(@Nullable UnitValue unitValue) {
        if (unitValue == null) {
            return "null";
        }
        if (unitValue.getOperation() == 100) {
            StringBuilder result2 = new StringBuilder();
            result2.append(unitValue.getValue());
            if (unitValue.getUnitString() != null) {
                result2.append(unitValue.getUnitString());
            } else {
                int unit = unitValue.getUnit();
                if (unit >= 0) {
                    String unitName = (String)((Map)MIG_LAYOUT_UNIT_MAP.get()).get(unit);
                    if (unitName == null) {
                        return unitValue.toString();
                    }
                    result2.append(unitName);
                }
            }
            if (unitValue.isHorizontal()) {
                result2.append("H");
            } else {
                result2.append("V");
            }
            return result2.toString();
        }
        return unitValue.toString();
    }

    private static String boundSizeToString(BoundSize boundSize) {
        StringBuilder result2 = new StringBuilder("BoundSize{ ");
        if (boundSize.getMin() != null) {
            result2.append("min=").append(ComponentPropertiesCollector.unitValueToString(boundSize.getMin())).append(" ");
        }
        if (boundSize.getPreferred() != null) {
            result2.append("pref=").append(ComponentPropertiesCollector.unitValueToString(boundSize.getPreferred())).append(" ");
        }
        if (boundSize.getMax() != null) {
            result2.append("max=").append(ComponentPropertiesCollector.unitValueToString(boundSize.getMax())).append(" ");
        }
        if (boundSize.getGapPush()) {
            result2.append("push ");
        }
        result2.append("}");
        return result2.toString();
    }

    @NotNull
    private static String toString(@Nullable GridBagConstraints constraints) {
        if (constraints == null) {
            return "null";
        }
        MoreObjects.ToStringHelper h = MoreObjects.toStringHelper((String)"");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "gridx");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "gridy");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "gridwidth");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "gridheight");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "weightx");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "weighty");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "anchor");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "fill");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "insets");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "ipadx");
        ComponentPropertiesCollector.appendFieldValue(h, constraints, "ipady");
        String string = h.toString();
        if (string == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static void appendFieldValue(@NotNull MoreObjects.ToStringHelper h, @NotNull GridBagConstraints constraints, @NotNull String field) {
        Object defaultValue;
        Object value;
        if (h == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(18);
        }
        if (constraints == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(19);
        }
        if (field == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(20);
        }
        if (!Comparing.equal((Object)(value = ReflectionUtil.getField(GridBagConstraints.class, (Object)constraints, null, (String)field)), (Object)(defaultValue = ReflectionUtil.getField(GridBagConstraints.class, (Object)new GridBagConstraints(), null, (String)field)))) {
            h.add(field, value);
        }
    }

    @Nullable
    private static AnAction getAction(Component c) {
        return (AnAction)ClientProperty.get((Component)c, CustomComponentAction.ACTION_KEY);
    }

    @NotNull
    private static @NotNull Pair<@NotNull String, @Nullable String> getAddedAtStacktrace(@NotNull Component component) {
        int first;
        String text2;
        if (component == null) {
            ComponentPropertiesCollector.$$$reportNull$$$0(21);
        }
        Throwable throwable = null;
        String propertyName = "added-at";
        if (component instanceof JComponent) {
            JComponent c = (JComponent)component;
            throwable = (Throwable)c.getClientProperty(DslComponentPropertyInternal.CREATION_STACKTRACE);
        }
        if (throwable == null) {
            throwable = (Throwable)ClientProperty.get((Component)component, (Key)UiInspectorUtil.ADDED_AT_STACKTRACE);
            if (throwable == null) {
                return new Pair((Object)propertyName, null);
            }
            text2 = ExceptionUtil.getThrowableText((Throwable)throwable);
            first = text2.indexOf("at com.intellij", text2.indexOf("at java."));
        } else {
            propertyName = "added-at (UI DSL)";
            text2 = ExceptionUtil.getThrowableText(throwable);
            first = text2.indexOf("at com.intellij");
        }
        int last = text2.indexOf("at java.awt.EventQueue");
        if (last == -1) {
            last = text2.length();
        }
        return new Pair((Object)propertyName, last > first && first > 0 ? text2.substring(first, last).trim() : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/ComponentPropertiesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodList";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNames";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/ComponentPropertiesCollector";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAccessibleProperties";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addProperties";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addPropertiesFromMethodNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addLayoutProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSubValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendFieldValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAddedAtStacktrace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 17 -> new IllegalStateException(string);
        };
    }
}

