/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ActionToolbar {
    public static final String ACTION_TOOLBAR_PROPERTY_KEY = "ACTION_TOOLBAR";
    public static final int NOWRAP_LAYOUT_POLICY = 0;
    public static final int WRAP_LAYOUT_POLICY = 1;
    public static final int AUTO_LAYOUT_POLICY = 2;
    public static final String ACTION_BUTTON_CONSTRAINT = "Constraint.ActionButton";
    public static final String CUSTOM_COMPONENT_CONSTRAINT = "Constraint.CustomComponent";
    public static final String SEPARATOR_CONSTRAINT = "Constraint.Separator";
    public static final String SECONDARY_ACTION_CONSTRAINT = "Constraint.SecondaryAction";
    public static final String SECONDARY_ACTION_PROPERTY = "ClientProperty.SecondaryAction";
    @NotNull
    public static final Dimension DEFAULT_MINIMUM_BUTTON_SIZE = JBUI.size((int)22, (int)22);
    @NotNull
    public static final Dimension NAVBAR_MINIMUM_BUTTON_SIZE = JBUI.size((int)20, (int)20);

    public static Dimension experimentalToolbarMinimumButtonSize() {
        return JBUI.CurrentTheme.Toolbar.experimentalToolbarButtonSize();
    }

    @NotNull
    public JComponent getComponent();

    @NotNull
    public String getPlace();

    @Deprecated(since="2024.1", forRemoval=true)
    default public void setLayoutPolicy(@LayoutPolicy int layoutPolicy) {
    }

    @NotNull
    public ToolbarLayoutStrategy getLayoutStrategy();

    public void setLayoutStrategy(@NotNull ToolbarLayoutStrategy var1);

    @Deprecated(since="2024.1", forRemoval=true)
    default public void adjustTheSameSize(boolean value) {
    }

    public void setMinimumButtonSize(@NotNull Dimension var1);

    @NotNull
    public Dimension getMinimumButtonSize();

    public void setOrientation(int var1);

    public int getOrientation();

    public int getMaxButtonHeight();

    @Deprecated
    public void updateActionsImmediately();

    @RequiresEdt
    @NotNull
    public Future<?> updateActionsAsync();

    public boolean hasVisibleActions();

    @ApiStatus.Internal
    @Nullable
    public JComponent getTargetComponent();

    public void setTargetComponent(@Nullable JComponent var1);

    public void setReservePlaceAutoPopupIcon(boolean var1);

    public boolean isReservePlaceAutoPopupIcon();

    public void setSecondaryActionsTooltip(@NlsContexts.Tooltip @NotNull String var1);

    public void setSecondaryActionsShortcut(@NotNull String var1);

    public void setSecondaryActionsIcon(Icon var1);

    public void setSecondaryActionsIcon(Icon var1, boolean var2);

    public void setLayoutSecondaryActions(boolean var1);

    @NotNull
    public ActionGroup getActionGroup();

    @NotNull
    public List<AnAction> getActions();

    public void setMiniMode(boolean var1);

    @NotNull
    public DataContext getToolbarDataContext();

    default public void setShowSeparatorTitles(boolean showSeparatorTitles) {
    }

    default public void addListener(@NotNull ActionToolbarListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ActionToolbar.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ActionToolbar.$$$reportNull$$$0(1);
        }
    }

    @Nullable
    public static ActionToolbar findToolbarBy(@Nullable Component component) {
        return (ActionToolbar)ComponentUtil.getStrictParentOfType(ActionToolbar.class, (Component)component);
    }

    @NotNull
    public static DataContext getDataContextFor(@Nullable Component component) {
        ActionToolbar toolbar2 = ActionToolbar.findToolbarBy(component);
        DataContext dataContext = toolbar2 != null ? toolbar2.getToolbarDataContext() : DataManager.getInstance().getDataContext(component);
        if (dataContext == null) {
            ActionToolbar.$$$reportNull$$$0(2);
        }
        return dataContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ActionToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ActionToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static @interface LayoutPolicy {
    }
}

