/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.NoWrapLayoutStrategy;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/actionSystem/toolbarLayout/WrapLayoutStrategy;", "Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;", "myAdjustTheSameSize", "", "<init>", "(Z)V", "fallbackDelegate", "Lcom/intellij/openapi/actionSystem/toolbarLayout/NoWrapLayoutStrategy;", "calculateBounds", "", "Ljava/awt/Rectangle;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "calcPreferredSize", "Ljava/awt/Dimension;", "calcMinimumSize", "doCalculateBounds", "size2Fit", "getMaxRowWidth", "", "parent", "Ljava/awt/Container;", "widthToFit", "maxWidth", "intellij.platform.editor.ui"})
@SourceDebugExtension(value={"SMAP\nWrapLayoutStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrapLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/WrapLayoutStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n2829#2,7:171\n1#3:178\n*S KotlinDebug\n*F\n+ 1 WrapLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/WrapLayoutStrategy\n*L\n35#1:171,7\n*E\n"})
public final class WrapLayoutStrategy
implements ToolbarLayoutStrategy {
    private final boolean myAdjustTheSameSize;
    @NotNull
    private final NoWrapLayoutStrategy fallbackDelegate;

    public WrapLayoutStrategy(boolean myAdjustTheSameSize) {
        this.myAdjustTheSameSize = myAdjustTheSameSize;
        this.fallbackDelegate = new NoWrapLayoutStrategy(this.myAdjustTheSameSize);
    }

    @Override
    @NotNull
    public List<Rectangle> calculateBounds(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        if (component.getWidth() == 0 || component.getHeight() == 0) {
            return this.fallbackDelegate.calculateBounds(toolbar2);
        }
        Dimension dimension = component.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return this.doCalculateBounds(dimension, toolbar2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension calcPreferredSize(@NotNull ActionToolbar toolbar2) {
        Dimension dimension;
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        if (component.getWidth() == 0) {
            return this.fallbackDelegate.calcPreferredSize(toolbar2);
        }
        List<Rectangle> bounds = this.doCalculateBounds(new Dimension(component.getWidth(), Integer.MAX_VALUE), toolbar2);
        if (bounds.isEmpty()) {
            dimension = new Dimension(0, 0);
        } else {
            Iterable $this$reduce$iv = bounds;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void rect;
                Rectangle rectangle = (Rectangle)iterator$iv.next();
                Rectangle acc = (Rectangle)accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)acc.union((Rectangle)rect), (String)"union(...)");
            }
            dimension = ((Rectangle)accumulator$iv).getSize();
        }
        Dimension dimension2 = dimension;
        JBInsets.addTo((Dimension)dimension2, (Insets)toolbar2.getComponent().getInsets());
        Intrinsics.checkNotNull((Object)dimension2);
        return dimension2;
    }

    @Override
    @NotNull
    public Dimension calcMinimumSize(@NotNull ActionToolbar toolbar2) {
        Intrinsics.checkNotNullParameter((Object)toolbar2, (String)"toolbar");
        JBDimension jBDimension = JBUI.emptySize();
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
        return (Dimension)jBDimension;
    }

    private final List<Rectangle> doCalculateBounds(Dimension size2Fit, ActionToolbar toolbar2) {
        JComponent jComponent = toolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        int componentsCount = component.getComponentCount();
        Insets insets = component.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        int widthToFit = size2Fit.width - insets2.left - insets2.right;
        int heightToFit = size2Fit.height - insets2.top - insets2.bottom;
        Dimension dimension = toolbar2.getMinimumButtonSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumButtonSize(...)");
        Dimension minimumButtonSize = dimension;
        int orientation = toolbar2.getOrientation();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(componentsCount);
        int n = 0;
        while (n < componentsCount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Rectangle> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new Rectangle());
        }
        List res = arrayList;
        if (this.myAdjustTheSameSize) {
            int maxWidth = ToolbarLayoutUtilKt.maxComponentPreferredWidth(component);
            int maxHeight = ToolbarLayoutUtilKt.maxComponentPreferredHeight(component);
            xOffset = 0;
            yOffset = 0;
            if (orientation == 0) {
                maxRowWidth = this.getMaxRowWidth(component, widthToFit, maxWidth);
                for (int i = 0; i < componentsCount; ++i) {
                    if (xOffset + maxWidth > maxRowWidth) {
                        xOffset = 0;
                        yOffset += maxHeight;
                    }
                    Rectangle each = (Rectangle)res.get(i);
                    each.setBounds(insets2.left + xOffset, insets2.top + yOffset, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int i = componentsCount * minimumButtonSize.height / 3;
                maxRowHeight = Math.max(heightToFit, i);
                for (i = 0; i < componentsCount; ++i) {
                    if (yOffset + maxHeight > maxRowHeight) {
                        yOffset = 0;
                        xOffset += maxWidth;
                    }
                    Rectangle each = (Rectangle)res.get(i);
                    each.setBounds(insets2.left + xOffset, insets2.top + yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (orientation == 0) {
            int rowHeight = 0;
            Dimension[] dims = new Dimension[componentsCount];
            for (i = 0; i < componentsCount; ++i) {
                dims[i] = ToolbarLayoutUtilKt.getChildPreferredSize(component, i);
                Dimension dimension2 = dims[i];
                Intrinsics.checkNotNull((Object)dimension2);
                int height = dimension2.height;
                rowHeight = Math.max(rowHeight, height);
            }
            xOffset = 0;
            yOffset = 0;
            maxRowWidth = this.getMaxRowWidth(component, widthToFit, minimumButtonSize.width);
            for (int i = 0; i < componentsCount; ++i) {
                Dimension d;
                Dimension dimension3 = d = dims[i];
                Intrinsics.checkNotNull((Object)dimension3);
                if (xOffset + dimension3.width > maxRowWidth) {
                    xOffset = 0;
                    yOffset += rowHeight;
                }
                Rectangle each = (Rectangle)res.get(i);
                each.setBounds(insets2.left + xOffset, insets2.top + yOffset + (rowHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int rowWidth = 0;
            Dimension[] dims = new Dimension[componentsCount];
            for (i = 0; i < componentsCount; ++i) {
                dims[i] = ToolbarLayoutUtilKt.getChildPreferredSize(component, i);
                Dimension dimension4 = dims[i];
                Intrinsics.checkNotNull((Object)dimension4);
                int width = dimension4.width;
                rowWidth = Math.max(rowWidth, width);
            }
            xOffset = 0;
            yOffset = 0;
            int i = componentsCount * minimumButtonSize.height / 3;
            maxRowHeight = Math.max(heightToFit, i);
            for (i = 0; i < componentsCount; ++i) {
                Dimension d;
                Dimension dimension5 = d = dims[i];
                Intrinsics.checkNotNull((Object)dimension5);
                if (yOffset + dimension5.height > maxRowHeight) {
                    yOffset = 0;
                    xOffset += rowWidth;
                }
                Rectangle each = (Rectangle)res.get(i);
                each.setBounds(insets2.left + xOffset + (rowWidth - d.width) / 2, insets2.top + yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
        return res;
    }

    private final int getMaxRowWidth(Container parent, int widthToFit, int maxWidth) {
        int componentCount = parent.getComponentCount();
        int maxRowWidth = Math.max(widthToFit, componentCount * maxWidth / 3);
        for (int i = 0; i < componentCount; ++i) {
            Component component;
            Intrinsics.checkNotNullExpressionValue((Object)parent.getComponent(i), (String)"getComponent(...)");
            if (!(component instanceof JComponent) || !Intrinsics.areEqual((Object)((JComponent)component).getClientProperty("RIGHT_ALIGN"), (Object)true)) continue;
            maxRowWidth -= ToolbarLayoutUtilKt.getChildPreferredSize((Container)parent, (int)i).width;
        }
        return maxRowWidth;
    }
}

