/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.util.ArrayUtil;
import com.jetbrains.JBR;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EditorFontCacheImpl
extends EditorFontCache {
    private static final Logger LOG = Logger.getInstance(EditorFontCacheImpl.class);
    private static final Map<TextAttribute, Integer> LIGATURES_ATTRIBUTES = Map.of(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
    @NotNull
    private final Map<EditorFontType, Font> fonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Font getFont(@Nullable EditorFontType key) {
        Map<EditorFontType, Font> map = this.fonts;
        // MONITORENTER : map
        if (this.fonts.isEmpty()) {
            this.initFonts();
        }
        EditorFontType fontType = Objects.requireNonNullElse(key, EditorFontType.PLAIN);
        Font font = this.fonts.get((Object)fontType);
        assert (font != null) : "Font " + String.valueOf((Object)fontType) + " not found.";
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getPresentationMode()) {
            Font font2 = font.deriveFont(UISettingsUtils.with(uiSettings).getPresentationModeFontSize());
            // MONITOREXIT : map
            if (font2 != null) return font2;
            EditorFontCacheImpl.$$$reportNull$$$0(0);
            return font2;
        }
        Font font3 = font;
        // MONITOREXIT : map
        if (font3 != null) return font3;
        EditorFontCacheImpl.$$$reportNull$$$0(1);
        return font3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<EditorFontType, Font> map = this.fonts;
        synchronized (map) {
            this.fonts.clear();
        }
    }

    protected EditorColorsScheme getFontCacheScheme() {
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    private void initFonts() {
        EditorColorsScheme scheme = this.getFontCacheScheme();
        FontPreferences preferences = scheme.getFontPreferences();
        String editorFontName = preferences.getFontFamily();
        float editorFontSize = scheme.getEditorFontSize2D();
        String fallbackName = EditorFontCacheImpl.getFallbackName(editorFontName);
        if (fallbackName != null) {
            editorFontName = fallbackName;
        }
        if (LOG.isDebugEnabled()) {
            String schemeName;
            try {
                schemeName = scheme.getName();
            }
            catch (Throwable th) {
                LOG.warn(th);
                schemeName = "unknown(th)";
            }
            LOG.debug(String.format("Initializing fonts: scheme=%s, delegating=%b, fontName=%s, fontSize=%.2f", schemeName, preferences instanceof DelegatingFontPreferences, editorFontName, Float.valueOf(editorFontSize)));
        }
        this.setFont(EditorFontType.PLAIN, editorFontName, 0, editorFontSize, preferences);
        this.setFont(EditorFontType.BOLD, editorFontName, 1, editorFontSize, preferences);
        this.setFont(EditorFontType.ITALIC, editorFontName, 2, editorFontSize, preferences);
        this.setFont(EditorFontType.BOLD_ITALIC, editorFontName, 3, editorFontSize, preferences);
        FontPreferences consolePreferences = scheme.getConsoleFontPreferences();
        String consoleFontName = scheme.getConsoleFontName();
        float consoleFontSize = scheme.getConsoleFontSize2D();
        this.setFont(EditorFontType.CONSOLE_PLAIN, consoleFontName, 0, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD, consoleFontName, 1, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_ITALIC, consoleFontName, 2, consoleFontSize, consolePreferences);
        this.setFont(EditorFontType.CONSOLE_BOLD_ITALIC, consoleFontName, 3, consoleFontSize, consolePreferences);
    }

    private void setFont(EditorFontType fontType, String familyName, int style, float fontSize, FontPreferences fontPreferences) {
        Font editorFont = FontFamilyService.getFont(familyName, fontPreferences.getRegularSubFamily(), fontPreferences.getBoldSubFamily(), style, fontSize);
        editorFont = EditorFontCacheImpl.deriveFontWithLigatures(editorFont, fontPreferences.useLigatures());
        if (!fontPreferences.getCharacterVariants().isEmpty()) {
            editorFont = JBR.getFontExtensions().deriveFontWithFeatures(editorFont, ArrayUtil.toStringArray(fontPreferences.getCharacterVariants()));
        }
        this.fonts.put(fontType, editorFont);
    }

    @Nullable
    private static String getFallbackName(@NotNull String fontName) {
        Font plainFont;
        if (fontName == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(2);
        }
        if ((plainFont = new Font(fontName, 0, 12)).getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            return AppEditorFontOptions.getInstance().getFontPreferences().getFontFamily();
        }
        return null;
    }

    @NotNull
    public static Font deriveFontWithLigatures(@NotNull Font font, boolean enableLigatures) {
        if (font == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(3);
        }
        Font font2 = enableLigatures ? font.deriveFont(LIGATURES_ATTRIBUTES) : font;
        if (font2 == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(4);
        }
        return font2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveFontWithLigatures";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deriveFontWithLigatures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

