/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RemoteServerListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "RemoteServers";
    private final RemoteServersManager myServersManager;
    private RemoteServer<?> myLastSelectedServer;
    @NlsSafe
    private final String myInitialSelectedName;
    private final List<ServerType<?>> myDisplayedServerTypes;
    private boolean isTreeInitialized;

    private RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @NotNull ServerType<?> type, @Nullable @NlsSafe String initialSelectedName) {
        if (manager == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(0);
        }
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(1);
        }
        this(manager, Collections.singletonList(type), initialSelectedName);
    }

    protected RemoteServerListConfigurable(@NotNull RemoteServersManager manager, @NotNull List<ServerType<?>> displayedServerTypes, @Nullable String initialSelectedName) {
        if (manager == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(2);
        }
        if (displayedServerTypes == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(3);
        }
        this.myServersManager = manager;
        this.myDisplayedServerTypes = displayedServerTypes;
        this.myToReInitWholePanel = true;
        this.myInitialSelectedName = initialSelectedName;
    }

    @NotNull
    public JComponent createComponent() {
        if (!this.isTreeInitialized) {
            this.initTree();
            this.isTreeInitialized = true;
        }
        JComponent jComponent = super.createComponent();
        if (jComponent == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Nullable
    private ServerType<?> getSingleServerType() {
        List<ServerType<?>> serverTypes = this.getDisplayedServerTypes();
        return serverTypes.size() == 1 ? serverTypes.get(0) : null;
    }

    @NotNull
    public List<ServerType<?>> getDisplayedServerTypes() {
        List<Object> list2 = this.myDisplayedServerTypes != null ? this.myDisplayedServerTypes : Collections.emptyList();
        if (list2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    protected String getEmptySelectionString() {
        String typeNames = StringUtil.join(this.getDisplayedServerTypes(), ServerType::getPresentableName, (String)", ");
        if (!typeNames.isEmpty()) {
            return CloudBundle.message("clouds.configure.empty.selection.string", typeNames);
        }
        return null;
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type) {
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(6);
        }
        return RemoteServerListConfigurable.createConfigurable(type, null);
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type, @Nullable String nameToSelect) {
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(7);
        }
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), type, nameToSelect);
    }

    @Nls
    public String getDisplayName() {
        ServerType<?> singleServerType = this.getSingleServerType();
        return singleServerType == null ? CloudBundle.message("configurable.display.name.clouds", new Object[0]) : singleServerType.getPresentableName();
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (RemoteServer<?> server : this.getServers()) {
            this.addServerNode(server, false);
        }
        super.reset();
        if (this.myInitialSelectedName != null) {
            this.selectNodeInTree(this.myInitialSelectedName);
        }
    }

    private @Unmodifiable @NotNull List<? extends RemoteServer<?>> getServers() {
        List list2 = ContainerUtil.filter(this.myServersManager.getServers(), s -> this.myDisplayedServerTypes.contains(s.getType()));
        if (list2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private MasterDetailsComponent.MyNode addServerNode(RemoteServer<?> server, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new SingleRemoteServerConfigurable(server, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true)).findAndSelectElement(option);
    }

    protected void initTree() {
        super.initTree();
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName());
    }

    protected void processRemovedItems() {
        HashSet<RemoteServer> servers = new HashSet<RemoteServer>();
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            servers.add((RemoteServer)configurable.getEditableObject());
        }
        ArrayList toDelete = new ArrayList();
        for (RemoteServer<Object> server : this.getServers()) {
            if (servers.contains(server)) continue;
            toDelete.add(server);
        }
        for (RemoteServer<Object> server : toDelete) {
            this.myServersManager.removeServer(server);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet servers = new HashSet(this.getServers());
        for (NamedConfigurable<RemoteServer<?>> configurable : this.getConfiguredServers()) {
            RemoteServer server = (RemoteServer)configurable.getEditableObject();
            server.setName(configurable.getDisplayName());
            if (servers.contains(server)) continue;
            this.myServersManager.addServer(server);
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        ServerType<?> singleServerType = this.getSingleServerType();
        if (singleServerType == null) {
            actions.add(new AddRemoteServerGroup());
        } else {
            actions.add((AnAction)((Object)new AddRemoteServerAction(singleServerType, IconUtil.getAddIcon())));
        }
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public String getHelpTopic() {
        ServerType<?> singleServerType;
        String result2 = super.getHelpTopic();
        if (result2 == null && (singleServerType = this.getSingleServerType()) != null) {
            result2 = singleServerType.getHelpTopic();
        }
        return result2 != null ? result2 : "reference.settings.clouds";
    }

    public void disposeUIResources() {
        Object selectedObject = this.getSelectedObject();
        this.myLastSelectedServer = selectedObject instanceof RemoteServer ? (RemoteServer)selectedObject : null;
        super.disposeUIResources();
    }

    @Nullable
    public RemoteServer<?> getLastSelectedServer() {
        return this.myLastSelectedServer;
    }

    protected void reInitWholePanelIfNeeded() {
        super.reInitWholePanelIfNeeded();
        if (this.myWholePanel.getBorder() == null) {
            this.myWholePanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        }
    }

    private List<NamedConfigurable<RemoteServer<?>>> getConfiguredServers() {
        ArrayList configurables = new ArrayList();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            configurables.add(node.getConfigurable());
        }
        return configurables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayedServerTypes";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedServerTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8 -> new IllegalStateException(string);
        };
    }

    private final class AddRemoteServerGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        private AddRemoteServerGroup() {
            super(CloudBundle.message("group.action.AddRemoteServerGroup.text", new Object[0]), "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)RemoteServerListConfigurable.this.myTree);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List<ServerType<?>> serverTypes = RemoteServerListConfigurable.this.getDisplayedServerTypes();
            AnAction[] actions = new AnAction[serverTypes.size()];
            for (int i = 0; i < serverTypes.size(); ++i) {
                actions[i] = new AddRemoteServerAction(serverTypes.get(i), serverTypes.get(i).getIcon());
            }
            if (actions == null) {
                AddRemoteServerGroup.$$$reportNull$$$0(0);
            }
            return actions;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerGroup", "getChildren"));
        }
    }

    private final class AddRemoteServerAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        private AddRemoteServerAction(ServerType<?> serverType, Icon icon) {
            super(serverType.getPresentableName(), null, icon);
            this.myServerType = serverType;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddRemoteServerAction.$$$reportNull$$$0(0);
            }
            String name = UniqueNameGenerator.generateUniqueName((String)this.myServerType.getPresentableName(), s -> {
                for (NamedConfigurable<RemoteServer<?>> configurable : RemoteServerListConfigurable.this.getConfiguredServers()) {
                    if (!configurable.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = RemoteServerListConfigurable.this.addServerNode(RemoteServerListConfigurable.this.myServersManager.createServer(this.myServerType, name), true);
            RemoteServerListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerAction", "actionPerformed"));
        }
    }
}

