/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.bazelEnvironment;

import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.bazelEnvironment.BazelLabel;
import org.jetbrains.intellij.bazelEnvironment.BazelRunfilesManifest;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u001b\u0010\u000e\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u0006R!\u0010\u0012\u001a\u00020\b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0011\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015R-\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u00188FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0011\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010 \u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/intellij/bazelEnvironment/BazelRunfiles;", "", "<init>", "()V", "isRunningFromBazel", "", "()Z", "getFileByLabel", "Ljava/nio/file/Path;", "label", "Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel;", "findRunfilesDirectoryUnderCommunityOrUltimate", "relativePath", "", "runfilesManifestOnly", "getRunfilesManifestOnly", "runfilesManifestOnly$delegate", "Lkotlin/Lazy;", "bazelJavaRunfilesPath", "getBazelJavaRunfilesPath$annotations", "getBazelJavaRunfilesPath", "()Ljava/nio/file/Path;", "bazelJavaRunfilesPath$delegate", "bazelTestRepoMapping", "", "Lorg/jetbrains/intellij/bazelEnvironment/BazelRunfiles$RepoMappingEntry;", "getBazelTestRepoMapping$annotations", "getBazelTestRepoMapping", "()Ljava/util/Map;", "bazelTestRepoMapping$delegate", "parseRepoEntry", "line", "RUNFILES_MANIFEST_ONLY_ENV_NAME", "JAVA_RUNFILES_ENV_NAME", "RepoMappingEntry", "intellij.platform.buildScripts.downloader"})
@SourceDebugExtension(value={"SMAP\nBazelRunfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelRunfiles.kt\norg/jetbrains/intellij/bazelEnvironment/BazelRunfiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,149:1\n1#2:150\n688#3:151\n719#3,4:152\n*S KotlinDebug\n*F\n+ 1 BazelRunfiles.kt\norg/jetbrains/intellij/bazelEnvironment/BazelRunfiles\n*L\n132#1:151\n132#1:152,4\n*E\n"})
public final class BazelRunfiles {
    @NotNull
    public static final BazelRunfiles INSTANCE = new BazelRunfiles();
    private static final boolean isRunningFromBazel = System.getenv("JAVA_RUNFILES") != null;
    @NotNull
    private static final Lazy runfilesManifestOnly$delegate = LazyKt.lazy(BazelRunfiles::runfilesManifestOnly_delegate$lambda$0);
    @NotNull
    private static final Lazy bazelJavaRunfilesPath$delegate = LazyKt.lazy(BazelRunfiles::bazelJavaRunfilesPath_delegate$lambda$0);
    @NotNull
    private static final Lazy bazelTestRepoMapping$delegate = LazyKt.lazy(BazelRunfiles::bazelTestRepoMapping_delegate$lambda$0);
    @NotNull
    private static final String RUNFILES_MANIFEST_ONLY_ENV_NAME = "RUNFILES_MANIFEST_ONLY";
    @NotNull
    private static final String JAVA_RUNFILES_ENV_NAME = "JAVA_RUNFILES";

    private BazelRunfiles() {
    }

    public final boolean isRunningFromBazel() {
        return isRunningFromBazel;
    }

    @JvmStatic
    @NotNull
    public static final Path getFileByLabel(@NotNull BazelLabel label) {
        Path resolved;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Map<String, RepoMappingEntry> map = BazelRunfiles.getBazelTestRepoMapping();
        RepoMappingEntry repoMappingEntry = map.get(label.getRepo());
        if (repoMappingEntry == null) {
            boolean bl = false;
            throw new IllegalStateException(("Unable to determine dependency path '" + label.getAsLabel() + "'").toString());
        }
        RepoMappingEntry repoEntry = repoMappingEntry;
        StringBuilder $this$getFileByLabel_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getFileByLabel_u24lambda_u241.append(repoEntry.getRunfilesRelativePath());
        if (((CharSequence)label.getPackageName()).length() > 0) {
            $this$getFileByLabel_u24lambda_u241.append('/');
            $this$getFileByLabel_u24lambda_u241.append(label.getPackageName());
        }
        $this$getFileByLabel_u24lambda_u241.append('/');
        $this$getFileByLabel_u24lambda_u241.append(label.getTarget());
        String manifestKey = stringBuilder.toString();
        if (INSTANCE.getRunfilesManifestOnly() || BazelRunfilesManifest.INSTANCE.getExists()) {
            resolved = Path.of(BazelRunfilesManifest.INSTANCE.get(manifestKey), new String[0]);
            Intrinsics.checkNotNull((Object)resolved);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(resolved, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                boolean $i$a$-check-BazelRunfiles$getFileByLabel$32 = false;
                String $i$a$-check-BazelRunfiles$getFileByLabel$32 = "Unable to find dependency (RUNFILES_MANIFEST_ONLY=1) '" + label.getAsLabel() + "' at " + resolved;
                throw new IllegalStateException($i$a$-check-BazelRunfiles$getFileByLabel$32.toString());
            }
            return resolved;
        }
        resolved = BazelRunfiles.getBazelJavaRunfilesPath().resolve(manifestKey);
        Intrinsics.checkNotNull((Object)resolved);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(resolved, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl2 = false;
            String string = "Unable to find dependency '" + label.getAsLabel() + "' at " + resolved;
            throw new IllegalStateException(string.toString());
        }
        return resolved;
    }

    @JvmStatic
    @NotNull
    public static final Path findRunfilesDirectoryUnderCommunityOrUltimate(@NotNull String relativePath) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (INSTANCE.getRunfilesManifestOnly()) {
            String root1key = "community+/" + relativePath;
            String root2key = "_main/" + relativePath;
            pair = TuplesKt.to((Object)Path.of(BazelRunfilesManifest.INSTANCE.get(root1key), new String[0]), (Object)Path.of(BazelRunfilesManifest.INSTANCE.get(root2key), new String[0]));
        } else {
            pair = TuplesKt.to((Object)BazelRunfiles.getBazelJavaRunfilesPath().resolve("community+").resolve(relativePath), (Object)BazelRunfiles.getBazelJavaRunfilesPath().resolve("_main").resolve(relativePath));
        }
        Pair pair2 = pair;
        Path root1 = (Path)pair2.component1();
        Path root2 = (Path)pair2.component2();
        Intrinsics.checkNotNull((Object)root1);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean root1exists = Files.isDirectory(root1, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Intrinsics.checkNotNull((Object)root2);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        boolean root2exists = Files.isDirectory(root2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        if (!root1exists && !root2exists) {
            throw new IllegalStateException(("Cannot find runfiles directory " + relativePath + " under community+ or _main. JAVA_RUNFILES (runfiles root) = " + BazelRunfiles.getBazelJavaRunfilesPath() + ". Tried " + root1 + " and " + root2 + ". Please check that you passed this directory via data attribute of test rule").toString());
        }
        if (root1exists && root2exists) {
            throw new IllegalStateException(("Both " + root1 + " and " + root2 + " exist. Meaning " + relativePath + " is available both under community and ultimate roots. This ambitious setup might cause problems. Please remove " + root1 + " or " + root2 + " or use a different relative path for test rule").toString());
        }
        return root1exists ? root1 : root2;
    }

    private final boolean getRunfilesManifestOnly() {
        Lazy lazy = runfilesManifestOnly$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public static final Path getBazelJavaRunfilesPath() {
        Lazy lazy = bazelJavaRunfilesPath$delegate;
        return (Path)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelJavaRunfilesPath$annotations() {
    }

    @NotNull
    public static final Map<String, RepoMappingEntry> getBazelTestRepoMapping() {
        Lazy lazy = bazelTestRepoMapping$delegate;
        return (Map)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getBazelTestRepoMapping$annotations() {
    }

    private final RepoMappingEntry parseRepoEntry(String line) {
        String[] stringArray = new String[]{","};
        List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
        if (!(parts.size() == 3)) {
            boolean bl = false;
            String string = "_repo_mapping line must have exactly 3 comma-separated values: '" + line + "'";
            throw new IllegalArgumentException(string.toString());
        }
        return new RepoMappingEntry((String)parts.get(1), (String)parts.get(2));
    }

    private static final boolean runfilesManifestOnly_delegate$lambda$0() {
        String v = System.getenv(RUNFILES_MANIFEST_ONLY_ENV_NAME);
        return v != null && !StringsKt.isBlank((CharSequence)v) && Intrinsics.areEqual((Object)v, (Object)"1");
    }

    private static final Path bazelJavaRunfilesPath_delegate$lambda$0() {
        String value = System.getenv(JAVA_RUNFILES_ENV_NAME);
        if (value == null) {
            throw new IllegalStateException("Not running under `bazel test` or `bazel run` because JAVA_RUNFILES env is not set.".toString());
        }
        Path path = Path.of(value, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalStateException(("Bazel test env 'JAVA_RUNFILES' points to non-existent directory: " + path3).toString());
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory(path3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new IllegalStateException(("Bazel test env 'JAVA_RUNFILES' points to non-directory: " + path3).toString());
        }
        return path3;
    }

    private static final boolean bazelTestRepoMapping_delegate$lambda$0$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it) && ((CharSequence)it).length() > 0;
    }

    private static final RepoMappingEntry bazelTestRepoMapping_delegate$lambda$0$0$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.parseRepoEntry(it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map bazelTestRepoMapping_delegate$lambda$0() {
        Object object;
        Path path;
        Path path2 = BazelRunfiles.getBazelJavaRunfilesPath().resolve("_repo_mapping");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            path = BazelRunfiles.getBazelJavaRunfilesPath().resolve("_repo_mapping");
        } else {
            Path path4 = Path.of(BazelRunfilesManifest.INSTANCE.get("_repo_mapping"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"of(...)");
            path3 = path4;
            linkOptionArray = new LinkOption[]{};
            if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                path = Path.of(BazelRunfilesManifest.INSTANCE.get("_repo_mapping"), new String[0]);
            } else {
                throw new IllegalStateException("repo_mapping file not found.".toString());
            }
        }
        Path repoMappingFile = path;
        Intrinsics.checkNotNull((Object)repoMappingFile);
        path3 = repoMappingFile;
        Closeable closeable = Files.newBufferedReader(path3, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            object = (BufferedReader)closeable;
            Intrinsics.checkNotNull((Object)object);
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)object);
            boolean bl = false;
            Sequence sequence = SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)lines, BazelRunfiles::bazelTestRepoMapping_delegate$lambda$0$0$0), BazelRunfiles::bazelTestRepoMapping_delegate$lambda$0$0$1));
            boolean $i$f$associateBy = false;
            void var10_12 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                RepoMappingEntry repoMappingEntry = (RepoMappingEntry)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(it.getRepoName(), element$iv$iv);
            }
            object = destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return MapsKt.plus((Map)object, (Pair)TuplesKt.to((Object)"", (Object)new RepoMappingEntry("", "_main")));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/intellij/bazelEnvironment/BazelRunfiles$RepoMappingEntry;", "", "repoName", "", "runfilesRelativePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getRepoName", "()Ljava/lang/String;", "getRunfilesRelativePath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.buildScripts.downloader"})
    public static final class RepoMappingEntry {
        @NotNull
        private final String repoName;
        @NotNull
        private final String runfilesRelativePath;

        public RepoMappingEntry(@NotNull String repoName, @NotNull String runfilesRelativePath) {
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            Intrinsics.checkNotNullParameter((Object)runfilesRelativePath, (String)"runfilesRelativePath");
            this.repoName = repoName;
            this.runfilesRelativePath = runfilesRelativePath;
        }

        @NotNull
        public final String getRepoName() {
            return this.repoName;
        }

        @NotNull
        public final String getRunfilesRelativePath() {
            return this.runfilesRelativePath;
        }

        @NotNull
        public final String component1() {
            return this.repoName;
        }

        @NotNull
        public final String component2() {
            return this.runfilesRelativePath;
        }

        @NotNull
        public final RepoMappingEntry copy(@NotNull String repoName, @NotNull String runfilesRelativePath) {
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            Intrinsics.checkNotNullParameter((Object)runfilesRelativePath, (String)"runfilesRelativePath");
            return new RepoMappingEntry(repoName, runfilesRelativePath);
        }

        public static /* synthetic */ RepoMappingEntry copy$default(RepoMappingEntry repoMappingEntry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = repoMappingEntry.repoName;
            }
            if ((n & 2) != 0) {
                string2 = repoMappingEntry.runfilesRelativePath;
            }
            return repoMappingEntry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "RepoMappingEntry(repoName=" + this.repoName + ", runfilesRelativePath=" + this.runfilesRelativePath + ")";
        }

        public int hashCode() {
            int result2 = this.repoName.hashCode();
            result2 = result2 * 31 + this.runfilesRelativePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepoMappingEntry)) {
                return false;
            }
            RepoMappingEntry repoMappingEntry = (RepoMappingEntry)other;
            if (!Intrinsics.areEqual((Object)this.repoName, (Object)repoMappingEntry.repoName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.runfilesRelativePath, (Object)repoMappingEntry.runfilesRelativePath);
        }
    }
}

