/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/inspections/AddIntermediateCastQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "typeText", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
final class AddIntermediateCastQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String typeText;

    public AddIntermediateCastQuickFix(@NotNull String typeText) {
        Intrinsics.checkNotNullParameter((Object)typeText, (String)"typeText");
        this.typeText = typeText;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.typeText};
        String string = PyPsiBundle.message("QFIX.add.intermediate.cast", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PyCallExpression pyCallExpression = element instanceof PyCallExpression ? (PyCallExpression)element : null;
        if (pyCallExpression == null) {
            return;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression[] pyExpressionArray = call.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
        PyExpression[] args = pyExpressionArray;
        if (args.length != 2) {
            return;
        }
        PyExpression pyExpression = args[1];
        if (pyExpression == null) {
            return;
        }
        PyExpression expr = pyExpression;
        Object object = call.getCallee();
        if (object == null || (object = object.getText()) == null) {
            object = "cast";
        }
        Object calleeText = object;
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)((PsiElement)call));
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"forElement(...)");
        LanguageLevel langLevel = languageLevel;
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)project);
        String castExprText = (String)calleeText + "(" + this.typeText + ", " + expr.getText() + ")";
        PyExpression pyExpression2 = generator.createExpressionFromText(langLevel, castExprText);
        Intrinsics.checkNotNullExpressionValue((Object)pyExpression2, (String)"createExpressionFromText(...)");
        PyExpression newExpr = pyExpression2;
        expr.replace((PsiElement)newExpr);
    }
}

