/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExternalSystemProcessingManagerImpl
implements ExternalSystemProcessingManager,
ExternalSystemTaskNotificationListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalSystemProcessingManagerImpl.class);
    private static final long TOO_LONG_EXECUTION_MS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, Long> myTasksInProgress = new ConcurrentHashMap<ExternalSystemTaskId, Long>();
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, ExternalSystemTask> myTasksDetails = new ConcurrentHashMap<ExternalSystemTaskId, ExternalSystemTask>();
    @NotNull
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private final ExternalSystemFacadeManager myFacadeManager;

    public ExternalSystemProcessingManagerImpl() {
        Application app = ApplicationManager.getApplication();
        this.myFacadeManager = ExternalSystemFacadeManager.getInstance();
        if (app.isUnitTestMode()) {
            return;
        }
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener(this, this);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
    }

    @Override
    public boolean hasTaskOfTypeInProgress(@NotNull ExternalSystemTaskType type, @NotNull Project project) {
        if (type == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(1);
        }
        String projectId = ExternalSystemTaskId.getProjectId((Project)project);
        for (ExternalSystemTaskId id : this.myTasksInProgress.keySet()) {
            if (!type.equals((Object)id.getType()) || !projectId.equals(id.getIdeProjectId())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(2);
        }
        return (ExternalSystemTask)this.myTasksDetails.get(id);
    }

    @Override
    @Nullable
    public ExternalSystemTask findTask(@NotNull ExternalSystemTaskType type, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (type == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(3);
        }
        if (projectSystemId == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(4);
        }
        if (externalProjectPath == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(5);
        }
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || (externalSystemTask = (AbstractExternalSystemTask)task).getId().getType() != type || !externalSystemTask.getExternalSystemId().getId().equals(projectSystemId.getId()) || !externalSystemTask.getExternalProjectPath().equals(externalProjectPath)) continue;
            return task;
        }
        return null;
    }

    @Override
    @NotNull
    public List<ExternalSystemTask> findTasksOfState(@NotNull ProjectSystemId projectSystemId, ExternalSystemTaskState ... taskStates) {
        if (projectSystemId == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(6);
        }
        if (taskStates == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(7);
        }
        SmartList result = new SmartList();
        for (ExternalSystemTask task : this.myTasksDetails.values()) {
            AbstractExternalSystemTask externalSystemTask;
            if (!(task instanceof AbstractExternalSystemTask) || !(externalSystemTask = (AbstractExternalSystemTask)task).getExternalSystemId().getId().equals(projectSystemId.getId()) || !ArrayUtil.contains((Object)externalSystemTask.getState(), (Object[])taskStates)) continue;
            result.add(task);
        }
        SmartList smartList = result;
        if (smartList == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    @Override
    public void add(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(9);
        }
        this.myTasksDetails.put(task.getId(), task);
    }

    @Override
    public void release(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(10);
        }
        this.myTasksDetails.remove(id);
    }

    public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
        if (projectPath == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(11);
        }
        if (id == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(12);
        }
        this.myTasksInProgress.put(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> this.update(), TOO_LONG_EXECUTION_MS);
        }
    }

    public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
        Long prev;
        if (event == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(13);
        }
        if ((prev = this.myTasksInProgress.replace(event.getId(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS)) == null) {
            LOG.warn("onStatusChange is invoked before onStart or after onEnd (event: %s)".formatted(event));
        }
    }

    public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, @NotNull ProcessOutputType processOutputType) {
        Long prev;
        if (id == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(14);
        }
        if (text == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(15);
        }
        if (processOutputType == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(16);
        }
        if ((prev = this.myTasksInProgress.replace(id, System.currentTimeMillis() + TOO_LONG_EXECUTION_MS)) == null) {
            LOG.warn("onTaskOutput is invoked before onStart or after onEnd (id: %s, outputType: %s, text: %s)".formatted(id, processOutputType.toString(), text));
        }
    }

    public void onEnd(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
        if (projectPath == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(17);
        }
        if (id == null) {
            ExternalSystemProcessingManagerImpl.$$$reportNull$$$0(18);
        }
        this.myTasksInProgress.remove(id);
        if (this.myTasksInProgress.isEmpty()) {
            this.myAlarm.cancelAllRequests();
        }
    }

    private void update() {
        long delay = TOO_LONG_EXECUTION_MS;
        HashMap<ExternalSystemTaskId, Long> newState2 = new HashMap<ExternalSystemTaskId, Long>();
        HashMap<ExternalSystemTaskId, Long> currentState = new HashMap<ExternalSystemTaskId, Long>(this.myTasksInProgress);
        if (currentState.isEmpty()) {
            return;
        }
        for (Map.Entry entry : currentState.entrySet()) {
            long diff = System.currentTimeMillis() - (Long)entry.getValue();
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                newState2.put((ExternalSystemTaskId)entry.getKey(), (Long)entry.getValue());
                continue;
            }
            if (!this.myFacadeManager.isTaskActive((ExternalSystemTaskId)entry.getKey())) continue;
            newState2.put((ExternalSystemTaskId)entry.getKey(), System.currentTimeMillis() + TOO_LONG_EXECUTION_MS);
        }
        this.myTasksInProgress.clear();
        this.myTasksInProgress.putAll(newState2);
        if (!newState2.isEmpty()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.update(), delay);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskStates";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemProcessingManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksOfState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasTaskOfTypeInProgress";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTasksOfState";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onStatusChange";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onTaskOutput";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

