/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.AbstractRemoteExternalSystemService;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ;\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/service/remote/RawExternalSystemProjectResolverImpl;", "S", "Lcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;", "Lcom/intellij/openapi/externalSystem/service/remote/AbstractRemoteExternalSystemService;", "Lcom/intellij/openapi/externalSystem/service/remote/RawExternalSystemProjectResolver;", "resolverDelegate", "Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolver;", "<init>", "(Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolver;)V", "resolveProjectInfo", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "projectPath", "", "isPreviewMode", "", "settings", "resolverPolicy", "Lcom/intellij/openapi/externalSystem/importing/ProjectResolverPolicy;", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Ljava/lang/String;ZLcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;Lcom/intellij/openapi/externalSystem/importing/ProjectResolverPolicy;)[B", "cancelTask", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class RawExternalSystemProjectResolverImpl<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemService<S>
implements RawExternalSystemProjectResolver<S> {
    @NotNull
    private final RemoteExternalSystemProjectResolver<S> resolverDelegate;

    public RawExternalSystemProjectResolverImpl(@NotNull RemoteExternalSystemProjectResolver<S> resolverDelegate) {
        Intrinsics.checkNotNullParameter(resolverDelegate, (String)"resolverDelegate");
        this.resolverDelegate = resolverDelegate;
    }

    @Override
    @Nullable
    public byte[] resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable S settings, @Nullable ProjectResolverPolicy resolverPolicy) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        DataNode<ProjectData> dataNode = this.resolverDelegate.resolveProjectInfo(id, projectPath, isPreviewMode, settings, resolverPolicy);
        if (dataNode == null) {
            return null;
        }
        DataNode<ProjectData> result = dataNode;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new ObjectOutputStream(outputStream).writeObject(result);
        return outputStream.toByteArray();
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.resolverDelegate.cancelTask(id);
    }
}

