/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.AddRowAction;
import com.intellij.database.run.actions.GridEditAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class CloneRowAction
extends DumbAwareAction
implements GridEditAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CloneRowAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(1);
        }
        boolean available = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && AddRowAction.canAddRow(dataGrid) && !dataGrid.isEditing();
        e.getPresentation().setEnabledAndVisible(available);
    }

    private static boolean hasTruncatedData(GridRow row) {
        for (int i = 0; i < row.getSize(); ++i) {
            Object value = row.getValue(i);
            if (!(value instanceof LobInfo) || !((LobInfo)value).isTruncated()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ModelIndex selectedRow;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(2);
        }
        ModelIndex modelIndex = selectedRow = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null ? dataGrid.getSelectionModel().getSelectedRow() : null;
        if (selectedRow != null && selectedRow.isValid((CoreGrid)dataGrid)) {
            GridRow row = (GridRow)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(selectedRow);
            if (row != null && CloneRowAction.hasTruncatedData(row)) {
                DataGridSettings settings = GridUtil.getSettings(dataGrid);
                String message = DataGridBundle.message((String)"Console.TableResult.cannotCloneRow", (Object[])new Object[]{settings == null ? 0 : 1});
                Pair<RelativePoint, Balloon.Position> position = GridUtil.getBestPositionForBalloon(dataGrid);
                JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.WARNING, (HyperlinkListener)(settings == null ? null : new GridCopyProvider.ChangeLimitHyperlinkListener(dataGrid, settings))).createBalloon().show((RelativePoint)position.first, (Balloon.Position)position.second);
            } else {
                CloneRowAction.cloneRow(dataGrid, (ModelIndex<GridRow>)selectedRow);
            }
        }
    }

    private static void cloneRow(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowToClone) {
        GridMutator.RowsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            CloneRowAction.$$$reportNull$$$0(3);
        }
        if (rowToClone == null) {
            CloneRowAction.$$$reportNull$$$0(4);
        }
        if ((mutator = GridUtil.getRowsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.cloneRow(GridUtil.newInsertOrCloneRowRequestSource(grid), rowToClone));
            return;
        }
        mutator.cloneRow(GridUtil.newInsertOrCloneRowRequestSource(grid), rowToClone);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CloneRowAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToClone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CloneRowAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

