/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0003\u0012\u0013\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/run/actions/StatisticsShowAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "presentationMode", "Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;", "<init>", "(Lcom/intellij/database/run/ui/table/statisticsPanel/StatisticsPanelMode;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "StatisticsShowOff", "StatisticsShowCompact", "StatisticsShowDetailed", "intellij.grid.impl"})
public abstract class StatisticsShowAction
extends ToggleAction
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final StatisticsPanelMode presentationMode;

    public StatisticsShowAction(@NotNull StatisticsPanelMode presentationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)presentationMode), (String)"presentationMode");
        this.presentationMode = presentationMode;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(GridHelper.Companion.supportsTableStatistics(dataGrid));
        super.update(e);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        ResultView resultView = grid.getResultView();
        TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
        if (tableResultView == null) {
            return false;
        }
        TableResultView tableWithStatistics = tableResultView;
        return tableWithStatistics.getStatisticsPanelMode() == this.presentationMode;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        ResultView resultView = grid.getResultView();
        TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
        if (tableResultView == null) {
            return;
        }
        TableResultView tableWithStatistics = tableResultView;
        tableWithStatistics.setStatisticsPanelMode(this.presentationMode);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/StatisticsShowAction$StatisticsShowCompact;", "Lcom/intellij/database/run/actions/StatisticsShowAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class StatisticsShowCompact
    extends StatisticsShowAction {
        public StatisticsShowCompact() {
            super(StatisticsPanelMode.COMPACT);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/StatisticsShowAction$StatisticsShowDetailed;", "Lcom/intellij/database/run/actions/StatisticsShowAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class StatisticsShowDetailed
    extends StatisticsShowAction {
        public StatisticsShowDetailed() {
            super(StatisticsPanelMode.DETAILED);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/run/actions/StatisticsShowAction$StatisticsShowOff;", "Lcom/intellij/database/run/actions/StatisticsShowAction;", "<init>", "()V", "intellij.grid.impl"})
    public static final class StatisticsShowOff
    extends StatisticsShowAction {
        public StatisticsShowOff() {
            super(StatisticsPanelMode.OFF);
        }
    }
}

