/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.DocumentsSynchronizer;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final RangeMarker myRangeMarker;
    @NotNull
    private final MyDocumentsSynchronizer mySynchronizer;
    private int myAssignments;

    public DocumentFragmentContent(@Nullable Project project, @NotNull DocumentContent original, @NotNull TextRange range) {
        if (original == null) {
            DocumentFragmentContent.$$$reportNull$$$0(0);
        }
        if (range == null) {
            DocumentFragmentContent.$$$reportNull$$$0(1);
        }
        this(project, original, DocumentFragmentContent.createRangeMarker(original.getDocument(), range));
    }

    public DocumentFragmentContent(@Nullable Project project, @NotNull DocumentContent original, @NotNull RangeMarker rangeMarker) {
        if (original == null) {
            DocumentFragmentContent.$$$reportNull$$$0(2);
        }
        if (rangeMarker == null) {
            DocumentFragmentContent.$$$reportNull$$$0(3);
        }
        this.myAssignments = 0;
        this.myOriginal = original;
        this.myRangeMarker = rangeMarker;
        Document document1 = this.myOriginal.getDocument();
        Document document2 = DocumentsSynchronizer.createFakeDocument(document1);
        this.mySynchronizer = new MyDocumentsSynchronizer(project, this.myRangeMarker, document1, document2);
        IntUnaryOperator originalLineConvertor = (IntUnaryOperator)original.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
        this.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value -> {
            if (!this.myRangeMarker.isValid()) {
                return -1;
            }
            int line = value + document1.getLineNumber(this.myRangeMarker.getStartOffset());
            return originalLineConvertor != null ? originalLineConvertor.applyAsInt(line) : line;
        });
    }

    @NotNull
    private static RangeMarker createRangeMarker(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            DocumentFragmentContent.$$$reportNull$$$0(4);
        }
        if (range == null) {
            DocumentFragmentContent.$$$reportNull$$$0(5);
        }
        RangeMarker rangeMarker = document.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        RangeMarker rangeMarker2 = rangeMarker;
        if (rangeMarker2 == null) {
            DocumentFragmentContent.$$$reportNull$$$0(6);
        }
        return rangeMarker2;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.mySynchronizer.getDocument2();
        if (document == null) {
            DocumentFragmentContent.$$$reportNull$$$0(7);
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            DocumentFragmentContent.$$$reportNull$$$0(8);
        }
        if (!this.myRangeMarker.isValid()) {
            return null;
        }
        int offset = position.toOffset(this.getDocument());
        int originalOffset = offset + this.myRangeMarker.getStartOffset();
        LineCol originalPosition = LineCol.fromOffset((Document)this.myOriginal.getDocument(), (int)originalOffset);
        return this.myOriginal.getNavigatable(originalPosition);
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0) {
                this.mySynchronizer.startListen();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0) {
                this.mySynchronizer.stopListen();
            }
        }
        assert (this.myAssignments >= 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/DocumentFragmentContent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/DocumentFragmentContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        @NotNull
        private final RangeMarker myRangeMarker;

        MyDocumentsSynchronizer(@Nullable Project project, @NotNull RangeMarker range, @NotNull Document document1, @NotNull Document document2) {
            if (range == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(0);
            }
            if (document1 == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(1);
            }
            if (document2 == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(2);
            }
            super(project, document1, document2);
            this.myRangeMarker = range;
        }

        @Override
        protected void onDocumentChanged1(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(3);
            }
            if (!this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                try {
                    this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), DiffBundle.message((String)"synchronize.document.and.its.fragment.range.error", (Object[])new Object[0]));
                }
                finally {
                    this.myDocument2.setReadOnly(true);
                }
                return;
            }
            CharSequence newText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), newText);
        }

        @Override
        protected void onDocumentChanged2(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(4);
            }
            if (!this.myRangeMarker.isValid()) {
                return;
            }
            if (!this.myDocument1.isWritable()) {
                return;
            }
            CharSequence newText = event.getNewFragment();
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(this.myDocument1, originalOffset, originalEnd, newText);
        }

        @Override
        public void startListen() {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (this.myRangeMarker.isValid()) {
                    this.myDocument2.setReadOnly(false);
                    CharSequence nexText = this.myRangeMarker.getTextRange().subSequence(this.myDocument1.getCharsSequence());
                    this.myDocument2.setText(nexText);
                    this.myDocument2.setReadOnly(!this.myDocument1.isWritable());
                } else {
                    this.myDocument2.setReadOnly(false);
                    try {
                        this.myDocument2.setText((CharSequence)DiffBundle.message((String)"synchronize.document.and.its.fragment.range.error", (Object[])new Object[0]));
                    }
                    finally {
                        this.myDocument2.setReadOnly(true);
                    }
                }
            }));
            super.startListen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        private void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull CharSequence newText) {
            if (document == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(5);
            }
            if (newText == null) {
                MyDocumentsSynchronizer.$$$reportNull$$$0(6);
            }
            ThreadingAssertions.assertEventDispatchThread();
            try {
                this.myDuringModification = true;
                document.replaceString(startOffset, endOffset, newText);
            }
            finally {
                this.myDuringModification = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document2";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDocumentChanged1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onDocumentChanged2";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

