/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffChangesHolder;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.ThreeState;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SimpleDiffModel {
    @ApiStatus.Internal
    @NotNull
    protected final SimpleDiffViewer myViewer;
    @NotNull
    private final SimpleDiffChangesHolder myDiffChangesHolder;
    @NotNull
    private ThreeState myIsContentsEqual;
    @ApiStatus.Internal
    protected final @NotNull List<@Nullable SimpleDiffChangeUi> myPresentations;

    public SimpleDiffModel(@NotNull SimpleDiffViewer viewer) {
        if (viewer == null) {
            SimpleDiffModel.$$$reportNull$$$0(0);
        }
        this.myDiffChangesHolder = new SimpleDiffChangesHolder();
        this.myIsContentsEqual = ThreeState.UNSURE;
        this.myPresentations = new ArrayList<SimpleDiffChangeUi>();
        this.myViewer = viewer;
    }

    @NotNull
    public ThreeState isContentsEqual() {
        ThreeState threeState = this.myIsContentsEqual;
        if (threeState == null) {
            SimpleDiffModel.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    @NotNull
    public List<SimpleDiffChange> getChanges() {
        List<SimpleDiffChange> list = this.getChanges(Side.LEFT);
        if (list == null) {
            SimpleDiffModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<SimpleDiffChange> getChanges(Side side) {
        List<SimpleDiffChange> list = this.myDiffChangesHolder.getValidChanges(side);
        if (list == null) {
            SimpleDiffModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<SimpleDiffChange> getAllChanges() {
        List<SimpleDiffChange> list = this.myDiffChangesHolder.getAllChanges();
        if (list == null) {
            SimpleDiffModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setChanges(@NotNull List<? extends SimpleDiffChange> changes, boolean isContentsEqual) {
        if (changes == null) {
            SimpleDiffModel.$$$reportNull$$$0(5);
        }
        this.clear();
        for (int i = 0; i < changes.size(); ++i) {
            SimpleDiffChange change = changes.get(i);
            SimpleDiffChange previousChange = i != 0 ? changes.get(i - 1) : null;
            SimpleDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter(previousChange);
            this.myPresentations.add(changeUi);
        }
        this.myDiffChangesHolder.addAll(changes);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.destroyHighlighter();
        }
        this.myDiffChangesHolder.clear();
        this.myPresentations.clear();
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void destroyChange(@NotNull SimpleDiffChange change) {
        SimpleDiffChangeUi changeUi;
        if (change == null) {
            SimpleDiffModel.$$$reportNull$$$0(6);
        }
        if ((changeUi = (SimpleDiffChangeUi)this.myPresentations.set(change.getIndex(), null)) != null) {
            changeUi.destroyHighlighter();
        }
        this.myDiffChangesHolder.invalidateChanges(List.of(change));
        change.markDestroyed();
    }

    public void updateGutterActions(boolean force) {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.updateGutterActions(force);
        }
    }

    public void handleBeforeDocumentChange(@NotNull Side side, @NotNull DocumentEvent e) {
        if (side == null) {
            SimpleDiffModel.$$$reportNull$$$0(7);
        }
        if (e == null) {
            SimpleDiffModel.$$$reportNull$$$0(8);
        }
        if (this.getChanges().isEmpty()) {
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        HashSet<SimpleDiffChange> invalidated = new HashSet<SimpleDiffChange>();
        for (SimpleDiffChange change : this.getChanges()) {
            if (!change.processDocumentChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalidated.add(change);
            SimpleDiffChangeUi changeUi = this.myPresentations.get(change.getIndex());
            if (changeUi == null) continue;
            changeUi.invalidate();
        }
        this.myDiffChangesHolder.invalidateChanges(invalidated);
    }

    public void paintPolygons(@NotNull Graphics2D g, @NotNull JComponent divider) {
        if (g == null) {
            SimpleDiffModel.$$$reportNull$$$0(9);
        }
        if (divider == null) {
            SimpleDiffModel.$$$reportNull$$$0(10);
        }
        MyPaintable paintable = new MyPaintable(this.myPresentations);
        DiffDividerDrawUtil.paintPolygons(g, divider.getWidth(), (Editor)this.myViewer.getEditor1(), (Editor)this.myViewer.getEditor2(), paintable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "divider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "isContentsEqual";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "destroyChange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeDocumentChange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class MyPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        private final @NotNull List<@Nullable SimpleDiffChangeUi> myPresentations;

        private MyPaintable(@NotNull List<@Nullable SimpleDiffChangeUi> presentations) {
            if (presentations == null) {
                MyPaintable.$$$reportNull$$$0(0);
            }
            this.myPresentations = presentations;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                MyPaintable.$$$reportNull$$$0(1);
            }
            for (SimpleDiffChangeUi diffChange : this.myPresentations) {
                boolean keepWalk;
                if (diffChange == null || (keepWalk = diffChange.drawDivider(handler))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffModel$MyPaintable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

