/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.text.TextDiffProvider;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleOnesideDiffViewer
extends OnesideTextDiffViewer {
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final TextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    @NotNull
    private final MyMockFoldingModel myFoldingModel;

    public SimpleOnesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myFoldingModel = new MyMockFoldingModel(this.getProject(), this.getEditor(), (Disposable)this);
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new MyReadOnlyLockAction(this));
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(4);
        }
        Runnable runnable = () -> {
            boolean shouldHighlight;
            this.clearDiffPresentation();
            boolean bl = shouldHighlight = this.getTextSettings().getHighlightPolicy() != HighlightPolicy.DO_NOT_HIGHLIGHT;
            if (shouldHighlight) {
                DocumentContent content = this.getContent();
                Document document = content.getDocument();
                TextDiffType type = (TextDiffType)this.getSide().select((Object)TextDiffType.DELETED, (Object)TextDiffType.INSERTED);
                this.myHighlighters.addAll(DiffDrawUtil.createHighlighter((Editor)this.getEditor(), 0, DiffUtil.getLineCount(document), type, false));
            }
            this.myInitialScrollHelper.onRediff();
        };
        if (runnable == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(5);
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void doScrollToChange(boolean animated) {
        DiffUtil.moveCaret((Editor)this.getEditor(), 0);
        DiffUtil.scrollEditor((Editor)this.getEditor(), 0, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(6);
        }
        if (this.getSide().isLeft()) {
            return false;
        }
        AllLinesIterator allLinesIterator = new AllLinesIterator((Document)this.getEditor().getDocument());
        int line = context.contextMatchCheck((Iterator)allLinesIterator);
        if (line == -1) {
            return false;
        }
        this.scrollToLine(line);
        return true;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(7);
        }
        if (request == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(8);
        }
        return OnesideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(9);
        }
        super.uiDataSnapshot(sink);
        sink.set(DiffDataKeys.CURRENT_CHANGE_RANGE, (Object)new LineRange(0, DiffUtil.getLineCount((Document)this.getEditor().getDocument())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    private class MyInitialScrollHelper
    extends OnesideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleOnesideDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToFirstChange() {
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleOnesideDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition position = (LogicalPosition)SimpleOnesideDiffViewer.this.getSide().select((Object[])this.myCaretPosition);
            SimpleOnesideDiffViewer.this.getEditor().getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint((Editor)SimpleOnesideDiffViewer.this.getEditor(), this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret((Editor)SimpleOnesideDiffViewer.this.getEditor(), false);
            }
            return true;
        }

        @Override
        protected LogicalPosition @Nullable [] getCaretPositions() {
            int index = SimpleOnesideDiffViewer.this.getSide().getIndex();
            int otherIndex = SimpleOnesideDiffViewer.this.getSide().other().getIndex();
            LogicalPosition[] carets = new LogicalPosition[2];
            carets[index] = SimpleOnesideDiffViewer.this.getEditor().getCaretModel().getLogicalPosition();
            carets[otherIndex] = new LogicalPosition(0, 0);
            return carets;
        }
    }

    private static class MyMockFoldingModel
    extends FoldingModelSupport {
        MyMockFoldingModel(@Nullable Project project, @NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                MyMockFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyMockFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, new EditorEx[]{editor}, disposable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer$MyMockFoldingModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction(SimpleOnesideDiffViewer simpleOnesideDiffViewer) {
            super(simpleOnesideDiffViewer.getTextSettings(), simpleOnesideDiffViewer.myFoldingModel);
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        MyReadOnlyLockAction(SimpleOnesideDiffViewer simpleOnesideDiffViewer) {
            super(simpleOnesideDiffViewer.getContext(), simpleOnesideDiffViewer.getEditableEditors());
        }
    }
}

