/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffChangedRangeProvider;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideContentPanel;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ThreesideTextDiffViewerEx
extends ThreesideTextDiffViewer {
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable1;
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable2;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextConflictIterable;
    @NotNull
    protected final StatusPanel myStatusPanel;
    @ApiStatus.Internal
    @NotNull
    protected final MyFoldingModel myFoldingModel;
    @ApiStatus.Internal
    @NotNull
    protected final MyInitialScrollHelper myInitialScrollHelper;
    private int myChangesCount;
    private int myConflictsCount;

    public ThreesideTextDiffViewerEx(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(1);
        }
        super(context, request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myChangesCount = -1;
        this.myConflictsCount = -1;
        this.mySyncScrollable1 = new MySyncScrollable(Side.LEFT);
        this.mySyncScrollable2 = new MySyncScrollable(Side.RIGHT);
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myPrevNextConflictIterable = new MyPrevNextConflictIterable();
        this.myStatusPanel = this.createStatusPanel();
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.getEditors().toArray(new EditorEx[0]), this.myContentPanel, (Disposable)this);
        for (ThreeSide side : ThreeSide.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side), this.myFoldingModel, side.getIndex());
        }
        DiffUtil.registerAction((AnAction)new PrevConflictAction(), this.myPanel);
        DiffUtil.registerAction((AnAction)new NextConflictAction(), this.myPanel);
    }

    @NotNull
    protected StatusPanel createStatusPanel() {
        return new MyStatusPanel();
    }

    @Override
    @RequiresEdt
    protected void onInit() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter(Side.LEFT), Side.LEFT);
        this.myContentPanel.setPainter(new MyDividerPainter(Side.RIGHT), Side.RIGHT);
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.updateContextHints();
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(2);
        }
        return settings;
    }

    @NotNull
    protected Runnable applyNotification(@Nullable JComponent notification) {
        Runnable runnable = () -> {
            this.clearDiffPresentation();
            this.myFoldingModel.destroy();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
        if (runnable == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    @RequiresEdt
    protected void clearDiffPresentation() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
        this.myContentPanel.repaintDividers();
        this.myStatusPanel.update();
    }

    @RequiresEdt
    protected void destroyChangedBlocks() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        if (scrollToPolicy == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ThreesideDiffChangeBase targetChange = scrollToPolicy.select(this.getChanges());
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    protected void doScrollToChange(@NotNull ThreesideDiffChangeBase change, boolean animated) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(5);
        }
        int[] startLines = new int[3];
        int[] endLines = new int[3];
        for (int i = 0; i < 3; ++i) {
            ThreeSide side = ThreeSide.fromIndex((int)i);
            startLines[i] = change.getStartLine(side);
            endLines[i] = change.getEndLine(side);
            DiffUtil.moveCaret((Editor)this.getEditor(side), startLines[i]);
        }
        this.getSyncScrollSupport().makeVisible(this.getCurrentSide(), startLines, endLines, animated);
    }

    public int getChangesCount() {
        return this.myChangesCount;
    }

    public int getConflictsCount() {
        return this.myConflictsCount;
    }

    protected void resetChangeCounters() {
        this.myChangesCount = 0;
        this.myConflictsCount = 0;
    }

    protected void onChangeAdded(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(6);
        }
        if (change.isConflict()) {
            ++this.myConflictsCount;
        } else {
            ++this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    protected void onChangeRemoved(@NotNull ThreesideDiffChangeBase change) {
        if (change == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(7);
        }
        if (change.isConflict()) {
            --this.myConflictsCount;
        } else {
            --this.myChangesCount;
        }
        this.myStatusPanel.update();
    }

    @NotNull
    protected abstract DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side var1);

    @NotNull
    public List<? extends ThreesideDiffChangeBase> getAllChanges() {
        List<? extends ThreesideDiffChangeBase> list = this.getChanges();
        if (list == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    protected abstract @Unmodifiable List<? extends ThreesideDiffChangeBase> getChanges();

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side side) {
        if (side == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(9);
        }
        SyncScrollSupport.SyncScrollable syncScrollable = (SyncScrollSupport.SyncScrollable)side.select((Object)this.mySyncScrollable1, (Object)this.mySyncScrollable2);
        if (syncScrollable == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(10);
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(11);
        }
        return statusPanel;
    }

    @NotNull
    public SyncScrollSupport.ThreesideSyncScrollSupport getSyncScrollSupport() {
        SyncScrollSupport.ThreesideSyncScrollSupport threesideSyncScrollSupport = this.mySyncScrollSupport;
        if (threesideSyncScrollSupport == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(12);
        }
        return threesideSyncScrollSupport;
    }

    @RequiresEdt
    @Nullable
    protected ThreesideDiffChangeBase getSelectedChange(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int caretLine = this.getEditor((ThreeSide)side).getCaretModel().getLogicalPosition().line;
        for (ThreesideDiffChangeBase threesideDiffChangeBase : this.getChanges()) {
            int line2;
            int line1 = threesideDiffChangeBase.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = threesideDiffChangeBase.getEndLine(side))) continue;
            return threesideDiffChangeBase;
        }
        return null;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public PrevNextDifferenceIterable getDifferenceIterable() {
        return this.myPrevNextDifferenceIterable;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ThreesideTextDiffViewerEx.$$$reportNull$$$0(14);
        }
        super.uiDataSnapshot(sink);
        ThreesideDiffChangeBase change = this.getSelectedChange(this.getCurrentSide());
        if (change != null) {
            sink.set(DiffDataKeys.CURRENT_CHANGE_RANGE, (Object)new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide())));
        }
        sink.set(DiffDataKeys.EDITOR_CHANGED_RANGE_PROVIDER, (Object)new MyChangedRangeProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToPolicy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyNotification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncScrollSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onChangeAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onChangeRemoved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSyncScrollable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    protected final class MyInitialScrollHelper
    extends ThreesideTextDiffViewer.MyInitialScrollPositionHelper {
        protected MyInitialScrollHelper() {
            super(ThreesideTextDiffViewerEx.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return ThreesideTextDiffViewerEx.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return ThreesideTextDiffViewerEx.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }
    }

    protected class MySyncScrollable
    extends BaseSyncScrollable {
        @NotNull
        private final Side mySide;

        public MySyncScrollable(Side side) {
            if (side == null) {
                MySyncScrollable.$$$reportNull$$$0(0);
            }
            this.mySide = side;
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return ThreesideTextDiffViewerEx.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                MySyncScrollable.$$$reportNull$$$0(1);
            }
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            if (!helper.process(0, 0)) {
                return;
            }
            for (ThreesideDiffChangeBase threesideDiffChangeBase : ThreesideTextDiffViewerEx.this.getAllChanges()) {
                if (!helper.process(threesideDiffChangeBase.getStartLine(left), threesideDiffChangeBase.getStartLine(right))) {
                    return;
                }
                if (helper.process(threesideDiffChangeBase.getEndLine(left), threesideDiffChangeBase.getEndLine(right))) continue;
                return;
            }
            helper.process(DiffUtil.getLineCount((Document)ThreesideTextDiffViewerEx.this.getEditor(left).getDocument()), DiffUtil.getLineCount((Document)ThreesideTextDiffViewerEx.this.getEditor(right).getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MySyncScrollable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processHelper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<ThreesideDiffChangeBase> {
        protected MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<? extends ThreesideDiffChangeBase> getChanges() {
            List<? extends ThreesideDiffChangeBase> changes = ThreesideTextDiffViewerEx.this.getChanges();
            ThreeSide currentSide = ThreesideTextDiffViewerEx.this.getCurrentSide();
            if (currentSide == ThreeSide.BASE) {
                List<? extends ThreesideDiffChangeBase> list = changes;
                if (list == null) {
                    MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
                }
                return list;
            }
            List list = ContainerUtil.filter(changes, change -> change.isChange(currentSide));
            if (list == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = ThreesideTextDiffViewerEx.this.getCurrentEditor();
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getStartLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected int getEndLine(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(4);
            }
            return change.getEndLine(ThreesideTextDiffViewerEx.this.getCurrentSide());
        }

        @Override
        protected void scrollToChange(@NotNull ThreesideDiffChangeBase change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(5);
            }
            ThreesideTextDiffViewerEx.this.doScrollToChange(change, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "scrollToChange";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyPrevNextConflictIterable
    extends MyPrevNextDifferenceIterable {
        private MyPrevNextConflictIterable() {
        }

        @Override
        @NotNull
        protected List<? extends ThreesideDiffChangeBase> getChanges() {
            List<? extends ThreesideDiffChangeBase> changes = ThreesideTextDiffViewerEx.this.getChanges();
            List list = ContainerUtil.filter(changes, change -> change.isConflict());
            if (list == null) {
                MyPrevNextConflictIterable.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyPrevNextConflictIterable", "getChanges"));
        }
    }

    protected static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable1;
        private final FoldingModelSupport.MyPaintable myPaintable2;
        private final ThreesideContentPanel myContentPanel;

        public MyFoldingModel(@Nullable Project project, EditorEx @NotNull [] editors, @NotNull ThreesideContentPanel contentPanel2, @NotNull Disposable disposable) {
            if (contentPanel2 == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            if (editors == null) {
                MyFoldingModel.$$$reportNull$$$0(2);
            }
            super(project, editors, disposable);
            this.myPaintable1 = new FoldingModelSupport.MyPaintable(this, 0, 1);
            this.myPaintable2 = new FoldingModelSupport.MyPaintable(this, 1, 2);
            this.myContentPanel = contentPanel2;
            assert (editors.length == 3);
        }

        @Override
        protected void repaintSeparators() {
            this.myContentPanel.repaint();
        }

        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends MergeLineFragment> fragments, @NotNull FoldingModelSupport.Settings settings) {
            if (settings == null) {
                MyFoldingModel.$$$reportNull$$$0(3);
            }
            return this.createState(fragments, MyFoldingModel.countLines(this.myEditors), settings);
        }

        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends MergeLineFragment> fragments, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull FoldingModelSupport.Settings settings) {
            if (lineOffsets == null) {
                MyFoldingModel.$$$reportNull$$$0(4);
            }
            if (settings == null) {
                MyFoldingModel.$$$reportNull$$$0(5);
            }
            int[] lineCount = new int[this.myEditors.length];
            for (int i = 0; i < this.myEditors.length; ++i) {
                lineCount[i] = lineOffsets.get(i).getLineCount();
            }
            return this.createState(fragments, lineCount, settings);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        private FoldingModelSupport.Data createState(@Nullable List<? extends MergeLineFragment> fragments, int @NotNull [] lineCount, @NotNull FoldingModelSupport.Settings settings) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Nullable
        private FoldingModelSupport.Data computeFoldedRanges(@Nullable Iterator<int[]> changedLines, int @NotNull [] lineCount, @NotNull FoldingModelSupport.Settings settings) {
            if (settings == null) {
                MyFoldingModel.$$$reportNull$$$0(8);
            }
            if (lineCount == null) {
                MyFoldingModel.$$$reportNull$$$0(9);
            }
            if (changedLines == null || settings.range == -1) {
                return null;
            }
            MyFoldingBuilder builder = new MyFoldingBuilder(this.myEditors, lineCount, settings);
            return builder.build(changedLines);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider, @NotNull Side side) {
            if (gg == null) {
                MyFoldingModel.$$$reportNull$$$0(10);
            }
            if (divider == null) {
                MyFoldingModel.$$$reportNull$$$0(11);
            }
            if (side == null) {
                MyFoldingModel.$$$reportNull$$$0(12);
            }
            FoldingModelSupport.MyPaintable paintable = (FoldingModelSupport.MyPaintable)side.select((Object)this.myPaintable1, (Object)this.myPaintable2);
            paintable.paintOnDivider(gg, divider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineOffsets";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineCount";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gg";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeFoldedRanges";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintOnDivider";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class MyFoldingBuilder
        extends FoldingModelSupport.FoldingBuilderBase {
            private final EditorEx @NotNull [] myEditors;

            private MyFoldingBuilder(EditorEx @NotNull [] editors, int @NotNull [] lineCount, @NotNull FoldingModelSupport.Settings settings) {
                if (settings == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(0);
                }
                if (editors == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(1);
                }
                if (lineCount == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(2);
                }
                super(lineCount, settings);
                this.myEditors = editors;
            }

            @Override
            @Nullable
            protected FoldingModelSupport.FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
                if (project == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(3);
                }
                return FoldingModelSupport.getLineSeparatorDescription(project, (Document)this.myEditors[index].getDocument(), lineNumber);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editors";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineCount";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyFoldingModel$MyFoldingBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class PrevConflictAction
    extends DumbAwareAction {
        PrevConflictAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.PreviousConflict");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                PrevConflictAction.$$$reportNull$$$0(0);
            }
            if (!ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.canGoPrev()) {
                return;
            }
            ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.goPrev();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$PrevConflictAction", "actionPerformed"));
        }
    }

    private class NextConflictAction
    extends DumbAwareAction {
        NextConflictAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.NextConflict");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NextConflictAction.$$$reportNull$$$0(0);
            }
            if (!ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.canGoNext()) {
                return;
            }
            ThreesideTextDiffViewerEx.this.myPrevNextConflictIterable.goNext();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$NextConflictAction", "actionPerformed"));
        }
    }

    protected class MyStatusPanel
    extends StatusPanel {
        protected MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            if (ThreesideTextDiffViewerEx.this.myChangesCount < 0 || ThreesideTextDiffViewerEx.this.myConflictsCount < 0) {
                return null;
            }
            if (ThreesideTextDiffViewerEx.this.myChangesCount == 0 && ThreesideTextDiffViewerEx.this.myConflictsCount == 0) {
                return DiffBundle.message((String)"merge.dialog.all.conflicts.resolved.message.text", (Object[])new Object[0]);
            }
            return DiffBundle.message((String)"merge.differences.status.text", (Object[])new Object[]{ThreesideTextDiffViewerEx.this.myChangesCount, ThreesideTextDiffViewerEx.this.myConflictsCount});
        }
    }

    protected class MyDividerPainter
    implements DiffSplitter.Painter {
        @NotNull
        private final Side mySide;
        @NotNull
        private final DiffDividerDrawUtil.DividerPaintable myPaintable;

        public MyDividerPainter(Side side) {
            if (side == null) {
                MyDividerPainter.$$$reportNull$$$0(0);
            }
            this.mySide = side;
            this.myPaintable = ThreesideTextDiffViewerEx.this.getDividerPaintable(side);
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                MyDividerPainter.$$$reportNull$$$0(1);
            }
            if (divider == null) {
                MyDividerPainter.$$$reportNull$$$0(2);
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE).getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor((Editor)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE)));
            gg.fill(gg.getClipBounds());
            Editor editor1 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.LEFT), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE));
            Editor editor2 = (Editor)this.mySide.select((Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.BASE), (Object)ThreesideTextDiffViewerEx.this.getEditor(ThreeSide.RIGHT));
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), editor1, editor2, this.myPaintable);
            ThreesideTextDiffViewerEx.this.myFoldingModel.paintOnDivider(gg, divider, this.mySide);
            gg.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "divider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyDividerPainter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyChangedRangeProvider
    implements DiffChangedRangeProvider {
        private MyChangedRangeProvider() {
        }

        @Override
        @Nullable
        public List<TextRange> getChangedRanges(@NotNull Editor editor) {
            ThreeSide side;
            if (editor == null) {
                MyChangedRangeProvider.$$$reportNull$$$0(0);
            }
            if ((side = ThreeSide.fromValue(ThreesideTextDiffViewerEx.this.getEditors(), (Object)editor)) == null) {
                return null;
            }
            return ContainerUtil.map(ThreesideTextDiffViewerEx.this.getAllChanges(), change -> DiffUtil.getLinesRange(editor.getDocument(), change.getStartLine(side), change.getEndLine(side)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/simple/ThreesideTextDiffViewerEx$MyChangedRangeProvider", "getChangedRanges"));
        }
    }

    protected class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        public MyToggleExpandByDefaultAction(ThreesideTextDiffViewerEx this$0) {
            super(this$0.getTextSettings(), this$0.myFoldingModel);
        }
    }
}

