/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.bridge.ScrollbarHelper;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeScrollbarKt;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.ui.component.styling.ScrollbarVisibility;
import org.jetbrains.jewel.ui.component.styling.TrackClickBehavior;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J$\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J)\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0!H\u0002\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0001H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006'"}, d2={"Lorg/jetbrains/jewel/bridge/MacScrollbarHelperImpl;", "Lcom/sun/jna/Callback;", "Lorg/jetbrains/jewel/bridge/ScrollbarHelper;", "<init>", "()V", "logger", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "_scrollbarVisibilityStyleFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/jewel/ui/component/styling/ScrollbarVisibility;", "scrollbarVisibilityStyleFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getScrollbarVisibilityStyleFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "_trackClickBehaviorFlow", "Lorg/jetbrains/jewel/ui/component/styling/TrackClickBehavior;", "trackClickBehaviorFlow", "getTrackClickBehaviorFlow", "listenToTrackClickBehaviorChange", "", "listenToScrollbarVisibilityChange", "callback", "self", "Lcom/intellij/ui/mac/foundation/ID;", "selector", "Lcom/sun/jna/Pointer;", "event", "readTrackClickBehavior", "readScrollbarVisibility", "callMac", "T", "", "producer", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createDelegate", "name", "", "pointer", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nScrollbarHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollbarHelper.kt\norg/jetbrains/jewel/bridge/MacScrollbarHelperImpl\n+ 2 JewelLogger.kt\norg/jetbrains/jewel/foundation/util/JewelLoggerKt\n*L\n1#1,183:1\n9#2:184\n*S KotlinDebug\n*F\n+ 1 ScrollbarHelper.kt\norg/jetbrains/jewel/bridge/MacScrollbarHelperImpl\n*L\n31#1:184\n*E\n"})
final class MacScrollbarHelperImpl
implements Callback,
ScrollbarHelper {
    @NotNull
    private final JewelLogger logger;
    @NotNull
    private final MutableStateFlow<ScrollbarVisibility> _scrollbarVisibilityStyleFlow;
    @NotNull
    private final StateFlow<ScrollbarVisibility> scrollbarVisibilityStyleFlow;
    @NotNull
    private final MutableStateFlow<TrackClickBehavior> _trackClickBehaviorFlow;
    @NotNull
    private final StateFlow<TrackClickBehavior> trackClickBehaviorFlow;

    public MacScrollbarHelperImpl() {
        MacScrollbarHelperImpl $this$myLogger$iv = this;
        boolean $i$f$myLogger = false;
        this.logger = JewelLogger.Companion.getInstance(MacScrollbarHelperImpl.class);
        this._scrollbarVisibilityStyleFlow = StateFlowKt.MutableStateFlow((Object)IntUiBridgeScrollbarKt.default(ScrollbarVisibility.AlwaysVisible.Companion));
        this.scrollbarVisibilityStyleFlow = (StateFlow)this._scrollbarVisibilityStyleFlow;
        this._trackClickBehaviorFlow = StateFlowKt.MutableStateFlow((Object)TrackClickBehavior.JumpToSpot);
        this.trackClickBehaviorFlow = (StateFlow)this._trackClickBehaviorFlow;
        if (OsArch_jvmKt.getHostOs() != OS.MacOS) {
            this.logger.error(this.getClass().getSimpleName() + " should only be initialized on macOS.");
        } else {
            this.callback(null, null, null);
            this.listenToTrackClickBehaviorChange();
            this.listenToScrollbarVisibilityChange();
        }
    }

    @Override
    @NotNull
    public StateFlow<ScrollbarVisibility> getScrollbarVisibilityStyleFlow() {
        return this.scrollbarVisibilityStyleFlow;
    }

    @Override
    @NotNull
    public StateFlow<TrackClickBehavior> getTrackClickBehaviorFlow() {
        return this.trackClickBehaviorFlow;
    }

    private final void listenToTrackClickBehaviorChange() {
        this.callMac(() -> MacScrollbarHelperImpl.listenToTrackClickBehaviorChange$lambda$0(this));
    }

    private final void listenToScrollbarVisibilityChange() {
        this.callMac(() -> MacScrollbarHelperImpl.listenToScrollbarVisibilityChange$lambda$0(this));
    }

    public final void callback(@Nullable ID self, @Nullable Pointer selector, @Nullable ID event) {
        this.readTrackClickBehavior();
        this.readScrollbarVisibility();
    }

    private final void readTrackClickBehavior() {
        this.callMac(() -> MacScrollbarHelperImpl.readTrackClickBehavior$lambda$0(this));
    }

    private final void readScrollbarVisibility() {
        this.callMac(() -> MacScrollbarHelperImpl.readScrollbarVisibility$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T callMac(Function0<? extends T> producer) {
        if (!SystemInfoRt.isMac) {
            return null;
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            Object object = producer.invoke();
            return (T)object;
        }
        catch (Throwable e) {
            this.logger.warn(e);
        }
        finally {
            pool.drain();
        }
        return null;
    }

    private final ID createDelegate(String name, Pointer pointer, Callback callback) {
        ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)name);
        if (!Intrinsics.areEqual((Object)ID.NIL, (Object)delegateClass)) {
            if (!Foundation.addMethod((ID)delegateClass, (Pointer)pointer, (Callback)callback, (String)"v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            Foundation.registerObjcClassPair((ID)delegateClass);
        }
        ID iD = Foundation.invoke((String)name, (String)"new", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"invoke(...)");
        return iD;
    }

    private static final ID listenToTrackClickBehaviorChange$lambda$0(MacScrollbarHelperImpl this$0) {
        ID iD = Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]);
        Object[] objectArray = new Object[5];
        Pointer pointer = Foundation.createSelector((String)"handleBehaviorChanged:");
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"createSelector(...)");
        objectArray[0] = this$0.createDelegate("JewelScrollbarTrackClickBehaviorObserver", pointer, this$0);
        objectArray[1] = Foundation.createSelector((String)"handleBehaviorChanged:");
        objectArray[2] = Foundation.nsString((String)"AppleNoRedisplayAppearancePreferenceChanged");
        objectArray[3] = ID.NIL;
        objectArray[4] = 2;
        return Foundation.invoke((ID)iD, (String)"addObserver:selector:name:object:", (Object[])objectArray);
    }

    private static final ID listenToScrollbarVisibilityChange$lambda$0(MacScrollbarHelperImpl this$0) {
        ID iD = Foundation.invoke((String)"NSNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]);
        Object[] objectArray = new Object[4];
        Pointer pointer = Foundation.createSelector((String)"handleScrollerStyleChanged:");
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"createSelector(...)");
        objectArray[0] = this$0.createDelegate("JewelScrollbarVisibilityObserver", pointer, this$0);
        objectArray[1] = Foundation.createSelector((String)"handleScrollerStyleChanged:");
        objectArray[2] = Foundation.nsString((String)"NSPreferredScrollerStyleDidChangeNotification");
        objectArray[3] = ID.NIL;
        return Foundation.invoke((ID)iD, (String)"addObserver:selector:name:object:", (Object[])objectArray);
    }

    private static final Unit readTrackClickBehavior$lambda$0(MacScrollbarHelperImpl this$0) {
        ID userDefaults = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
        Foundation.invoke((ID)userDefaults, (String)"synchronize", (Object[])new Object[0]);
        Object[] objectArray = new Object[]{Foundation.nsString((String)"AppleScrollerPagingBehavior")};
        boolean isJumpToPage = Foundation.invoke((ID)userDefaults, (String)"boolForKey:", (Object[])objectArray).booleanValue();
        TrackClickBehavior behavior = isJumpToPage ? TrackClickBehavior.JumpToSpot : TrackClickBehavior.NextPage;
        this$0.logger.debug("Scrollbar track click behavior: " + behavior);
        this$0._trackClickBehaviorFlow.setValue((Object)behavior);
        return Unit.INSTANCE;
    }

    private static final Unit readScrollbarVisibility$lambda$0(MacScrollbarHelperImpl this$0) {
        boolean isOverlayStyle = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSScroller"), (String)"preferredScrollerStyle", (Object[])new Object[0]).booleanValue();
        ScrollbarVisibility visibility = isOverlayStyle ? (ScrollbarVisibility)IntUiBridgeScrollbarKt.macOs-TZvXluI$default(ScrollbarVisibility.WhenScrolling.Companion, 0.0f, 0.0f, null, null, 0L, 0L, 0L, 0L, 255, null) : (ScrollbarVisibility)IntUiBridgeScrollbarKt.macOs-fYp4AQw$default(ScrollbarVisibility.AlwaysVisible.Companion, 0.0f, null, 0L, 0L, 0L, 31, null);
        this$0.logger.debug("Scrollbar visibility style: " + visibility);
        this$0._scrollbarVisibilityStyleFlow.setValue((Object)visibility);
        return Unit.INSTANCE;
    }
}

