/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.icons.PatchedIconDescriptor;
import com.intellij.ui.icons.RasterizedImageDataLoader;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.ui.svg.SvgCacheClassifier;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgCacheManagerKt;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000bH\u0007\u001aB\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002\u001aR\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u001aE\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"loadRasterizedIcon", "Ljavax/swing/Icon;", "path", "", "expUIPath", "classLoader", "Ljava/lang/ClassLoader;", "cacheKey", "", "flags", "toolTip", "Ljava/util/function/Supplier;", "loadRasterized", "Ljava/awt/Image;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "isSvg", "", "rasterizedCacheKey", "imageFlags", "loadPatched", "name", "ext", "scale", "", "isEffectiveDark", "loadSvgFromClassResource", "precomputedCacheKey", "compoundCacheKey", "Lcom/intellij/ui/svg/SvgCacheClassifier;", "colorPatcherProvider", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "loadSvgFromClassResource-RA_vzyY", "(Ljava/lang/ClassLoader;Ljava/lang/String;IFILcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;)Ljava/awt/Image;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nRasterizedImageDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/RasterizedImageDataLoaderKt\n+ 2 svg.kt\ncom/intellij/ui/svg/SvgKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n202#2,34:310\n239#2,7:345\n238#2:352\n13#3:344\n*S KotlinDebug\n*F\n+ 1 RasterizedImageDataLoader.kt\ncom/intellij/ui/icons/RasterizedImageDataLoaderKt\n*L\n300#1:310,34\n300#1:345,7\n300#1:352\n300#1:344\n*E\n"})
public final class RasterizedImageDataLoaderKt {
    @ApiStatus.Internal
    @NotNull
    public static final Icon loadRasterizedIcon(@NotNull String path, @Nullable String expUIPath, @NotNull ClassLoader classLoader, int cacheKey, int flags, @Nullable Supplier<String> toolTip) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        boolean bl2 = bl = !StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new CachedImageIcon(new RasterizedImageDataLoader(path, expUIPath, new WeakReference<ClassLoader>(classLoader), cacheKey, flags), toolTip);
    }

    private static final Image loadRasterized(String path, ScaleContext scaleContext, LoadIconParameters parameters, ClassLoader classLoader, boolean isSvg, int rasterizedCacheKey, int imageFlags) {
        Image image;
        String string;
        boolean isRetina;
        String string2;
        float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex < 0) {
            string2 = path;
        } else {
            String string3 = path.substring(0, dotIndex);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String name = string2;
        boolean bl = isRetina = !(scale == 1.0f);
        if (isSvg) {
            string = "svg";
        } else if (dotIndex < 0 || dotIndex == path.length() - 1) {
            string = "";
        } else {
            String string4 = path.substring(dotIndex + 1);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        String ext = string;
        boolean isEffectiveDark = parameters.isDark;
        Object effectivePath = null;
        float nonSvgScale = 0.0f;
        if (parameters.isStroke && (imageFlags & 8) == 8) {
            effectivePath = name + "_stroke." + ext;
            nonSvgScale = 1.0f;
        } else if (isRetina && parameters.isDark && (imageFlags & 4) == 4) {
            effectivePath = name + "@2x_dark." + ext;
            nonSvgScale = 2.0f;
        } else if (parameters.isDark && (imageFlags & 2) == 2) {
            effectivePath = name + "_dark." + ext;
            nonSvgScale = 1.0f;
        } else {
            isEffectiveDark = false;
            if (isRetina && (imageFlags & 1) == 1) {
                effectivePath = name + "@2x." + ext;
                nonSvgScale = 2.0f;
            } else {
                effectivePath = path;
                nonSvgScale = 1.0f;
            }
        }
        Image image2 = image = isSvg ? RasterizedImageDataLoaderKt.loadSvgFromClassResource-RA_vzyY(classLoader, (String)effectivePath, rasterizedCacheKey, scale, SvgCacheClassifier.constructor-impl(scale, isEffectiveDark, parameters.isStroke), parameters.colorPatcher) : (Image)IconUtilKt.loadPngFromClassResource$default((String)effectivePath, classLoader, null, 4, null);
        if (image2 == null) {
            return null;
        }
        return IconUtilKt.convertImage(image2, parameters.filters, scaleContext, !isSvg, nonSvgScale);
    }

    private static final Image loadPatched(String name, String ext, boolean isSvg, float scale, ScaleContext scaleContext, LoadIconParameters parameters, String path, ClassLoader classLoader, boolean isEffectiveDark) {
        List list;
        PatchedIconDescriptor stroke = new PatchedIconDescriptor(name + "_stroke." + ext, isSvg ? scale : 1.0f);
        PatchedIconDescriptor retinaDark = new PatchedIconDescriptor(name + "@2x_dark." + ext, isSvg ? scale : 2.0f);
        PatchedIconDescriptor dark = new PatchedIconDescriptor(name + "_dark." + ext, isSvg ? scale : 1.0f);
        PatchedIconDescriptor retina = new PatchedIconDescriptor(name + "@2x." + ext, isSvg ? scale : 2.0f);
        PatchedIconDescriptor plain = new PatchedIconDescriptor(path, isSvg ? scale : 1.0f);
        boolean isRetina = !(scale == 1.0f);
        if (parameters.isStroke) {
            var16_15 = new PatchedIconDescriptor[]{stroke, plain};
            list = CollectionsKt.listOf((Object[])var16_15);
        } else if (isRetina && parameters.isDark) {
            var16_15 = new PatchedIconDescriptor[]{retinaDark, dark, retina, plain};
            list = CollectionsKt.listOf((Object[])var16_15);
        } else if (parameters.isDark) {
            var16_15 = new PatchedIconDescriptor[]{dark, plain};
            list = CollectionsKt.listOf((Object[])var16_15);
        } else if (isRetina) {
            var16_15 = new PatchedIconDescriptor[]{retina, plain};
            list = CollectionsKt.listOf((Object[])var16_15);
        } else {
            list = CollectionsKt.listOf((Object)plain);
        }
        List descriptors = list;
        for (PatchedIconDescriptor descriptor : descriptors) {
            Image image = isSvg ? RasterizedImageDataLoaderKt.loadSvgFromClassResource-RA_vzyY(classLoader, descriptor.name, 0, descriptor.scale, SvgCacheClassifier.constructor-impl(descriptor.scale, isEffectiveDark, parameters.isStroke), parameters.colorPatcher) : (Image)IconUtilKt.loadPngFromClassResource$default(descriptor.name, classLoader, null, 4, null);
            if (image == null) continue;
            return IconUtilKt.convertImage(image, parameters.filters, scaleContext, !isSvg && (descriptor == plain || descriptor == dark), descriptor.scale);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Image loadSvgFromClassResource-RA_vzyY(ClassLoader classLoader, String path, int precomputedCacheKey, float scale, int compoundCacheKey, SVGLoader.SvgElementColorPatcherProvider colorPatcherProvider) {
        void colorPatcherDigest$iv;
        void compoundCacheKey$iv;
        boolean bl;
        byte[] byArray;
        void precomputedCacheKey$iv;
        boolean isPrecomputedKey$iv;
        void path$iv;
        BufferedImage bufferedImage;
        void colorPatcher$iv;
        void scale$iv;
        long[] lArray = SvgKt.colorPatcherDigestShim(colorPatcherProvider);
        SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider = colorPatcherProvider;
        SvgAttributePatcher svgAttributePatcher = svgElementColorPatcherProvider != null ? svgElementColorPatcherProvider.attributeForPath(path) : null;
        String string = path;
        int n = precomputedCacheKey;
        float f = scale;
        int n2 = compoundCacheKey;
        SvgAttributePatcher svgAttributePatcher2 = svgAttributePatcher;
        long[] lArray2 = lArray;
        boolean bl2 = false;
        SvgCacheManager svgCache$iv = SvgKt.getActiveSvgCache();
        if (svgCache$iv == null || scale$iv > 4.0f) {
            void var27_16 = colorPatcher$iv;
            boolean bl3 = false;
            byte[] byArray2 = IconUtilKt.getResourceData(path, null, classLoader);
            if (byArray2 == null) {
                Object var17_20 = null;
                bufferedImage = var17_20;
                return bufferedImage;
            }
            bufferedImage = SvgKt.access$renderImage((SvgAttributePatcher)var27_16, byArray2, (float)scale$iv, (String)path$iv);
            return bufferedImage;
        }
        boolean bl4 = isPrecomputedKey$iv = precomputedCacheKey$iv != false;
        if (isPrecomputedKey$iv) {
            byArray = null;
        } else {
            bl = false;
            byArray = IconUtilKt.getResourceData(path, null, classLoader);
            if (byArray == null) {
                bufferedImage = null;
                return bufferedImage;
            }
        }
        byte[] data$iv = byArray;
        long[] key$iv = data$iv == null ? SvgCacheManagerKt.createPrecomputedIconCacheKey-2Mr4RHQ((int)precomputedCacheKey$iv, (int)compoundCacheKey$iv, (long[])colorPatcherDigest$iv) : SvgCacheManagerKt.createIconCacheKey-2Mr4RHQ(data$iv, (int)compoundCacheKey$iv, (long[])colorPatcherDigest$iv);
        try {
            long start$iv = StartUpMeasurer.getCurrentTimeIfEnabled();
            BufferedImage result$iv = svgCache$iv.loadFromCache(key$iv, data$iv == null);
            if (start$iv != -1L) {
                IconLoadMeasurer.svgCacheRead.end(start$iv);
            }
            BufferedImage bufferedImage2 = result$iv;
            if (bufferedImage2 != null) {
                BufferedImage it$iv = bufferedImage2;
                boolean bl5 = false;
                bufferedImage = it$iv;
                return bufferedImage;
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            svgCache$iv.markCorrupted();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SVGLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot load from icon cache (path=" + (String)path$iv + ", precomputedCacheKey=" + (int)precomputedCacheKey$iv + ")", e$iv);
        }
        void v7 = colorPatcher$iv;
        byte[] byArray3 = data$iv;
        if (data$iv == null) {
            void var27_17 = v7;
            bl = false;
            byte[] byArray4 = IconUtilKt.getResourceData(path, null, classLoader);
            v7 = var27_17;
            byArray3 = byArray4;
            if (byArray4 == null) {
                Object var17_21 = null;
                bufferedImage = var17_21;
                return bufferedImage;
            }
        }
        bufferedImage = SvgKt.access$renderAndCache((SvgAttributePatcher)v7, byArray3, (float)scale$iv, (String)path$iv, key$iv, svgCache$iv, isPrecomputedKey$iv);
        return bufferedImage;
    }

    public static final /* synthetic */ Image access$loadRasterized(String path, ScaleContext scaleContext, LoadIconParameters parameters, ClassLoader classLoader, boolean isSvg, int rasterizedCacheKey, int imageFlags) {
        return RasterizedImageDataLoaderKt.loadRasterized(path, scaleContext, parameters, classLoader, isSvg, rasterizedCacheKey, imageFlags);
    }

    public static final /* synthetic */ Image access$loadPatched(String name, String ext, boolean isSvg, float scale, ScaleContext scaleContext, LoadIconParameters parameters, String path, ClassLoader classLoader, boolean isEffectiveDark) {
        return RasterizedImageDataLoaderKt.loadPatched(name, ext, isSvg, scale, scaleContext, parameters, path, classLoader, isEffectiveDark);
    }
}

